/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.NavigableSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.client.ClientUtil;
import org.apache.hadoop.hbase.client.Consistency;
import org.apache.hadoop.hbase.client.Cursor;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.IsolationLevel;
import org.apache.hadoop.hbase.client.Query;
import org.apache.hadoop.hbase.client.metrics.ScanMetrics;
import org.apache.hadoop.hbase.filter.Filter;
import org.apache.hadoop.hbase.filter.IncompatibleFilterException;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.security.access.Permission;
import org.apache.hadoop.hbase.security.visibility.Authorizations;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Public
public class Scan
extends Query {
    private static final Logger LOG = LoggerFactory.getLogger(Scan.class);
    private static final String RAW_ATTR = "_raw_";
    private byte[] startRow = HConstants.EMPTY_START_ROW;
    private boolean includeStartRow = true;
    private byte[] stopRow = HConstants.EMPTY_END_ROW;
    private boolean includeStopRow = false;
    private int maxVersions = 1;
    private int batch = -1;
    private boolean allowPartialResults = false;
    private int storeLimit = -1;
    private int storeOffset = 0;
    @Deprecated
    public static final String SCAN_ATTRIBUTES_METRICS_ENABLE = "scan.attributes.metrics.enable";
    @Deprecated
    public static final String SCAN_ATTRIBUTES_METRICS_DATA = "scan.attributes.metrics.data";
    public static final String SCAN_ATTRIBUTES_TABLE_NAME = "scan.attributes.table.name";
    private int caching = -1;
    private long maxResultSize = -1L;
    private boolean cacheBlocks = true;
    private boolean reversed = false;
    private TimeRange tr = TimeRange.allTime();
    private Map<byte[], NavigableSet<byte[]>> familyMap = new TreeMap<byte[], NavigableSet<byte[]>>(Bytes.BYTES_COMPARATOR);
    private Boolean asyncPrefetch = null;
    public static final String HBASE_CLIENT_SCANNER_ASYNC_PREFETCH = "hbase.client.scanner.async.prefetch";
    public static final boolean DEFAULT_HBASE_CLIENT_SCANNER_ASYNC_PREFETCH = false;
    private boolean small = false;
    private long mvccReadPoint = -1L;
    private int limit = -1;
    private ReadType readType = ReadType.DEFAULT;
    private boolean needCursorResult = false;

    public Scan() {
    }

    @Deprecated
    public Scan(byte[] startRow, Filter filter) {
        this(startRow);
        this.filter = filter;
    }

    @Deprecated
    public Scan(byte[] startRow) {
        this.setStartRow(startRow);
    }

    @Deprecated
    public Scan(byte[] startRow, byte[] stopRow) {
        this.setStartRow(startRow);
        this.setStopRow(stopRow);
    }

    public Scan(Scan scan) throws IOException {
        this.startRow = scan.getStartRow();
        this.includeStartRow = scan.includeStartRow();
        this.stopRow = scan.getStopRow();
        this.includeStopRow = scan.includeStopRow();
        this.maxVersions = scan.getMaxVersions();
        this.batch = scan.getBatch();
        this.storeLimit = scan.getMaxResultsPerColumnFamily();
        this.storeOffset = scan.getRowOffsetPerColumnFamily();
        this.caching = scan.getCaching();
        this.maxResultSize = scan.getMaxResultSize();
        this.cacheBlocks = scan.getCacheBlocks();
        this.filter = scan.getFilter();
        this.loadColumnFamiliesOnDemand = scan.getLoadColumnFamiliesOnDemandValue();
        this.consistency = scan.getConsistency();
        this.setIsolationLevel(scan.getIsolationLevel());
        this.reversed = scan.isReversed();
        this.asyncPrefetch = scan.isAsyncPrefetch();
        this.small = scan.isSmall();
        this.allowPartialResults = scan.getAllowPartialResults();
        this.tr = scan.getTimeRange();
        Map<byte[], NavigableSet<byte[]>> fams = scan.getFamilyMap();
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : fams.entrySet()) {
            byte[] fam = entry.getKey();
            NavigableSet<byte[]> cols = entry.getValue();
            if (cols != null && cols.size() > 0) {
                for (byte[] col : cols) {
                    this.addColumn(fam, col);
                }
                continue;
            }
            this.addFamily(fam);
        }
        for (Map.Entry<Object, Object> entry : scan.getAttributesMap().entrySet()) {
            this.setAttribute((String)entry.getKey(), (byte[])entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : scan.getColumnFamilyTimeRange().entrySet()) {
            TimeRange tr = (TimeRange)entry.getValue();
            this.setColumnFamilyTimeRange((byte[])entry.getKey(), tr.getMin(), tr.getMax());
        }
        this.mvccReadPoint = scan.getMvccReadPoint();
        this.limit = scan.getLimit();
        this.needCursorResult = scan.isNeedCursorResult();
        this.setPriority(scan.getPriority());
        this.readType = scan.getReadType();
        super.setReplicaId(scan.getReplicaId());
    }

    public Scan(Get get) {
        this.startRow = get.getRow();
        this.includeStartRow = true;
        this.stopRow = get.getRow();
        this.includeStopRow = true;
        this.filter = get.getFilter();
        this.cacheBlocks = get.getCacheBlocks();
        this.maxVersions = get.getMaxVersions();
        this.storeLimit = get.getMaxResultsPerColumnFamily();
        this.storeOffset = get.getRowOffsetPerColumnFamily();
        this.tr = get.getTimeRange();
        this.familyMap = get.getFamilyMap();
        this.asyncPrefetch = false;
        this.consistency = get.getConsistency();
        this.setIsolationLevel(get.getIsolationLevel());
        this.loadColumnFamiliesOnDemand = get.getLoadColumnFamiliesOnDemandValue();
        for (Map.Entry<String, byte[]> entry : get.getAttributesMap().entrySet()) {
            this.setAttribute(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<String, byte[]> entry : get.getColumnFamilyTimeRange().entrySet()) {
            TimeRange tr = (TimeRange)entry.getValue();
            this.setColumnFamilyTimeRange((byte[])entry.getKey(), tr.getMin(), tr.getMax());
        }
        this.mvccReadPoint = -1L;
        this.setPriority(get.getPriority());
        super.setReplicaId(get.getReplicaId());
    }

    public boolean isGetScan() {
        return this.includeStartRow && this.includeStopRow && ClientUtil.areScanStartRowAndStopRowEqual(this.startRow, this.stopRow);
    }

    public Scan addFamily(byte[] family) {
        this.familyMap.remove(family);
        this.familyMap.put(family, null);
        return this;
    }

    public Scan addColumn(byte[] family, byte[] qualifier) {
        NavigableSet<byte[]> set = this.familyMap.get(family);
        if (set == null) {
            set = new TreeSet<byte[]>(Bytes.BYTES_COMPARATOR);
            this.familyMap.put(family, set);
        }
        if (qualifier == null) {
            qualifier = HConstants.EMPTY_BYTE_ARRAY;
        }
        set.add(qualifier);
        return this;
    }

    public Scan setTimeRange(long minStamp, long maxStamp) throws IOException {
        this.tr = new TimeRange(minStamp, maxStamp);
        return this;
    }

    @Deprecated
    public Scan setTimeStamp(long timestamp) throws IOException {
        return this.setTimestamp(timestamp);
    }

    public Scan setTimestamp(long timestamp) {
        try {
            this.tr = new TimeRange(timestamp, timestamp + 1L);
        }
        catch (Exception e) {
            LOG.error("TimeRange failed, likely caused by integer overflow. ", (Throwable)e);
            throw e;
        }
        return this;
    }

    @Override
    public Scan setColumnFamilyTimeRange(byte[] cf, long minStamp, long maxStamp) {
        return (Scan)super.setColumnFamilyTimeRange(cf, minStamp, maxStamp);
    }

    @Deprecated
    public Scan setStartRow(byte[] startRow) {
        this.withStartRow(startRow);
        if (ClientUtil.areScanStartRowAndStopRowEqual(this.startRow, this.stopRow)) {
            this.includeStopRow = true;
        }
        return this;
    }

    public Scan withStartRow(byte[] startRow) {
        return this.withStartRow(startRow, true);
    }

    public Scan withStartRow(byte[] startRow, boolean inclusive) {
        if (Bytes.len((byte[])startRow) > Short.MAX_VALUE) {
            throw new IllegalArgumentException("startRow's length must be less than or equal to 32767 to meet the criteria for a row key.");
        }
        this.startRow = startRow;
        this.includeStartRow = inclusive;
        return this;
    }

    @Deprecated
    public Scan setStopRow(byte[] stopRow) {
        this.withStopRow(stopRow);
        if (ClientUtil.areScanStartRowAndStopRowEqual(this.startRow, this.stopRow)) {
            this.includeStopRow = true;
        }
        return this;
    }

    public Scan withStopRow(byte[] stopRow) {
        return this.withStopRow(stopRow, false);
    }

    public Scan withStopRow(byte[] stopRow, boolean inclusive) {
        if (Bytes.len((byte[])stopRow) > Short.MAX_VALUE) {
            throw new IllegalArgumentException("stopRow's length must be less than or equal to 32767 to meet the criteria for a row key.");
        }
        this.stopRow = stopRow;
        this.includeStopRow = inclusive;
        return this;
    }

    public Scan setRowPrefixFilter(byte[] rowPrefix) {
        if (rowPrefix == null) {
            this.setStartRow(HConstants.EMPTY_START_ROW);
            this.setStopRow(HConstants.EMPTY_END_ROW);
        } else {
            this.setStartRow(rowPrefix);
            this.setStopRow(this.calculateTheClosestNextRowKeyForPrefix(rowPrefix));
        }
        return this;
    }

    private byte[] calculateTheClosestNextRowKeyForPrefix(byte[] rowKeyPrefix) {
        int offset;
        for (offset = rowKeyPrefix.length; offset > 0 && rowKeyPrefix[offset - 1] == -1; --offset) {
        }
        if (offset == 0) {
            return HConstants.EMPTY_END_ROW;
        }
        byte[] newStopRow = Arrays.copyOfRange(rowKeyPrefix, 0, offset);
        int n = newStopRow.length - 1;
        newStopRow[n] = (byte)(newStopRow[n] + 1);
        return newStopRow;
    }

    @Deprecated
    public Scan setMaxVersions() {
        return this.readAllVersions();
    }

    @Deprecated
    public Scan setMaxVersions(int maxVersions) {
        return this.readVersions(maxVersions);
    }

    public Scan readAllVersions() {
        this.maxVersions = Integer.MAX_VALUE;
        return this;
    }

    public Scan readVersions(int versions) {
        this.maxVersions = versions;
        return this;
    }

    public Scan setBatch(int batch) {
        if (this.hasFilter() && this.filter.hasFilterRow()) {
            throw new IncompatibleFilterException("Cannot set batch on a scan using a filter that returns true for filter.hasFilterRow");
        }
        this.batch = batch;
        return this;
    }

    public Scan setMaxResultsPerColumnFamily(int limit) {
        this.storeLimit = limit;
        return this;
    }

    public Scan setRowOffsetPerColumnFamily(int offset) {
        this.storeOffset = offset;
        return this;
    }

    public Scan setCaching(int caching) {
        this.caching = caching;
        return this;
    }

    public long getMaxResultSize() {
        return this.maxResultSize;
    }

    public Scan setMaxResultSize(long maxResultSize) {
        this.maxResultSize = maxResultSize;
        return this;
    }

    @Override
    public Scan setFilter(Filter filter) {
        super.setFilter(filter);
        return this;
    }

    public Scan setFamilyMap(Map<byte[], NavigableSet<byte[]>> familyMap) {
        this.familyMap = familyMap;
        return this;
    }

    public Map<byte[], NavigableSet<byte[]>> getFamilyMap() {
        return this.familyMap;
    }

    public int numFamilies() {
        if (this.hasFamilies()) {
            return this.familyMap.size();
        }
        return 0;
    }

    public boolean hasFamilies() {
        return !this.familyMap.isEmpty();
    }

    public byte[][] getFamilies() {
        if (this.hasFamilies()) {
            return (byte[][])this.familyMap.keySet().toArray((T[])new byte[0][0]);
        }
        return null;
    }

    public byte[] getStartRow() {
        return this.startRow;
    }

    public boolean includeStartRow() {
        return this.includeStartRow;
    }

    public byte[] getStopRow() {
        return this.stopRow;
    }

    public boolean includeStopRow() {
        return this.includeStopRow;
    }

    public int getMaxVersions() {
        return this.maxVersions;
    }

    public int getBatch() {
        return this.batch;
    }

    public int getMaxResultsPerColumnFamily() {
        return this.storeLimit;
    }

    public int getRowOffsetPerColumnFamily() {
        return this.storeOffset;
    }

    public int getCaching() {
        return this.caching;
    }

    public TimeRange getTimeRange() {
        return this.tr;
    }

    @Override
    public Filter getFilter() {
        return this.filter;
    }

    public boolean hasFilter() {
        return this.filter != null;
    }

    public Scan setCacheBlocks(boolean cacheBlocks) {
        this.cacheBlocks = cacheBlocks;
        return this;
    }

    public boolean getCacheBlocks() {
        return this.cacheBlocks;
    }

    public Scan setReversed(boolean reversed) {
        this.reversed = reversed;
        return this;
    }

    public boolean isReversed() {
        return this.reversed;
    }

    public Scan setAllowPartialResults(boolean allowPartialResults) {
        this.allowPartialResults = allowPartialResults;
        return this;
    }

    public boolean getAllowPartialResults() {
        return this.allowPartialResults;
    }

    @Override
    public Scan setLoadColumnFamiliesOnDemand(boolean value) {
        return (Scan)super.setLoadColumnFamiliesOnDemand(value);
    }

    @Override
    public Map<String, Object> getFingerprint() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        ArrayList<String> families = new ArrayList<String>();
        if (this.familyMap.isEmpty()) {
            map.put("families", "ALL");
            return map;
        }
        map.put("families", families);
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            families.add(Bytes.toStringBinary((byte[])entry.getKey()));
        }
        return map;
    }

    @Override
    public Map<String, Object> toMap(int maxCols) {
        Map<String, Object> map = this.getFingerprint();
        HashMap familyColumns = new HashMap();
        map.put("families", familyColumns);
        map.put("startRow", Bytes.toStringBinary((byte[])this.startRow));
        map.put("stopRow", Bytes.toStringBinary((byte[])this.stopRow));
        map.put("maxVersions", this.maxVersions);
        map.put("batch", this.batch);
        map.put("caching", this.caching);
        map.put("maxResultSize", this.maxResultSize);
        map.put("cacheBlocks", this.cacheBlocks);
        map.put("loadColumnFamiliesOnDemand", this.loadColumnFamiliesOnDemand);
        ArrayList<Long> timeRange = new ArrayList<Long>(2);
        timeRange.add(this.tr.getMin());
        timeRange.add(this.tr.getMax());
        map.put("timeRange", timeRange);
        int colCount = 0;
        for (Map.Entry<byte[], NavigableSet<byte[]>> entry : this.familyMap.entrySet()) {
            ArrayList<String> columns = new ArrayList<String>();
            familyColumns.put(Bytes.toStringBinary((byte[])entry.getKey()), columns);
            if (entry.getValue() == null) {
                ++colCount;
                --maxCols;
                columns.add("ALL");
                continue;
            }
            colCount += entry.getValue().size();
            if (maxCols <= 0) continue;
            for (byte[] column : entry.getValue()) {
                if (--maxCols <= 0) continue;
                columns.add(Bytes.toStringBinary((byte[])column));
            }
        }
        map.put("totalColumns", colCount);
        if (this.filter != null) {
            map.put("filter", this.filter.toString());
        }
        if (this.getId() != null) {
            map.put("id", this.getId());
        }
        return map;
    }

    public Scan setRaw(boolean raw) {
        this.setAttribute(RAW_ATTR, Bytes.toBytes((boolean)raw));
        return this;
    }

    public boolean isRaw() {
        byte[] attr = this.getAttribute(RAW_ATTR);
        return attr == null ? false : Bytes.toBoolean((byte[])attr);
    }

    @Deprecated
    public Scan setSmall(boolean small) {
        this.small = small;
        this.readType = ReadType.PREAD;
        return this;
    }

    @Deprecated
    public boolean isSmall() {
        return this.small;
    }

    @Override
    public Scan setAttribute(String name, byte[] value) {
        return (Scan)super.setAttribute(name, value);
    }

    @Override
    public Scan setId(String id) {
        return (Scan)super.setId(id);
    }

    @Override
    public Scan setAuthorizations(Authorizations authorizations) {
        return (Scan)super.setAuthorizations(authorizations);
    }

    @Override
    public Scan setACL(Map<String, Permission> perms) {
        return (Scan)super.setACL(perms);
    }

    @Override
    public Scan setACL(String user, Permission perms) {
        return (Scan)super.setACL(user, perms);
    }

    @Override
    public Scan setConsistency(Consistency consistency) {
        return (Scan)super.setConsistency(consistency);
    }

    @Override
    public Scan setReplicaId(int Id) {
        return (Scan)super.setReplicaId(Id);
    }

    @Override
    public Scan setIsolationLevel(IsolationLevel level) {
        return (Scan)super.setIsolationLevel(level);
    }

    @Override
    public Scan setPriority(int priority) {
        return (Scan)super.setPriority(priority);
    }

    public Scan setScanMetricsEnabled(boolean enabled) {
        this.setAttribute(SCAN_ATTRIBUTES_METRICS_ENABLE, Bytes.toBytes((boolean)enabled));
        return this;
    }

    public boolean isScanMetricsEnabled() {
        byte[] attr = this.getAttribute(SCAN_ATTRIBUTES_METRICS_ENABLE);
        return attr == null ? false : Bytes.toBoolean((byte[])attr);
    }

    @Deprecated
    public ScanMetrics getScanMetrics() {
        byte[] bytes = this.getAttribute(SCAN_ATTRIBUTES_METRICS_DATA);
        if (bytes == null) {
            return null;
        }
        return ProtobufUtil.toScanMetrics(bytes);
    }

    public Boolean isAsyncPrefetch() {
        return this.asyncPrefetch;
    }

    public Scan setAsyncPrefetch(boolean asyncPrefetch) {
        this.asyncPrefetch = asyncPrefetch;
        return this;
    }

    public int getLimit() {
        return this.limit;
    }

    public Scan setLimit(int limit) {
        this.limit = limit;
        return this;
    }

    public Scan setOneRowLimit() {
        return this.setLimit(1).setReadType(ReadType.PREAD);
    }

    public ReadType getReadType() {
        return this.readType;
    }

    public Scan setReadType(ReadType readType) {
        this.readType = readType;
        return this;
    }

    long getMvccReadPoint() {
        return this.mvccReadPoint;
    }

    Scan setMvccReadPoint(long mvccReadPoint) {
        this.mvccReadPoint = mvccReadPoint;
        return this;
    }

    Scan resetMvccReadPoint() {
        return this.setMvccReadPoint(-1L);
    }

    public Scan setNeedCursorResult(boolean needCursorResult) {
        this.needCursorResult = needCursorResult;
        return this;
    }

    public boolean isNeedCursorResult() {
        return this.needCursorResult;
    }

    public static Scan createScanFromCursor(Cursor cursor) {
        return new Scan().withStartRow(cursor.getRow());
    }

    @InterfaceAudience.Public
    public static enum ReadType {
        DEFAULT,
        STREAM,
        PREAD;

    }
}

