/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver.wal;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.wal.WAL;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.Private
class FSWALEntry
extends WAL.Entry {
    private final transient long sequence;
    private final transient AtomicLong regionSequenceIdReference;
    private final transient boolean inMemstore;
    private final transient HTableDescriptor htd;
    private final transient HRegionInfo hri;
    private final transient List<Cell> memstoreCells;

    FSWALEntry(long sequence, WALKey key, WALEdit edit, AtomicLong referenceToRegionSequenceId, boolean inMemstore, HTableDescriptor htd, HRegionInfo hri, List<Cell> memstoreCells) {
        super(key, edit);
        this.regionSequenceIdReference = referenceToRegionSequenceId;
        this.inMemstore = inMemstore;
        this.htd = htd;
        this.hri = hri;
        this.sequence = sequence;
        this.memstoreCells = memstoreCells;
    }

    @Override
    public String toString() {
        return "sequence=" + this.sequence + ", " + super.toString();
    }

    boolean isInMemstore() {
        return this.inMemstore;
    }

    HTableDescriptor getHTableDescriptor() {
        return this.htd;
    }

    HRegionInfo getHRegionInfo() {
        return this.hri;
    }

    long getSequence() {
        return this.sequence;
    }

    long stampRegionSequenceId() throws IOException {
        long regionSequenceId = this.regionSequenceIdReference.incrementAndGet();
        if (!this.getEdit().isReplay() && this.memstoreCells != null && !this.memstoreCells.isEmpty()) {
            for (Cell cell : this.memstoreCells) {
                CellUtil.setSequenceId((Cell)cell, (long)regionSequenceId);
            }
        }
        WALKey key = this.getKey();
        key.setLogSeqNum(regionSequenceId);
        return regionSequenceId;
    }
}

