/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellUtil;
import org.apache.hadoop.hbase.KeyValue;
import org.apache.hadoop.hbase.NoTagsKeyValue;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.io.util.StreamUtils;
import org.apache.hadoop.hbase.shaded.com.google.common.base.Function;
import org.apache.hadoop.hbase.shaded.com.google.common.collect.Lists;
import org.apache.hadoop.hbase.util.ByteBufferUtils;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.IterableUtils;
import org.apache.hadoop.hbase.util.SimpleMutableByteRange;
import org.apache.hadoop.io.IOUtils;
import org.apache.hadoop.io.WritableUtils;

@InterfaceAudience.Private
public class KeyValueUtil {
    public static int length(Cell cell) {
        return KeyValueUtil.length(cell.getRowLength(), cell.getFamilyLength(), cell.getQualifierLength(), cell.getValueLength(), cell.getTagsLength(), true);
    }

    private static int length(short rlen, byte flen, int qlen, int vlen, int tlen, boolean withTags) {
        if (withTags) {
            return (int)KeyValue.getKeyValueDataStructureSize(rlen, flen, qlen, vlen, tlen);
        }
        return (int)KeyValue.getKeyValueDataStructureSize(rlen, flen, qlen, vlen);
    }

    public static int keyLength(Cell cell) {
        return KeyValueUtil.keyLength(cell.getRowLength(), cell.getFamilyLength(), cell.getQualifierLength());
    }

    private static int keyLength(short rlen, byte flen, int qlen) {
        return (int)KeyValue.getKeyDataStructureSize(rlen, flen, qlen);
    }

    public static int lengthWithMvccVersion(KeyValue kv, boolean includeMvccVersion) {
        int length = kv.getLength();
        if (includeMvccVersion) {
            length += WritableUtils.getVIntSize(kv.getMvccVersion());
        }
        return length;
    }

    public static int totalLengthWithMvccVersion(Iterable<? extends KeyValue> kvs, boolean includeMvccVersion) {
        int length = 0;
        for (KeyValue keyValue : IterableUtils.nullSafe(kvs)) {
            length += KeyValueUtil.lengthWithMvccVersion(keyValue, includeMvccVersion);
        }
        return length;
    }

    public static KeyValue copyToNewKeyValue(Cell cell) {
        byte[] bytes = KeyValueUtil.copyToNewByteArray(cell);
        KeyValue kvCell = new KeyValue(bytes, 0, bytes.length);
        kvCell.setSequenceId(cell.getMvccVersion());
        return kvCell;
    }

    public static ByteBuffer copyKeyToNewByteBuffer(Cell cell) {
        byte[] bytes = new byte[KeyValueUtil.keyLength(cell)];
        KeyValueUtil.appendKeyTo(cell, bytes, 0);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return buffer;
    }

    public static byte[] copyToNewByteArray(Cell cell) {
        int v1Length = KeyValueUtil.length(cell);
        byte[] backingBytes = new byte[v1Length];
        KeyValueUtil.appendToByteArray(cell, backingBytes, 0);
        return backingBytes;
    }

    public static int appendKeyTo(Cell cell, byte[] output, int offset) {
        int nextOffset = offset;
        nextOffset = Bytes.putShort(output, nextOffset, cell.getRowLength());
        nextOffset = CellUtil.copyRowTo(cell, output, nextOffset);
        nextOffset = Bytes.putByte(output, nextOffset, cell.getFamilyLength());
        nextOffset = CellUtil.copyFamilyTo(cell, output, nextOffset);
        nextOffset = CellUtil.copyQualifierTo(cell, output, nextOffset);
        nextOffset = Bytes.putLong(output, nextOffset, cell.getTimestamp());
        nextOffset = Bytes.putByte(output, nextOffset, cell.getTypeByte());
        return nextOffset;
    }

    public static int appendToByteArray(Cell cell, byte[] output, int offset) {
        int pos = offset;
        pos = Bytes.putInt(output, pos, KeyValueUtil.keyLength(cell));
        pos = Bytes.putInt(output, pos, cell.getValueLength());
        pos = KeyValueUtil.appendKeyTo(cell, output, pos);
        pos = CellUtil.copyValueTo(cell, output, pos);
        if (cell.getTagsLength() > 0) {
            pos = Bytes.putAsShort(output, pos, cell.getTagsLength());
            pos = CellUtil.copyTagTo(cell, output, pos);
        }
        return pos;
    }

    public static ByteBuffer copyToNewByteBuffer(Cell cell) {
        byte[] bytes = new byte[KeyValueUtil.length(cell)];
        KeyValueUtil.appendToByteArray(cell, bytes, 0);
        ByteBuffer buffer = ByteBuffer.wrap(bytes);
        return buffer;
    }

    public static void appendToByteBuffer(ByteBuffer bb, KeyValue kv, boolean includeMvccVersion) {
        bb.limit(bb.position() + kv.getLength());
        bb.put(kv.getBuffer(), kv.getOffset(), kv.getLength());
        if (includeMvccVersion) {
            int numMvccVersionBytes = WritableUtils.getVIntSize(kv.getMvccVersion());
            ByteBufferUtils.extendLimit(bb, numMvccVersionBytes);
            ByteBufferUtils.writeVLong(bb, kv.getMvccVersion());
        }
    }

    public static KeyValue nextShallowCopy(ByteBuffer bb, boolean includesMvccVersion, boolean includesTags) {
        if (bb.isDirect()) {
            throw new IllegalArgumentException("only supports heap buffers");
        }
        if (bb.remaining() < 1) {
            return null;
        }
        KeyValue keyValue = null;
        int underlyingArrayOffset = bb.arrayOffset() + bb.position();
        int keyLength = bb.getInt();
        int valueLength = bb.getInt();
        ByteBufferUtils.skip(bb, keyLength + valueLength);
        int tagsLength = 0;
        if (includesTags) {
            tagsLength = (bb.get() & 0xFF) << 8 ^ bb.get() & 0xFF;
            ByteBufferUtils.skip(bb, tagsLength);
        }
        int kvLength = (int)KeyValue.getKeyValueDataStructureSize(keyLength, valueLength, tagsLength);
        keyValue = new KeyValue(bb.array(), underlyingArrayOffset, kvLength);
        if (includesMvccVersion) {
            long mvccVersion = ByteBufferUtils.readVLong(bb);
            keyValue.setSequenceId(mvccVersion);
        }
        return keyValue;
    }

    public static KeyValue createFirstKeyInNextRow(Cell in) {
        byte[] nextRow = new byte[in.getRowLength() + 1];
        System.arraycopy(in.getRowArray(), in.getRowOffset(), nextRow, 0, in.getRowLength());
        nextRow[nextRow.length - 1] = 0;
        return KeyValueUtil.createFirstOnRow(nextRow);
    }

    public static KeyValue createFirstKeyInIncrementedRow(Cell in) {
        byte[] thisRow = new SimpleMutableByteRange(in.getRowArray(), in.getRowOffset(), in.getRowLength()).deepCopyToNewArray();
        byte[] nextRow = Bytes.unsignedCopyAndIncrement(thisRow);
        return KeyValueUtil.createFirstOnRow(nextRow);
    }

    public static KeyValue previousKey(KeyValue in) {
        return KeyValueUtil.createFirstOnRow(CellUtil.cloneRow(in), CellUtil.cloneFamily(in), CellUtil.cloneQualifier(in), in.getTimestamp() - 1L);
    }

    public static KeyValue createLastOnRow(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MIN_VALUE, KeyValue.Type.Minimum, null, 0, 0);
    }

    public static KeyValue createLastOnRow(Cell kv) {
        return KeyValueUtil.createLastOnRow(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), null, 0, 0, null, 0, 0);
    }

    public static KeyValue createLastOnRowCol(Cell kv) {
        return new KeyValue(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), Long.MIN_VALUE, KeyValue.Type.Minimum, null, 0, 0);
    }

    public static KeyValue createFirstOnRowColTS(Cell kv, long ts) {
        return new KeyValue(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), ts, KeyValue.Type.Maximum, kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
    }

    public static KeyValue createFirstOnRow(byte[] row, int roffset, short rlength) {
        return new KeyValue(row, roffset, rlength, null, 0, 0, null, 0, 0, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0);
    }

    public static KeyValue createLastOnRow(byte[] row) {
        return new KeyValue(row, null, null, Long.MAX_VALUE, KeyValue.Type.Minimum);
    }

    public static KeyValue createFirstOnRow(byte[] row) {
        return KeyValueUtil.createFirstOnRow(row, Long.MAX_VALUE);
    }

    public static KeyValue createFirstOnRow(byte[] row, long ts) {
        return new KeyValue(row, null, null, ts, KeyValue.Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, byte[] family, byte[] qualifier) {
        return new KeyValue(row, family, qualifier, Long.MAX_VALUE, KeyValue.Type.Maximum);
    }

    public static KeyValue createFirstDeleteFamilyOnRow(byte[] row, byte[] family) {
        return new KeyValue(row, family, null, Long.MAX_VALUE, KeyValue.Type.DeleteFamily);
    }

    public static KeyValue createFirstOnRow(byte[] row, byte[] f, byte[] q, long ts) {
        return new KeyValue(row, f, q, ts, KeyValue.Type.Maximum);
    }

    public static KeyValue createFirstOnRow(byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) {
        return new KeyValue(row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0);
    }

    public static KeyValue createFirstOnRow(byte[] buffer, byte[] row, byte[] family, byte[] qualifier) throws IllegalArgumentException {
        return KeyValueUtil.createFirstOnRow(buffer, 0, row, 0, row.length, family, 0, family.length, qualifier, 0, qualifier.length);
    }

    public static KeyValue createFirstOnRow(byte[] buffer, int boffset, byte[] row, int roffset, int rlength, byte[] family, int foffset, int flength, byte[] qualifier, int qoffset, int qlength) throws IllegalArgumentException {
        long lLength = KeyValue.getKeyValueDataStructureSize(rlength, flength, qlength, 0);
        if (lLength > Integer.MAX_VALUE) {
            throw new IllegalArgumentException("KeyValue length " + lLength + " > " + Integer.MAX_VALUE);
        }
        int iLength = (int)lLength;
        if (buffer.length - boffset < iLength) {
            throw new IllegalArgumentException("Buffer size " + (buffer.length - boffset) + " < " + iLength);
        }
        int len = KeyValue.writeByteArray(buffer, boffset, row, roffset, rlength, family, foffset, flength, qualifier, qoffset, qlength, Long.MAX_VALUE, KeyValue.Type.Maximum, null, 0, 0, null);
        return new KeyValue(buffer, boffset, len);
    }

    public static KeyValue createFirstOnRowColTS(KeyValue kv, long ts) {
        return new KeyValue(kv.getRowArray(), kv.getRowOffset(), kv.getRowLength(), kv.getFamilyArray(), kv.getFamilyOffset(), kv.getFamilyLength(), kv.getQualifierArray(), kv.getQualifierOffset(), kv.getQualifierLength(), ts, KeyValue.Type.Maximum, kv.getValueArray(), kv.getValueOffset(), kv.getValueLength());
    }

    @Deprecated
    public static KeyValue ensureKeyValue(Cell cell) {
        if (cell == null) {
            return null;
        }
        return cell instanceof KeyValue ? (KeyValue)cell : KeyValueUtil.copyToNewKeyValue(cell);
    }

    @Deprecated
    public static KeyValue ensureKeyValueTypeForMR(Cell cell) {
        if (cell == null) {
            return null;
        }
        if (cell instanceof KeyValue) {
            if (cell.getClass().getName().equals(KeyValue.class.getName())) {
                return (KeyValue)cell;
            }
            KeyValue kv = (KeyValue)cell;
            KeyValue newKv = new KeyValue(kv.bytes, kv.offset, kv.length);
            newKv.setSequenceId(kv.getSequenceId());
            return newKv;
        }
        return KeyValueUtil.copyToNewKeyValue(cell);
    }

    @Deprecated
    public static List<KeyValue> ensureKeyValues(List<Cell> cells) {
        List<KeyValue> lazyList = Lists.transform(cells, new Function<Cell, KeyValue>(){

            @Override
            public KeyValue apply(Cell arg0) {
                return KeyValueUtil.ensureKeyValue(arg0);
            }
        });
        return new ArrayList<KeyValue>(lazyList);
    }

    public static KeyValue iscreate(InputStream in, boolean withTags) throws IOException {
        int n;
        byte[] intBytes = new byte[4];
        for (int bytesRead = 0; bytesRead < intBytes.length; bytesRead += n) {
            n = in.read(intBytes, bytesRead, intBytes.length - bytesRead);
            if (n >= 0) continue;
            if (bytesRead == 0) {
                throw new EOFException();
            }
            throw new IOException("Failed read of int, read " + bytesRead + " bytes");
        }
        byte[] bytes = new byte[Bytes.toInt(intBytes)];
        IOUtils.readFully(in, bytes, 0, bytes.length);
        if (withTags) {
            return new KeyValue(bytes, 0, bytes.length);
        }
        return new NoTagsKeyValue(bytes, 0, bytes.length);
    }

    public static void oswrite(Cell cell, OutputStream out, boolean withTags) throws IOException {
        if (cell instanceof KeyValue) {
            KeyValue.oswrite((KeyValue)cell, out, withTags);
        } else {
            short rlen = cell.getRowLength();
            byte flen = cell.getFamilyLength();
            int qlen = cell.getQualifierLength();
            int vlen = cell.getValueLength();
            int tlen = cell.getTagsLength();
            StreamUtils.writeInt(out, KeyValueUtil.length(rlen, flen, qlen, vlen, tlen, withTags));
            StreamUtils.writeInt(out, KeyValueUtil.keyLength(rlen, flen, qlen));
            StreamUtils.writeInt(out, vlen);
            StreamUtils.writeShort(out, rlen);
            out.write(cell.getRowArray(), cell.getRowOffset(), rlen);
            out.write(flen);
            out.write(cell.getFamilyArray(), cell.getFamilyOffset(), flen);
            out.write(cell.getQualifierArray(), cell.getQualifierOffset(), qlen);
            StreamUtils.writeLong(out, cell.getTimestamp());
            out.write(cell.getTypeByte());
            out.write(cell.getValueArray(), cell.getValueOffset(), vlen);
            if (withTags && tlen > 0) {
                out.write((byte)(0xFF & tlen >> 8));
                out.write((byte)(0xFF & tlen));
                out.write(cell.getTagsArray(), cell.getTagsOffset(), tlen);
            }
        }
    }
}

