/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.RegionLocations;
import org.apache.hadoop.hbase.ServerName;
import org.apache.hadoop.hbase.TableName;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.ClusterConnection;
import org.apache.hadoop.hbase.client.MetaScanner;
import org.apache.hadoop.hbase.client.RegionLocator;
import org.apache.hadoop.hbase.shaded.com.google.common.annotations.VisibleForTesting;
import org.apache.hadoop.hbase.util.Pair;

@InterfaceAudience.Private
@InterfaceStability.Stable
public class HRegionLocator
implements RegionLocator {
    private final TableName tableName;
    private final ClusterConnection connection;

    public HRegionLocator(TableName tableName, ClusterConnection connection) {
        this.connection = connection;
        this.tableName = tableName;
    }

    @Override
    public void close() throws IOException {
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, false);
    }

    @Override
    public HRegionLocation getRegionLocation(byte[] row, boolean reload) throws IOException {
        return this.connection.getRegionLocation(this.tableName, row, reload);
    }

    @Override
    public List<HRegionLocation> getAllRegionLocations() throws IOException {
        NavigableMap<HRegionInfo, ServerName> locations = MetaScanner.allTableRegions(this.connection, this.getName());
        ArrayList<HRegionLocation> regions = new ArrayList<HRegionLocation>(locations.size());
        for (Map.Entry entry : locations.entrySet()) {
            regions.add(new HRegionLocation((HRegionInfo)entry.getKey(), (ServerName)entry.getValue()));
        }
        return regions;
    }

    @Override
    public byte[][] getStartKeys() throws IOException {
        return this.getStartEndKeys().getFirst();
    }

    @Override
    public byte[][] getEndKeys() throws IOException {
        return this.getStartEndKeys().getSecond();
    }

    @Override
    public Pair<byte[][], byte[][]> getStartEndKeys() throws IOException {
        return this.getStartEndKeys(this.listRegionLocations());
    }

    @VisibleForTesting
    Pair<byte[][], byte[][]> getStartEndKeys(List<RegionLocations> regions) {
        byte[][] startKeyList = new byte[regions.size()][];
        byte[][] endKeyList = new byte[regions.size()][];
        for (int i = 0; i < regions.size(); ++i) {
            HRegionInfo region = regions.get(i).getRegionLocation().getRegionInfo();
            startKeyList[i] = region.getStartKey();
            endKeyList[i] = region.getEndKey();
        }
        return new Pair<byte[][], byte[][]>(startKeyList, endKeyList);
    }

    @Override
    public TableName getName() {
        return this.tableName;
    }

    @VisibleForTesting
    List<RegionLocations> listRegionLocations() throws IOException {
        return MetaScanner.listTableRegionLocations(this.getConfiguration(), this.connection, this.getName());
    }

    public Configuration getConfiguration() {
        return this.connection.getConfiguration();
    }
}

