/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.replication;

import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.hbase.Abortable;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.protobuf.generated.ZooKeeperProtos;
import org.apache.hadoop.hbase.shaded.org.apache.zookeeper.KeeperException;
import org.apache.hadoop.hbase.zookeeper.ZKConfig;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;

@InterfaceAudience.Private
public abstract class ReplicationStateZKBase {
    protected final String peerStateNodeName;
    protected final String replicationZNode;
    protected final String peersZNode;
    protected final String queuesZNode;
    protected final String ourClusterKey;
    protected final ZooKeeperWatcher zookeeper;
    protected final Configuration conf;
    protected final Abortable abortable;
    public static final byte[] ENABLED_ZNODE_BYTES = ReplicationStateZKBase.toByteArray(ZooKeeperProtos.ReplicationState.State.ENABLED);
    public static final byte[] DISABLED_ZNODE_BYTES = ReplicationStateZKBase.toByteArray(ZooKeeperProtos.ReplicationState.State.DISABLED);

    public ReplicationStateZKBase(ZooKeeperWatcher zookeeper, Configuration conf, Abortable abortable) {
        this.zookeeper = zookeeper;
        this.conf = conf;
        this.abortable = abortable;
        String replicationZNodeName = conf.get("zookeeper.znode.replication", "replication");
        String peersZNodeName = conf.get("zookeeper.znode.replication.peers", "peers");
        String queuesZNodeName = conf.get("zookeeper.znode.replication.rs", "rs");
        this.peerStateNodeName = conf.get("zookeeper.znode.replication.peers.state", "peer-state");
        this.ourClusterKey = ZKConfig.getZooKeeperClusterKey(this.conf);
        this.replicationZNode = ZKUtil.joinZNode(this.zookeeper.baseZNode, replicationZNodeName);
        this.peersZNode = ZKUtil.joinZNode(this.replicationZNode, peersZNodeName);
        this.queuesZNode = ZKUtil.joinZNode(this.replicationZNode, queuesZNodeName);
    }

    public List<String> getListOfReplicators() {
        List<String> result = null;
        try {
            result = ZKUtil.listChildrenNoWatch(this.zookeeper, this.queuesZNode);
        }
        catch (KeeperException e) {
            this.abortable.abort("Failed to get list of replicators", e);
        }
        return result;
    }

    protected static byte[] toByteArray(ZooKeeperProtos.ReplicationState.State state) {
        byte[] bytes = ZooKeeperProtos.ReplicationState.newBuilder().setState(state).build().toByteArray();
        return ProtobufUtil.prependPBMagic(bytes);
    }

    protected boolean peerExists(String id) throws KeeperException {
        return ZKUtil.checkExists(this.zookeeper, ZKUtil.joinZNode(this.peersZNode, id)) >= 0;
    }

    protected boolean isPeerPath(String path) {
        return path.split("/").length == this.peersZNode.split("/").length + 1;
    }
}

