/*
 * Decompiled with CFR 0.152.
 */
package org.apache.johnzon.core;

import java.util.Map;
import java.util.stream.Stream;
import javax.json.JsonArray;
import javax.json.JsonObject;
import javax.json.JsonValue;
import javax.json.stream.JsonParser;
import org.apache.johnzon.core.JohnzonJsonParser;
import org.apache.johnzon.core.JsonReaderImpl;

public abstract class JohnzonJsonParserImpl
implements JohnzonJsonParser {
    protected abstract boolean isInArray();

    public JsonObject getObject() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException(current + " doesn't support getObject()");
        }
        JsonReaderImpl jsonReader = new JsonReaderImpl(this, true);
        return jsonReader.readObject();
    }

    public JsonArray getArray() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_ARRAY) {
            throw new IllegalStateException(current + " doesn't support getArray()");
        }
        JsonReaderImpl jsonReader = new JsonReaderImpl(this, true);
        return jsonReader.readArray();
    }

    public JsonValue getValue() {
        JsonParser.Event current = this.current();
        if (current != JsonParser.Event.START_ARRAY && current != JsonParser.Event.START_OBJECT) {
            throw new IllegalStateException(current + " doesn't support getArray()");
        }
        JsonReaderImpl jsonReader = new JsonReaderImpl(this, true);
        return jsonReader.readValue();
    }

    public void skipObject() {
        int level = 1;
        do {
            JsonParser.Event event;
            if ((event = this.next()) == JsonParser.Event.START_OBJECT) {
                ++level;
                continue;
            }
            if (event != JsonParser.Event.END_OBJECT) continue;
            --level;
        } while (level > 0 && this.hasNext());
    }

    public void skipArray() {
        if (this.isInArray()) {
            int level = 1;
            do {
                JsonParser.Event event;
                if ((event = this.next()) == JsonParser.Event.START_ARRAY) {
                    ++level;
                    continue;
                }
                if (event != JsonParser.Event.END_ARRAY) continue;
                --level;
            } while (level > 0 && this.hasNext());
        }
    }

    public Stream<JsonValue> getArrayStream() {
        return this.getArray().stream();
    }

    public Stream<Map.Entry<String, JsonValue>> getObjectStream() {
        return this.getObject().entrySet().stream();
    }

    public Stream<JsonValue> getValueStream() {
        JsonParser.Event current = this.current();
        if (current == JsonParser.Event.START_ARRAY) {
            return this.getArrayStream();
        }
        if (current == JsonParser.Event.START_OBJECT) {
            return this.getObject().values().stream();
        }
        throw new IllegalStateException(current + " doesn't support getValueStream");
    }
}

