/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.connect.runtime;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.management.RuntimeMXBean;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.kafka.common.utils.Utils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkerInfo {
    private static final Logger log = LoggerFactory.getLogger(WorkerInfo.class);
    private static final RuntimeMXBean RUNTIME = ManagementFactory.getRuntimeMXBean();
    private static final OperatingSystemMXBean OS = ManagementFactory.getOperatingSystemMXBean();
    private final Map<String, Object> values = new LinkedHashMap<String, Object>();

    public WorkerInfo() {
        this.addRuntimeInfo();
        this.addSystemInfo();
    }

    public void logAll() {
        StringBuilder b = new StringBuilder();
        b.append(this.getClass().getSimpleName());
        b.append(" values: ");
        b.append(Utils.NL);
        for (Map.Entry<String, Object> entry : this.values.entrySet()) {
            b.append('\t');
            b.append(entry.getKey());
            b.append(" = ");
            b.append(WorkerInfo.format(entry.getValue()));
            b.append(Utils.NL);
        }
        log.info(b.toString());
    }

    private static Object format(Object value) {
        return value == null ? "NA" : value;
    }

    protected void addRuntimeInfo() {
        List<String> jvmArgs = RUNTIME.getInputArguments();
        this.values.put("jvm.args", Utils.join(jvmArgs, (String)", "));
        Object[] jvmSpec = new String[]{RUNTIME.getVmVendor(), RUNTIME.getVmName(), RUNTIME.getSystemProperties().get("java.version"), RUNTIME.getVmVersion()};
        this.values.put("jvm.spec", Utils.join((Object[])jvmSpec, (String)", "));
        this.values.put("jvm.classpath", RUNTIME.getClassPath());
    }

    protected void addSystemInfo() {
        Object[] osInfo = new String[]{OS.getName(), OS.getArch(), OS.getVersion()};
        this.values.put("os.spec", Utils.join((Object[])osInfo, (String)", "));
        this.values.put("os.vcpus", String.valueOf(OS.getAvailableProcessors()));
    }
}

