/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.processor.internals;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.clients.consumer.ConsumerRecords;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.LogContext;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.streams.StreamsConfig;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.errors.StreamsException;
import org.apache.kafka.streams.processor.StateRestoreListener;
import org.apache.kafka.streams.processor.internals.GlobalProcessorContextImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateMaintainer;
import org.apache.kafka.streams.processor.internals.GlobalStateManagerImpl;
import org.apache.kafka.streams.processor.internals.GlobalStateUpdateTask;
import org.apache.kafka.streams.processor.internals.ProcessorTopology;
import org.apache.kafka.streams.processor.internals.StateDirectory;
import org.apache.kafka.streams.processor.internals.StreamThread;
import org.apache.kafka.streams.processor.internals.StreamsMetricsImpl;
import org.apache.kafka.streams.processor.internals.ThreadStateTransitionValidator;
import org.apache.kafka.streams.state.internals.ThreadCache;
import org.slf4j.Logger;

public class GlobalStreamThread
extends Thread {
    private final Logger log;
    private final LogContext logContext;
    private final StreamsConfig config;
    private final Consumer<byte[], byte[]> consumer;
    private final StateDirectory stateDirectory;
    private final Time time;
    private final ThreadCache cache;
    private final StreamsMetrics streamsMetrics;
    private final ProcessorTopology topology;
    private volatile StreamsException startupException;
    private volatile State state = State.CREATED;
    private final Object stateLock = new Object();
    private StreamThread.StateListener stateListener = null;
    private final String logPrefix;
    private final StateRestoreListener stateRestoreListener;

    public void setStateListener(StreamThread.StateListener listener) {
        this.stateListener = listener;
    }

    public State state() {
        return this.state;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setState(State newState) {
        State oldState = this.state;
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.PENDING_SHUTDOWN && newState == State.PENDING_SHUTDOWN) {
                return false;
            }
            if (this.state == State.DEAD) {
                return false;
            }
            if (!this.state.isValidTransition(newState)) {
                this.log.error("Unexpected state transition from {} to {}", (Object)oldState, (Object)newState);
                throw new StreamsException(this.logPrefix + "Unexpected state transition from " + oldState + " to " + newState);
            }
            this.log.info("State transition from {} to {}", (Object)oldState, (Object)newState);
            this.state = newState;
        }
        if (this.stateListener != null) {
            this.stateListener.onChange(this, this.state, oldState);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean stillRunning() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state.isRunning();
        }
    }

    public GlobalStreamThread(ProcessorTopology topology, StreamsConfig config, Consumer<byte[], byte[]> globalConsumer, StateDirectory stateDirectory, Metrics metrics, Time time, String threadClientId, StateRestoreListener stateRestoreListener) {
        super(threadClientId);
        this.time = time;
        this.config = config;
        this.topology = topology;
        this.consumer = globalConsumer;
        this.stateDirectory = stateDirectory;
        long cacheSizeBytes = Math.max(0L, config.getLong("cache.max.bytes.buffering") / (long)(config.getInt("num.stream.threads") + 1));
        this.streamsMetrics = new StreamsMetricsImpl(metrics, threadClientId, Collections.singletonMap("client-id", threadClientId));
        this.logPrefix = String.format("global-stream-thread [%s] ", threadClientId);
        this.logContext = new LogContext(this.logPrefix);
        this.log = this.logContext.logger(this.getClass());
        this.cache = new ThreadCache(this.logContext, cacheSizeBytes, this.streamsMetrics);
        this.stateRestoreListener = stateRestoreListener;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        StateConsumer stateConsumer = this.initialize();
        if (stateConsumer == null) {
            this.setState(State.PENDING_SHUTDOWN);
            this.setState(State.DEAD);
            this.log.warn("Error happened during initialization of the global state store; this thread has shutdown");
            return;
        }
        this.setState(State.RUNNING);
        try {
            while (this.stillRunning()) {
                stateConsumer.pollAndUpdate();
            }
        }
        finally {
            this.setState(State.PENDING_SHUTDOWN);
            this.log.info("Shutting down");
            try {
                stateConsumer.close();
            }
            catch (IOException e) {
                this.log.error("Failed to close state maintainer due to the following error:", (Throwable)e);
            }
            this.setState(State.DEAD);
            this.log.info("Shutdown complete");
        }
    }

    private StateConsumer initialize() {
        try {
            GlobalStateManagerImpl stateMgr = new GlobalStateManagerImpl(this.topology, this.consumer, this.stateDirectory, this.stateRestoreListener);
            StateConsumer stateConsumer = new StateConsumer(this.logContext, this.consumer, new GlobalStateUpdateTask(this.topology, new GlobalProcessorContextImpl(this.config, stateMgr, this.streamsMetrics, this.cache), stateMgr, this.config.defaultDeserializationExceptionHandler(), this.logContext), this.time, this.config.getLong("poll.ms"), this.config.getLong("commit.interval.ms"));
            stateConsumer.initialize();
            return stateConsumer;
        }
        catch (StreamsException e) {
            this.startupException = e;
        }
        catch (Exception e) {
            this.startupException = new StreamsException("Exception caught during initialization of GlobalStreamThread", e);
        }
        return null;
    }

    @Override
    public synchronized void start() {
        super.start();
        while (!this.stillRunning()) {
            Utils.sleep((long)1L);
            if (this.startupException == null) continue;
            throw this.startupException;
        }
    }

    public void shutdown() {
        this.setState(State.PENDING_SHUTDOWN);
    }

    static class StateConsumer {
        private final Consumer<byte[], byte[]> consumer;
        private final GlobalStateMaintainer stateMaintainer;
        private final Time time;
        private final long pollMs;
        private final long flushInterval;
        private final Logger log;
        private long lastFlush;

        StateConsumer(LogContext logContext, Consumer<byte[], byte[]> consumer, GlobalStateMaintainer stateMaintainer, Time time, long pollMs, long flushInterval) {
            this.log = logContext.logger(this.getClass());
            this.consumer = consumer;
            this.stateMaintainer = stateMaintainer;
            this.time = time;
            this.pollMs = pollMs;
            this.flushInterval = flushInterval;
        }

        void initialize() {
            Map<TopicPartition, Long> partitionOffsets = this.stateMaintainer.initialize();
            this.consumer.assign(partitionOffsets.keySet());
            for (Map.Entry<TopicPartition, Long> entry : partitionOffsets.entrySet()) {
                this.consumer.seek(entry.getKey(), entry.getValue().longValue());
            }
            this.lastFlush = this.time.milliseconds();
        }

        void pollAndUpdate() {
            ConsumerRecords received = this.consumer.poll(this.pollMs);
            for (ConsumerRecord record : received) {
                this.stateMaintainer.update((ConsumerRecord<byte[], byte[]>)record);
            }
            long now = this.time.milliseconds();
            if (this.flushInterval >= 0L && now >= this.lastFlush + this.flushInterval) {
                this.stateMaintainer.flushState();
                this.lastFlush = now;
            }
        }

        public void close() throws IOException {
            try {
                this.consumer.close();
            }
            catch (Exception e) {
                this.log.error("Failed to close consumer due to the following error:", (Throwable)e);
            }
            this.stateMaintainer.close();
        }
    }

    public static enum State implements ThreadStateTransitionValidator
    {
        CREATED(1, 2),
        RUNNING(2),
        PENDING_SHUTDOWN(3),
        DEAD(new Integer[0]);

        private final Set<Integer> validTransitions = new HashSet<Integer>();

        private State(Integer ... validTransitions) {
            this.validTransitions.addAll(Arrays.asList(validTransitions));
        }

        public boolean isRunning() {
            return this.equals(RUNNING);
        }

        @Override
        public boolean isValidTransition(ThreadStateTransitionValidator newState) {
            State tmpState = (State)newState;
            return this.validTransitions.contains(tmpState.ordinal());
        }
    }
}

