/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.streams.state.internals;

import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.utils.Bytes;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.streams.KeyValue;
import org.apache.kafka.streams.StreamsMetrics;
import org.apache.kafka.streams.kstream.Windowed;
import org.apache.kafka.streams.state.KeyValueIterator;
import org.apache.kafka.streams.state.StateSerdes;

class MeteredWindowedKeyValueIterator<K, V>
implements KeyValueIterator<Windowed<K>, V> {
    private final KeyValueIterator<Windowed<Bytes>, byte[]> iter;
    private final Sensor sensor;
    private final StreamsMetrics metrics;
    private final StateSerdes<K, V> serdes;
    private final long startNs;
    private final Time time;

    MeteredWindowedKeyValueIterator(KeyValueIterator<Windowed<Bytes>, byte[]> iter, Sensor sensor, StreamsMetrics metrics, StateSerdes<K, V> serdes, Time time) {
        this.iter = iter;
        this.sensor = sensor;
        this.metrics = metrics;
        this.serdes = serdes;
        this.startNs = time.nanoseconds();
        this.time = time;
    }

    @Override
    public boolean hasNext() {
        return this.iter.hasNext();
    }

    @Override
    public KeyValue<Windowed<K>, V> next() {
        KeyValue next = (KeyValue)this.iter.next();
        return KeyValue.pair(this.windowedKey((Windowed)next.key), this.serdes.valueFrom((byte[])next.value));
    }

    private Windowed<K> windowedKey(Windowed<Bytes> bytesKey) {
        K key = this.serdes.keyFrom(bytesKey.key().get());
        return new Windowed<K>(key, bytesKey.window());
    }

    @Override
    public void remove() {
        this.iter.remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() {
        try {
            this.iter.close();
        }
        finally {
            this.metrics.recordLatency(this.sensor, this.startNs, this.time.nanoseconds());
        }
    }

    @Override
    public Windowed<K> peekNextKey() {
        return this.windowedKey(this.iter.peekNextKey());
    }
}

