/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.util.Properties;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.admin.AdminClient;
import org.apache.kafka.clients.ClientUtils;
import org.apache.kafka.clients.CommonClientConfigs;
import org.apache.kafka.clients.KafkaClient;
import org.apache.kafka.clients.Metadata;
import org.apache.kafka.clients.NetworkClient;
import org.apache.kafka.clients.consumer.internals.ConsumerNetworkClient;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.network.ChannelBuilder;
import org.apache.kafka.common.network.Selectable;
import org.apache.kafka.common.network.Selector;
import org.apache.kafka.common.utils.Time;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;

public final class AdminClient$ {
    public static AdminClient$ MODULE$;
    private final int DefaultConnectionMaxIdleMs;
    private final int DefaultRequestTimeoutMs;
    private final int DefaultMaxInFlightRequestsPerConnection;
    private final int DefaultReconnectBackoffMs;
    private final int DefaultSendBufferBytes;
    private final int DefaultReceiveBufferBytes;
    private final int DefaultRetryBackoffMs;
    private final AtomicInteger AdminClientIdSequence;
    private final ConfigDef AdminConfigDef;

    static {
        new AdminClient$();
    }

    public int DefaultConnectionMaxIdleMs() {
        return this.DefaultConnectionMaxIdleMs;
    }

    public int DefaultRequestTimeoutMs() {
        return this.DefaultRequestTimeoutMs;
    }

    public int DefaultMaxInFlightRequestsPerConnection() {
        return this.DefaultMaxInFlightRequestsPerConnection;
    }

    public int DefaultReconnectBackoffMs() {
        return this.DefaultReconnectBackoffMs;
    }

    public int DefaultSendBufferBytes() {
        return this.DefaultSendBufferBytes;
    }

    public int DefaultReceiveBufferBytes() {
        return this.DefaultReceiveBufferBytes;
    }

    public int DefaultRetryBackoffMs() {
        return this.DefaultRetryBackoffMs;
    }

    public AtomicInteger AdminClientIdSequence() {
        return this.AdminClientIdSequence;
    }

    public ConfigDef AdminConfigDef() {
        return this.AdminConfigDef;
    }

    public AdminClient createSimplePlaintext(String brokerUrl) {
        Map config = (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"bootstrap.servers"), (Object)brokerUrl)}));
        return this.create(new AdminClient.AdminConfig(config));
    }

    public AdminClient create(Properties props) {
        return this.create(((TraversableOnce)JavaConverters$.MODULE$.propertiesAsScalaMapConverter(props).asScala()).toMap(Predef$.MODULE$.$conforms()));
    }

    public AdminClient create(Map<String, ?> props) {
        return this.create(new AdminClient.AdminConfig(props));
    }

    public AdminClient create(AdminClient.AdminConfig config) {
        Time time = Time.SYSTEM;
        Metrics metrics = new Metrics(time);
        Metadata metadata = new Metadata();
        ChannelBuilder channelBuilder = ClientUtils.createChannelBuilder((java.util.Map)config.values());
        java.util.List brokerUrls = config.getList("bootstrap.servers");
        java.util.List brokerAddresses = ClientUtils.parseAndValidateAddresses((java.util.List)brokerUrls);
        Cluster bootstrapCluster = Cluster.bootstrap((java.util.List)brokerAddresses);
        metadata.update(bootstrapCluster, 0L);
        Selector selector = new Selector((long)this.DefaultConnectionMaxIdleMs(), metrics, time, "admin", channelBuilder);
        NetworkClient networkClient = new NetworkClient((Selectable)selector, metadata, "admin-" + this.AdminClientIdSequence().getAndIncrement(), this.DefaultMaxInFlightRequestsPerConnection(), (long)this.DefaultReconnectBackoffMs(), this.DefaultSendBufferBytes(), this.DefaultReceiveBufferBytes(), this.DefaultRequestTimeoutMs(), time, true);
        ConsumerNetworkClient highLevelClient = new ConsumerNetworkClient((KafkaClient)networkClient, metadata, time, (long)this.DefaultRetryBackoffMs(), (long)this.DefaultRequestTimeoutMs());
        return new AdminClient(time, this.DefaultRequestTimeoutMs(), highLevelClient, (List<Node>)((TraversableOnce)JavaConverters$.MODULE$.asScalaBufferConverter(bootstrapCluster.nodes()).asScala()).toList());
    }

    /*
     * WARNING - void declaration
     */
    private AdminClient$() {
        void var1_1;
        MODULE$ = this;
        this.DefaultConnectionMaxIdleMs = 540000;
        this.DefaultRequestTimeoutMs = 5000;
        this.DefaultMaxInFlightRequestsPerConnection = 100;
        this.DefaultReconnectBackoffMs = 50;
        this.DefaultSendBufferBytes = 131072;
        this.DefaultReceiveBufferBytes = 32768;
        this.DefaultRetryBackoffMs = 100;
        this.AdminClientIdSequence = new AtomicInteger(1);
        ConfigDef config = new ConfigDef().define("bootstrap.servers", ConfigDef.Type.LIST, ConfigDef.Importance.HIGH, "A list of host/port pairs to use for establishing the initial connection to the Kafka cluster. The client will make use of all servers irrespective of which servers are specified here for bootstrapping&mdash;this list only impacts the initial hosts used to discover the full set of servers. This list should be in the form <code>host1:port1,host2:port2,...</code>. Since these servers are just used for the initial connection to discover the full cluster membership (which may change dynamically), this list need not contain the full set of servers (you may want more than one, though, in case a server is down).").define("security.protocol", ConfigDef.Type.STRING, (Object)"PLAINTEXT", ConfigDef.Importance.MEDIUM, CommonClientConfigs.SECURITY_PROTOCOL_DOC).withClientSslSupport().withClientSaslSupport();
        this.AdminConfigDef = var1_1;
    }
}

