/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import kafka.api.LeaderAndIsr$;
import kafka.api.PartitionStateInfo;
import kafka.server.AdminManager;
import kafka.server.CreateTopicMetadata;
import kafka.server.DelayedOperation;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.CreateTopicsResponse;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Option;
import scala.Predef$;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableOnce;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction2;

@ScalaSignature(bytes="\u0006\u0001I4A!\u0001\u0002\u0001\u000f\t\u0019B)\u001a7bs\u0016$7I]3bi\u0016$v\u000e]5dg*\u00111\u0001B\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0015\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001\u0011A\u0011\u0011BC\u0007\u0002\u0005%\u00111B\u0001\u0002\u0011\t\u0016d\u0017-_3e\u001fB,'/\u0019;j_:D\u0011\"\u0004\u0001\u0003\u0002\u0003\u0006IA\u0004\u000b\u0002\u000f\u0011,G.Y=NgB\u0011qBE\u0007\u0002!)\t\u0011#A\u0003tG\u0006d\u0017-\u0003\u0002\u0014!\t!Aj\u001c8h\u0013\ti!\u0002\u0003\u0005\u0017\u0001\t\u0005\t\u0015!\u0003\u0018\u00039\u0019'/Z1uK6+G/\u00193bi\u0006\u00042\u0001G\u000e\u001e\u001b\u0005I\"B\u0001\u000e\u0011\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u00039e\u00111aU3r!\tIa$\u0003\u0002 \u0005\t\u00192I]3bi\u0016$v\u000e]5d\u001b\u0016$\u0018\rZ1uC\"A\u0011\u0005\u0001B\u0001B\u0003%!%\u0001\u0007bI6Lg.T1oC\u001e,'\u000f\u0005\u0002\nG%\u0011AE\u0001\u0002\r\u0003\u0012l\u0017N\\'b]\u0006<WM\u001d\u0005\tM\u0001\u0011\t\u0011)A\u0005O\u0005\u0001\"/Z:q_:\u001cXmQ1mY\n\f7m\u001b\t\u0005\u001f!R\u0013*\u0003\u0002*!\tIa)\u001e8di&|g.\r\t\u00051-j\u0003(\u0003\u0002-3\t\u0019Q*\u00199\u0011\u00059*dBA\u00184!\t\u0001\u0004#D\u00012\u0015\t\u0011d!\u0001\u0004=e>|GOP\u0005\u0003iA\ta\u0001\u0015:fI\u00164\u0017B\u0001\u001c8\u0005\u0019\u0019FO]5oO*\u0011A\u0007\u0005\t\u0003s\u0019s!A\u000f#\u000e\u0003mR!\u0001P\u001f\u0002\u0011I,\u0017/^3tiNT!AP \u0002\r\r|W.\\8o\u0015\t)\u0001I\u0003\u0002B\u0005\u00061\u0011\r]1dQ\u0016T\u0011aQ\u0001\u0004_J<\u0017BA#<\u0003Q\u0019%/Z1uKR{\u0007/[2t%\u0016\u001c\bo\u001c8tK&\u0011q\t\u0013\u0002\u0006\u000bJ\u0014xN\u001d\u0006\u0003\u000bn\u0002\"a\u0004&\n\u0005-\u0003\"\u0001B+oSRDQ!\u0014\u0001\u0005\u00029\u000ba\u0001P5oSRtD#B(Q#J\u001b\u0006CA\u0005\u0001\u0011\u0015iA\n1\u0001\u000f\u0011\u00151B\n1\u0001\u0018\u0011\u0015\tC\n1\u0001#\u0011\u00151C\n1\u0001(\u0011\u0015)\u0006\u0001\"\u0011W\u0003-!(/_\"p[BdW\r^3\u0015\u0003]\u0003\"a\u0004-\n\u0005e\u0003\"a\u0002\"p_2,\u0017M\u001c\u0005\u00067\u0002!\t\u0005X\u0001\u000b_:\u001cu.\u001c9mKR,G#A%\t\u000by\u0003A\u0011\t/\u0002\u0019=tW\t\u001f9je\u0006$\u0018n\u001c8\t\u000b\u0001\u0004A\u0011B1\u0002%5L7o]5oO2+\u0017\rZ3s\u0007>,h\u000e\u001e\u000b\u0004E\u0016<\u0007CA\bd\u0013\t!\u0007CA\u0002J]RDQAZ0A\u00025\nQ\u0001^8qS\u000eDQ\u0001[0A\u0002%\f!\u0002]1si&$\u0018n\u001c8t!\rA\"NY\u0005\u0003Wf\u00111aU3u\u0011\u0015i\u0007\u0001\"\u0003o\u0003=I7/T5tg&tw\rT3bI\u0016\u0014HcA,pa\")a\r\u001ca\u0001[!)\u0011\u000f\u001ca\u0001E\u0006I\u0001/\u0019:uSRLwN\u001c")
public class DelayedCreateTopics
extends DelayedOperation {
    private final Seq<CreateTopicMetadata> createMetadata;
    private final AdminManager adminManager;
    private final Function1<Map<String, CreateTopicsResponse.Error>, BoxedUnit> responseCallback;

    @Override
    public boolean tryComplete() {
        boolean bl;
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Trying to complete operation for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.createMetadata})));
        int leaderlessPartitionCount = BoxesRunTime.unboxToInt((Object)((TraversableOnce)this.createMetadata.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DelayedCreateTopics.$anonfun$tryComplete$2(x$1)))).foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToInteger((int)DelayedCreateTopics.$anonfun$tryComplete$3(this, BoxesRunTime.unboxToInt((Object)x0$1), x1$1))));
        if (leaderlessPartitionCount == 0) {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "All partitions have a leader, completing the delayed operation");
            bl = this.forceComplete();
        } else {
            this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"", " partitions do not have a leader, not completing the delayed operation"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)leaderlessPartitionCount)})));
            bl = false;
        }
        return bl;
    }

    @Override
    public void onComplete() {
        this.trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Completing operation for ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{$this.createMetadata})));
        scala.collection.immutable.Map results = ((TraversableOnce)this.createMetadata.map((Function1 & Serializable & scala.Serializable)metadata -> metadata.error().is(Errors.NONE) && this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet()) > 0 ? new Tuple2((Object)metadata.topic(), (Object)new CreateTopicsResponse.Error(Errors.REQUEST_TIMED_OUT, null)) : new Tuple2((Object)metadata.topic(), (Object)metadata.error()), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
        this.responseCallback.apply((Object)results);
    }

    @Override
    public void onExpiration() {
    }

    private int missingLeaderCount(String topic, Set<Object> partitions) {
        return BoxesRunTime.unboxToInt((Object)partitions.foldLeft((Object)BoxesRunTime.boxToInteger((int)0), (Function2)(JFunction2.mcIII.sp & Serializable & scala.Serializable)(x0$2, x1$2) -> {
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(x0$2, x1$2);
            if (sp2 == null) {
                throw new MatchError((Object)sp2);
            }
            int counter = sp2._1$mcI$sp();
            int partition = sp2._2$mcI$sp();
            int n = this.isMissingLeader(topic, partition) ? counter + 1 : counter;
            return n;
        }));
    }

    private boolean isMissingLeader(String topic, int partition) {
        Option<PartitionStateInfo> partitionInfo = this.adminManager.metadataCache().getPartitionInfo(topic, partition);
        return partitionInfo.isEmpty() || ((PartitionStateInfo)partitionInfo.get()).leaderIsrAndControllerEpoch().leaderAndIsr().leader() == LeaderAndIsr$.MODULE$.NoLeader();
    }

    public static final /* synthetic */ boolean $anonfun$tryComplete$2(CreateTopicMetadata x$1) {
        return x$1.error().is(Errors.NONE);
    }

    public static final /* synthetic */ int $anonfun$tryComplete$3(DelayedCreateTopics $this, int x0$1, CreateTopicMetadata x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        int topicCounter = tuple2._1$mcI$sp();
        CreateTopicMetadata metadata = (CreateTopicMetadata)tuple2._2();
        int n = topicCounter + $this.missingLeaderCount(metadata.topic(), (Set<Object>)metadata.replicaAssignments().keySet());
        return n;
    }

    public DelayedCreateTopics(long delayMs, Seq<CreateTopicMetadata> createMetadata, AdminManager adminManager, Function1<Map<String, CreateTopicsResponse.Error>, BoxedUnit> responseCallback) {
        this.createMetadata = createMetadata;
        this.adminManager = adminManager;
        this.responseCallback = responseCallback;
        super(delayMs);
    }
}

