/*
 * Decompiled with CFR 0.152.
 */
package kafka.tools;

import java.io.Serializable;
import kafka.api.OffsetRequest;
import kafka.api.OffsetRequest$;
import kafka.api.PartitionOffsetRequestInfo;
import kafka.api.PartitionOffsetsResponse;
import kafka.cluster.Broker;
import kafka.cluster.BrokerEndPoint;
import kafka.common.KafkaException;
import kafka.common.TopicAndPartition;
import kafka.consumer.ConsumerConfig;
import kafka.consumer.SimpleConsumer;
import kafka.utils.ZKGroupTopicDirs;
import kafka.utils.ZkUtils;
import kafka.utils.ZkUtils$;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.SecurityProtocol;
import org.apache.kafka.common.security.JaasUtils;
import org.apache.kafka.common.utils.Utils;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.List$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.Map;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.java8.JFunction1;
import scala.runtime.java8.JFunction2;

public final class UpdateOffsetsInZK$ {
    public static UpdateOffsetsInZK$ MODULE$;
    private final String Earliest;
    private final String Latest;

    static {
        new UpdateOffsetsInZK$();
    }

    public String Earliest() {
        return this.Earliest;
    }

    public String Latest() {
        return this.Latest;
    }

    public void main(String[] args) {
        if (args.length < 3) {
            this.usage();
        }
        ConsumerConfig config = new ConsumerConfig(Utils.loadProps((String)args[1]));
        ZkUtils zkUtils = ZkUtils$.MODULE$.apply(config.zkConnect(), config.zkSessionTimeoutMs(), config.zkConnectionTimeoutMs(), JaasUtils.isZkSecurityEnabled());
        String string = args[0];
        String string2 = this.Earliest();
        String string3 = string;
        if (!(string2 != null ? !string2.equals(string3) : string3 != null)) {
            this.getAndSetOffsets(zkUtils, OffsetRequest$.MODULE$.EarliestTime(), config, args[2]);
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        } else {
            String string4 = this.Latest();
            String string5 = string;
            if (!(string4 != null ? !string4.equals(string5) : string5 != null)) {
                this.getAndSetOffsets(zkUtils, OffsetRequest$.MODULE$.LatestTime(), config, args[2]);
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            } else {
                this.usage();
                BoxedUnit boxedUnit = BoxedUnit.UNIT;
            }
        }
    }

    private void getAndSetOffsets(ZkUtils zkUtils, long offsetOption, ConsumerConfig config, String topic) {
        Map<String, Seq<Object>> partitionsPerTopicMap = zkUtils.getPartitionsForTopics((Seq<String>)List$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{topic})));
        Nil$ partitions = Nil$.MODULE$;
        Option option = partitionsPerTopicMap.get((Object)topic);
        if (!(option instanceof Some)) {
            throw new RuntimeException("Can't find topic " + topic);
        }
        Some some = (Some)option;
        Seq l = (Seq)some.value();
        partitions = (Seq)l.sortWith((Function2)(JFunction2.mcZII.sp & Serializable & scala.Serializable)(s, t) -> s < t);
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
        IntRef numParts = IntRef.create((int)0);
        partitions.foreach((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)partition -> {
            int b;
            Option<Object> brokerHostingPartition = zkUtils.getLeaderForPartition(topic, partition);
            Option<Object> option = brokerHostingPartition;
            if (!(option instanceof Some)) {
                if (None$.MODULE$.equals(option)) {
                    throw new KafkaException("Broker " + brokerHostingPartition + " is unavailable. Cannot issue " + "getOffsetsBefore request");
                }
                throw new MatchError(option);
            }
            Some some = (Some)option;
            int n = b = BoxesRunTime.unboxToInt((Object)some.value());
            int broker = n;
            Option<Broker> option2 = zkUtils.getBrokerInfo(broker);
            if (option2 instanceof Some) {
                Some some2 = (Some)option2;
                Broker brokerInfo = (Broker)some2.value();
                BrokerEndPoint brokerEndPoint = brokerInfo.getBrokerEndPoint(ListenerName.forSecurityProtocol((SecurityProtocol)SecurityProtocol.PLAINTEXT));
                SimpleConsumer consumer = new SimpleConsumer(brokerEndPoint.host(), brokerEndPoint.port(), 10000, 102400, "UpdateOffsetsInZk");
                TopicAndPartition topicAndPartition = new TopicAndPartition(topic, partition);
                OffsetRequest request = new OffsetRequest((scala.collection.immutable.Map<TopicAndPartition, PartitionOffsetRequestInfo>)((scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicAndPartition), (Object)new PartitionOffsetRequestInfo(offsetOption, 1))}))), OffsetRequest$.MODULE$.apply$default$2(), OffsetRequest$.MODULE$.apply$default$3(), OffsetRequest$.MODULE$.apply$default$4(), OffsetRequest$.MODULE$.apply$default$5());
                long offset = BoxesRunTime.unboxToLong((Object)((PartitionOffsetsResponse)consumer.getOffsetsBefore(request).partitionErrorAndOffsets().apply((Object)topicAndPartition)).offsets().head());
                ZKGroupTopicDirs topicDirs = new ZKGroupTopicDirs(config.groupId(), topic);
                Predef$.MODULE$.println((Object)("updating partition " + partition + " with new offset: " + offset));
                zkUtils.updatePersistentPath(topicDirs.consumerOffsetDir() + "/" + partition, ((Object)BoxesRunTime.boxToLong((long)offset)).toString(), zkUtils.updatePersistentPath$default$3());
                ++numParts$1.elem;
            } else {
                if (None$.MODULE$.equals(option2)) {
                    throw new KafkaException(new StringOps(Predef$.MODULE$.augmentString("Broker information for broker id %d does not exist in ZK")).format((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)broker)})));
                }
                throw new MatchError(option2);
            }
            BoxedUnit boxedUnit = BoxedUnit.UNIT;
        });
        Predef$.MODULE$.println((Object)("updated the offset for " + numParts.elem + " partitions"));
    }

    private void usage() {
        Predef$.MODULE$.println((Object)("USAGE: " + this.getClass().getName() + " [earliest | latest] consumer.properties topic"));
        System.exit(1);
    }

    private UpdateOffsetsInZK$() {
        MODULE$ = this;
        this.Earliest = "earliest";
        this.Latest = "latest";
    }
}

