/*
 * Decompiled with CFR 0.152.
 */
package kafka.admin;

import java.io.Serializable;
import java.util.Collection;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.Future;
import kafka.admin.BrokerMetadata;
import kafka.admin.RackAwareTest;
import kafka.admin.ReassignPartitionsCommand$;
import kafka.admin.ReassignPartitionsIntegrationTest$;
import kafka.admin.ReplicaDistributions;
import kafka.admin.TopicCommand;
import kafka.server.KafkaConfig$;
import kafka.server.KafkaServer;
import kafka.utils.TestUtils$;
import kafka.zk.ZooKeeperTestHarness;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewPartitionReassignment;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.errors.InvalidReplicaAssignmentException;
import org.apache.kafka.test.TestUtils;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import scala.Function1;
import scala.MatchError;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.JavaConverters$;
import scala.collection.Map;
import scala.collection.Map$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.collection.immutable.StringOps;
import scala.math.Ordering;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ud\u0001\u0002\u0010 \u0001\u0011BQa\f\u0001\u0005\u0002ABqA\r\u0001A\u0002\u0013\u00051\u0007C\u0004C\u0001\u0001\u0007I\u0011A\"\t\r)\u0003\u0001\u0015)\u00035\u0011\u001dY\u0005A1A\u0005\u00021Ca\u0001\u0015\u0001!\u0002\u0013i\u0005bB)\u0001\u0005\u0004%\t\u0001\u0014\u0005\u0007%\u0002\u0001\u000b\u0011B'\t\u000fM\u0003!\u0019!C\u0001\u0019\"1A\u000b\u0001Q\u0001\n5Cq!\u0016\u0001C\u0002\u0013\u0005A\n\u0003\u0004W\u0001\u0001\u0006I!\u0014\u0005\b/\u0002\u0011\r\u0011\"\u0001M\u0011\u0019A\u0006\u0001)A\u0005\u001b\"9\u0011\f\u0001b\u0001\n\u0003a\u0005B\u0002.\u0001A\u0003%Q\nC\u0004\\\u0001\t\u0007I\u0011\u0001/\t\r-\u0004\u0001\u0015!\u0003^\u0011\u0015a\u0007\u0001\"\u0011n\u0011\u00159\b\u0001\"\u0011n\u0011\u0015a\b\u0001\"\u0001n\u0011\u0019\t\u0019\u0001\u0001C\u0001[\"1\u0011q\u0001\u0001\u0005\u00025<q!a\u0003 \u0011\u0003\tiA\u0002\u0004\u001f?!\u0005\u0011q\u0002\u0005\u0007_e!\t!a\u0006\t\u000f\u0005e\u0011\u0004\"\u0001\u0002\u001c!9\u0011QH\r\u0005\u0002\u0005}\u0002bBA43\u0011\u0005\u0011\u0011\u000e\u0002\"%\u0016\f7o]5h]B\u000b'\u000f^5uS>t7/\u00138uK\u001e\u0014\u0018\r^5p]R+7\u000f\u001e\u0006\u0003A\u0005\nQ!\u00193nS:T\u0011AI\u0001\u0006W\u000647.Y\u0002\u0001'\r\u0001Qe\u000b\t\u0003M%j\u0011a\n\u0006\u0003Q\u0005\n!A_6\n\u0005):#\u0001\u0006.p_.+W\r]3s)\u0016\u001cH\u000fS1s]\u0016\u001c8\u000f\u0005\u0002-[5\tq$\u0003\u0002/?\ti!+Y2l\u0003^\f'/\u001a+fgR\fa\u0001P5oSRtD#A\u0019\u0011\u00051\u0002\u0011aB:feZ,'o]\u000b\u0002iA\u0019QG\u000f\u001f\u000e\u0003YR!a\u000e\u001d\u0002\u0015\r|G\u000e\\3di&|gNC\u0001:\u0003\u0015\u00198-\u00197b\u0013\tYdGA\u0002TKF\u0004\"!\u0010!\u000e\u0003yR!aP\u0011\u0002\rM,'O^3s\u0013\t\teHA\u0006LC\u001a\\\u0017mU3sm\u0016\u0014\u0018aC:feZ,'o]0%KF$\"\u0001\u0012%\u0011\u0005\u00153U\"\u0001\u001d\n\u0005\u001dC$\u0001B+oSRDq!S\u0002\u0002\u0002\u0003\u0007A'A\u0002yIE\n\u0001b]3sm\u0016\u00148\u000fI\u0001\bEJ|7.\u001a:2+\u0005i\u0005CA#O\u0013\ty\u0005HA\u0002J]R\f\u0001B\u0019:pW\u0016\u0014\u0018\u0007I\u0001\bEJ|7.\u001a:3\u0003!\u0011'o\\6feJ\u0002\u0013a\u00022s_.,'oM\u0001\tEJ|7.\u001a:4A\u00059!M]8lKJ$\u0014\u0001\u00032s_.,'\u000f\u000e\u0011\u0002\u000f\t\u0014xn[3sk\u0005A!M]8lKJ,\u0004%A\u0004ce>\\WM\u001d\u001c\u0002\u0011\t\u0014xn[3sm\u0001\nAA]1dWV\tQ\f\u0005\u0003_C6\u001bW\"A0\u000b\u0005\u00014\u0014!C5n[V$\u0018M\u00197f\u0013\t\u0011wLA\u0002NCB\u0004\"\u0001Z5\u000e\u0003\u0015T!AZ4\u0002\t1\fgn\u001a\u0006\u0002Q\u0006!!.\u0019<b\u0013\tQWM\u0001\u0004TiJLgnZ\u0001\u0006e\u0006\u001c7\u000eI\u0001\u0006g\u0016$X\u000b\u001d\u000b\u0002\t\"\u00121c\u001c\t\u0003aVl\u0011!\u001d\u0006\u0003eN\fQA[;oSRT\u0011\u0001^\u0001\u0004_J<\u0017B\u0001<r\u0005\u0019\u0011UMZ8sK\u0006AA/Z1s\t><h\u000e\u000b\u0002\u0015sB\u0011\u0001O_\u0005\u0003wF\u0014Q!\u00114uKJ\fQ\u0003^3tiJ\u000b7m[!xCJ,'+Z1tg&<g\u000e\u000b\u0002\u0016}B\u0011\u0001o`\u0005\u0004\u0003\u0003\t(\u0001\u0002+fgR\fQ\u0003^3tiJ+\u0017m]:jO:\u0004\u0016M\u001d;ji&|g\u000e\u000b\u0002\u0017}\u0006)B/Z:u\u0013:4\u0018\r\\5e%\u0016\u0004H.[2b\u0013\u0012\u001c\bFA\f\u007f\u0003\u0005\u0012V-Y:tS\u001et\u0007+\u0019:uSRLwN\\:J]R,wM]1uS>tG+Z:u!\ta\u0013dE\u0002\u001a\u0003#\u00012!RA\n\u0013\r\t)\u0002\u000f\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\u00055\u0011\u0001D2sK\u0006$XmQ8oM&<G\u0003BA\u000f\u0003w\u0001\u0002\"a\b\u0002.\u0005E\u0012Q\u0007\b\u0005\u0003C\tI\u0003E\u0002\u0002$aj!!!\n\u000b\u0007\u0005\u001d2%\u0001\u0004=e>|GOP\u0005\u0004\u0003WA\u0014A\u0002)sK\u0012,g-C\u0002c\u0003_Q1!a\u000b9!\u0011\ty\"a\r\n\u0007)\fy\u0003E\u0002e\u0003oI1!!\u000ff\u0005\u0019y%M[3di\")!g\u0007a\u0001i\u0005\t\"/Z1tg&<g.\\3oi\u0016sGO]=\u0015\t\u0005\u0005\u0013\u0011\r\t\u0007\u0003\u0007\nI%!\u0014\u000e\u0005\u0005\u0015#bAA$O\u0006!Q\u000f^5m\u0013\u0011\tY%!\u0012\u0003\u0011=\u0003H/[8oC2\u0004B!a\u0014\u0002^5\u0011\u0011\u0011\u000b\u0006\u0004A\u0005M#\u0002BA+\u0003/\nqa\u00197jK:$8OC\u0002#\u00033R1!a\u0017t\u0003\u0019\t\u0007/Y2iK&!\u0011qLA)\u0005aqUm\u001e)beRLG/[8o%\u0016\f7o]5h]6,g\u000e\u001e\u0005\b\u0003Gb\u0002\u0019AA3\u0003!\u0011X\r\u001d7jG\u0006\u001c\bcA\u001b;\u001b\u0006\ts/Y5u\r>\u0014\u0018\t\u001c7SK\u0006\u001c8/[4o[\u0016tGo\u001d+p\u0007>l\u0007\u000f\\3uKR\u0019A)a\u001b\t\u000f\u00055T\u00041\u0001\u0002p\u000511\r\\5f]R\u0004B!a\u0014\u0002r%!\u00111OA)\u0005-\tE-\\5o\u00072LWM\u001c;")
public class ReassignPartitionsIntegrationTest
extends ZooKeeperTestHarness
implements RackAwareTest {
    private Seq<KafkaServer> servers;
    private final int broker1;
    private final int broker2;
    private final int broker3;
    private final int broker4;
    private final int broker5;
    private final int broker6;
    private final scala.collection.immutable.Map<Object, String> rack;

    public static void waitForAllReassignmentsToComplete(AdminClient adminClient) {
        ReassignPartitionsIntegrationTest$.MODULE$.waitForAllReassignmentsToComplete(adminClient);
    }

    public static Optional<NewPartitionReassignment> reassignmentEntry(Seq<Object> seq) {
        return ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry(seq);
    }

    public static scala.collection.immutable.Map<String, Object> createConfig(Seq<KafkaServer> seq) {
        return ReassignPartitionsIntegrationTest$.MODULE$.createConfig(seq);
    }

    @Override
    public void checkReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping, int numBrokers, int numPartitions, int replicationFactor, boolean verifyRackAware, boolean verifyLeaderDistribution, boolean verifyReplicasDistribution) {
        RackAwareTest.checkReplicaDistribution$(this, assignment, brokerRackMapping, numBrokers, numPartitions, replicationFactor, verifyRackAware, verifyLeaderDistribution, verifyReplicasDistribution);
    }

    @Override
    public boolean checkReplicaDistribution$default$6() {
        return RackAwareTest.checkReplicaDistribution$default$6$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$7() {
        return RackAwareTest.checkReplicaDistribution$default$7$(this);
    }

    @Override
    public boolean checkReplicaDistribution$default$8() {
        return RackAwareTest.checkReplicaDistribution$default$8$(this);
    }

    @Override
    public ReplicaDistributions getReplicaDistribution(Map<Object, Seq<Object>> assignment, Map<Object, String> brokerRackMapping) {
        return RackAwareTest.getReplicaDistribution$(this, assignment, brokerRackMapping);
    }

    @Override
    public Seq<BrokerMetadata> toBrokerMetadata(Map<Object, String> rackMap, Seq<Object> brokersWithoutRack) {
        return RackAwareTest.toBrokerMetadata$(this, rackMap, brokersWithoutRack);
    }

    @Override
    public Seq<Object> toBrokerMetadata$default$2() {
        return RackAwareTest.toBrokerMetadata$default$2$(this);
    }

    public Seq<KafkaServer> servers() {
        return this.servers;
    }

    public void servers_$eq(Seq<KafkaServer> x$1) {
        this.servers = x$1;
    }

    public int broker1() {
        return this.broker1;
    }

    public int broker2() {
        return this.broker2;
    }

    public int broker3() {
        return this.broker3;
    }

    public int broker4() {
        return this.broker4;
    }

    public int broker5() {
        return this.broker5;
    }

    public int broker6() {
        return this.broker6;
    }

    public scala.collection.immutable.Map<Object, String> rack() {
        return this.rack;
    }

    @Override
    @Before
    public void setUp() {
        super.setUp();
        Seq<Properties> brokerConfigs = TestUtils$.MODULE$.createBrokerConfigs(6, this.zkConnect(), true, TestUtils$.MODULE$.createBrokerConfigs$default$4(), TestUtils$.MODULE$.createBrokerConfigs$default$5(), TestUtils$.MODULE$.createBrokerConfigs$default$6(), TestUtils$.MODULE$.createBrokerConfigs$default$7(), TestUtils$.MODULE$.createBrokerConfigs$default$8(), TestUtils$.MODULE$.createBrokerConfigs$default$9(), TestUtils$.MODULE$.createBrokerConfigs$default$10(), TestUtils$.MODULE$.createBrokerConfigs$default$11(), TestUtils$.MODULE$.createBrokerConfigs$default$12(), TestUtils$.MODULE$.createBrokerConfigs$default$13(), TestUtils$.MODULE$.createBrokerConfigs$default$14(), TestUtils$.MODULE$.createBrokerConfigs$default$15(), TestUtils$.MODULE$.createBrokerConfigs$default$16());
        this.servers_$eq((Seq<KafkaServer>)((Seq)brokerConfigs.map((Function1 & Serializable & scala.Serializable)config -> {
            String string = config.getProperty(KafkaConfig$.MODULE$.BrokerIdProp());
            if (Predef$.MODULE$ == null) {
                throw null;
            }
            config.setProperty(KafkaConfig$.MODULE$.RackProp(), (String)this.rack().apply((Object)BoxesRunTime.boxToInteger((int)new StringOps(string).toInt())));
            config.setProperty(KafkaConfig$.MODULE$.AutoLeaderRebalanceEnableProp(), "false");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownMaxRetriesProp(), "1");
            config.setProperty(KafkaConfig$.MODULE$.ControlledShutdownRetryBackoffMsProp(), "1000");
            config.setProperty(KafkaConfig$.MODULE$.ReplicaLagTimeMaxMsProp(), "1000");
            return TestUtils$.MODULE$.createServer(KafkaConfig$.MODULE$.fromProps(config), TestUtils$.MODULE$.createServer$default$2());
        }, Seq$.MODULE$.canBuildFrom())));
    }

    @Override
    @After
    public void tearDown() {
        TestUtils$.MODULE$.shutdownServers(this.servers());
        super.tearDown();
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testRackAwareReassign() {
        void var6_6;
        int numPartitions = 18;
        int replicationFactor = 3;
        TopicCommand.TopicCommandOptions createOpts = new TopicCommand.TopicCommandOptions((String[])((Object[])new String[]{"--partitions", ((Object)BoxesRunTime.boxToInteger((int)numPartitions)).toString(), "--replication-factor", ((Object)BoxesRunTime.boxToInteger((int)replicationFactor)).toString(), "--disable-rack-aware", "--topic", "foo"}));
        new TopicCommand.ZookeeperTopicService(this.zkClient()).createTopic(createOpts);
        String topicJson = "{\"topics\": [{\"topic\": \"foo\"}], \"version\":1}";
        Tuple2 tuple2 = ReassignPartitionsCommand$.MODULE$.generateAssignment(this.zkClient(), (Seq)this.rack().keys().toSeq().sorted((Ordering)Ordering.Int$.MODULE$), topicJson, false);
        if (tuple2 == null) {
            throw new MatchError(null);
        }
        Map proposedAssignment = (Map)tuple2._1();
        Map cfr_ignored_0 = (Map)tuple2._2();
        Map assignment = (Map)var6_6.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            TopicPartition topicPartition = (TopicPartition)x0$1._1();
            Seq replicas = (Seq)x0$1._2();
            Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)topicPartition.partition()), (Object)replicas);
            return tuple2;
        }, Map$.MODULE$.canBuildFrom());
        this.checkReplicaDistribution((Map<Object, Seq<Object>>)assignment, (Map<Object, String>)this.rack(), this.rack().size(), numPartitions, replicationFactor, this.checkReplicaDistribution$default$6(), this.checkReplicaDistribution$default$7(), this.checkReplicaDistribution$default$8());
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testReassignPartition() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ReassignPartitionsIntegrationTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ReassignPartitionsIntegrationTest.$anonfun$testReassignPartition$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Test
    public void testInvalidReplicaIds() {
        void resource_resource;
        AdminClient adminClient = AdminClient.create((java.util.Map)((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(ReassignPartitionsIntegrationTest$.MODULE$.createConfig(this.servers())).asJava()));
        if (TestUtils$.MODULE$ == null) {
            throw null;
        }
        try {
            void var3_2 = resource_resource;
            ReassignPartitionsIntegrationTest.$anonfun$testInvalidReplicaIds$1(this, (AdminClient)var3_2);
        }
        finally {
            resource_resource.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$testReassignPartition$1(ReassignPartitionsIntegrationTest $this, AdminClient client) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        String topic = "test-topic";
        int n = 0;
        Integer partition = Predef$.MODULE$.int2Integer(n);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer($this.broker1()), Predef$.MODULE$.int2Integer($this.broker2())}))).asJava();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        java.util.Map partitionAssignment = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        NewTopic newTopic = new NewTopic(topic, partitionAssignment);
        client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, n);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Optional<NewPartitionReassignment> optional = ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all().get();
        ReassignPartitionsIntegrationTest$.MODULE$.waitForAllReassignmentsToComplete(client);
        TestUtils$.MODULE$.waitForReplicasAssigned((Admin)client, topicPartition, (Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker3(), $this.broker4()}))));
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ InvalidReplicaAssignmentException $anonfun$testInvalidReplicaIds$1(ReassignPartitionsIntegrationTest $this, AdminClient client) {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        String topic = "test-topic";
        int n = 0;
        Integer partition = Predef$.MODULE$.int2Integer(n);
        Tuple2[] tuple2Array = new Tuple2[1];
        Object object = JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Integer[]{Predef$.MODULE$.int2Integer($this.broker1()), Predef$.MODULE$.int2Integer($this.broker2())}))).asJava();
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)partition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        java.util.Map partitionAssignment = (java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array))).asJava();
        NewTopic newTopic = new NewTopic(topic, partitionAssignment);
        client.createTopics((Collection)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new NewTopic[]{newTopic}))).asJava()).all().get();
        TopicPartition topicPartition = new TopicPartition(topic, n);
        TestUtils$.MODULE$.waitForBrokersInIsr((Admin)client, topicPartition, (Set<Object>)((Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker1(), $this.broker2()}))));
        Tuple2[] tuple2Array2 = new Tuple2[1];
        Optional<NewPartitionReassignment> optional = ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{$this.broker4(), $this.broker5(), $this.broker5()}))));
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array2[0] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        TestUtils.assertFutureThrows((Future)client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array2))).asJava()).all(), InvalidReplicaAssignmentException.class);
        Tuple2[] tuple2Array3 = new Tuple2[1];
        Optional<NewPartitionReassignment> optional2 = ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{-1, $this.broker3()}))));
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array3[0] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        TestUtils.assertFutureThrows((Future)client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array3))).asJava()).all(), InvalidReplicaAssignmentException.class);
        Tuple2[] tuple2Array4 = new Tuple2[1];
        Optional<NewPartitionReassignment> optional3 = ReassignPartitionsIntegrationTest$.MODULE$.reassignmentEntry((Seq<Object>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{6, $this.broker2(), $this.broker3()}))));
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)topicPartition);
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array4[0] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        return (InvalidReplicaAssignmentException)TestUtils.assertFutureThrows((Future)client.alterPartitionReassignments((java.util.Map)JavaConverters$.MODULE$.mapAsJavaMapConverter((Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array4))).asJava()).all(), InvalidReplicaAssignmentException.class);
    }

    /*
     * WARNING - void declaration
     */
    public ReassignPartitionsIntegrationTest() {
        void $minus$greater$extension_y;
        void $minus$greater$extension_$this;
        void $minus$greater$extension_y2;
        void $minus$greater$extension_$this2;
        void $minus$greater$extension_y3;
        void $minus$greater$extension_$this3;
        void $minus$greater$extension_y4;
        void $minus$greater$extension_$this4;
        void $minus$greater$extension_y5;
        void $minus$greater$extension_$this5;
        void $minus$greater$extension_y6;
        void $minus$greater$extension_$this6;
        RackAwareTest.$init$(this);
        this.servers = (Seq)Seq$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.broker1 = 0;
        this.broker2 = 1;
        this.broker3 = 2;
        this.broker4 = 3;
        this.broker5 = 4;
        this.broker6 = 5;
        Tuple2[] tuple2Array = new Tuple2[6];
        String string = "rack1";
        Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker1()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[0] = new Tuple2((Object)$minus$greater$extension_$this6, (Object)$minus$greater$extension_y6);
        String string2 = "rack2";
        Object object2 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker2()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[1] = new Tuple2((Object)$minus$greater$extension_$this5, (Object)$minus$greater$extension_y5);
        String string3 = "rack2";
        Object object3 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker3()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[2] = new Tuple2((Object)$minus$greater$extension_$this4, (Object)$minus$greater$extension_y4);
        String string4 = "rack1";
        Object object4 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker4()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[3] = new Tuple2((Object)$minus$greater$extension_$this3, (Object)$minus$greater$extension_y3);
        String string5 = "rack3";
        Object object5 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker5()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[4] = new Tuple2((Object)$minus$greater$extension_$this2, (Object)$minus$greater$extension_y2);
        String string6 = "rack3";
        Object object6 = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)this.broker6()));
        if (Predef.ArrowAssoc$.MODULE$ == null) {
            throw null;
        }
        tuple2Array[5] = new Tuple2((Object)$minus$greater$extension_$this, (Object)$minus$greater$extension_y);
        this.rack = (scala.collection.immutable.Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])tuple2Array));
    }

    public static final /* synthetic */ Object $anonfun$testReassignPartition$1$adapted(ReassignPartitionsIntegrationTest $this, AdminClient client) {
        ReassignPartitionsIntegrationTest.$anonfun$testReassignPartition$1($this, client);
        return BoxedUnit.UNIT;
    }
}

