/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.util.Collections;
import kafka.server.QuotaType;
import kafka.server.ReplicationQuotaManager;
import kafka.server.ReplicationQuotaManagerConfig;
import kafka.server.ReplicationQuotaManagerConfig$;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.metrics.KafkaMetric;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Quota;
import org.apache.kafka.common.utils.MockTime;
import org.apache.kafka.common.utils.Time;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;
import scala.Predef$;
import scala.collection.JavaConverters$;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001m3A\u0001D\u0007\u0001%!)\u0011\u0004\u0001C\u00015!9Q\u0004\u0001b\u0001\n\u0013q\u0002B\u0002\u0017\u0001A\u0003%q\u0004C\u0004.\u0001\t\u0007I\u0011\u0002\u0018\t\rQ\u0002\u0001\u0015!\u00030\u0011\u0015)\u0004\u0001\"\u00017\u0011\u0015\t\u0005\u0001\"\u00017\u0011\u00151\u0005\u0001\"\u00017\u0011\u0015A\u0005\u0001\"\u0001J\u0011\u0015q\u0005\u0001\"\u00017\u0011\u0015\u0001\u0006\u0001\"\u0003R\u0005m\u0011V\r\u001d7jG\u0006$\u0018n\u001c8Rk>$\u0018-T1oC\u001e,'\u000fV3ti*\u0011abD\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003A\tQa[1gW\u0006\u001c\u0001a\u0005\u0002\u0001'A\u0011AcF\u0007\u0002+)\ta#A\u0003tG\u0006d\u0017-\u0003\u0002\u0019+\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#A\u000e\u0011\u0005q\u0001Q\"A\u0007\u0002\tQLW.Z\u000b\u0002?A\u0011\u0001EK\u0007\u0002C)\u0011!eI\u0001\u0006kRLGn\u001d\u0006\u0003I\u0015\naaY8n[>t'B\u0001\t'\u0015\t9\u0003&\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002S\u0005\u0019qN]4\n\u0005-\n#\u0001C'pG.$\u0016.\\3\u0002\u000bQLW.\u001a\u0011\u0002\u000f5,GO]5dgV\tq\u0006\u0005\u00021e5\t\u0011G\u0003\u0002.G%\u00111'\r\u0002\b\u001b\u0016$(/[2t\u0003!iW\r\u001e:jGN\u0004\u0013\u0001\u0003;fCJ$un\u001e8\u0015\u0003]\u0002\"\u0001\u0006\u001d\n\u0005e*\"\u0001B+oSRD#AB\u001e\u0011\u0005qzT\"A\u001f\u000b\u0005yB\u0013!\u00026v]&$\u0018B\u0001!>\u0005\u0015\te\r^3s\u0003\u0005\u001a\bn\\;mIRC'o\u001c;uY\u0016|e\u000e\\=EK\u001aLg.\u001a3SKBd\u0017nY1tQ\t91\t\u0005\u0002=\t&\u0011Q)\u0010\u0002\u0005)\u0016\u001cH/A\u001btQ>,H\u000eZ#yG\u0016,G-U;pi\u0006$\u0006.\u001a8SKR,(O\u001c\"bG.\u0014U\r\\8x\u0005>,h\u000eZ!t)&lW\rU1tg\u0016\u001c\bF\u0001\u0005D\u0003\u0011\u0011\u0018\r^3\u0015\u0005)k\u0005C\u0001\u000bL\u0013\taUC\u0001\u0004E_V\u0014G.\u001a\u0005\u0006[%\u0001\raL\u0001'g\"|W\u000f\u001c3TkB\u0004xN\u001d;XS2$7-\u0019:e)\"\u0014x\u000e\u001e;mK\u0012\u0014V\r\u001d7jG\u0006\u001c\bF\u0001\u0006D\u0003\r!\b/\r\u000b\u0003%Z\u0003\"a\u0015+\u000e\u0003\rJ!!V\u0012\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\")qk\u0003a\u00011\u0006\u0011\u0011\u000e\u001a\t\u0003)eK!AW\u000b\u0003\u0007%sG\u000f")
public class ReplicationQuotaManagerTest {
    private final MockTime time = new MockTime();
    private final Metrics metrics = new Metrics(new MetricConfig(), Collections.emptyList(), (Time)this.time());

    private MockTime time() {
        return this.time;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    @After
    public void tearDown() {
        this.metrics().close();
    }

    @Test
    public void shouldThrottleOnlyDefinedReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.Fetch$.MODULE$, (Time)this.time());
        quota.markThrottled("topic1", (Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapIntArray(new int[]{1, 2, 3})));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(1)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(2)));
        Assert.assertTrue((boolean)quota.isThrottled(this.tp1(3)));
        Assert.assertFalse((boolean)quota.isThrottled(this.tp1(4)));
    }

    @Test
    public void shouldExceedQuotaThenReturnBackBelowBoundAsTimePasses() {
        int x$1 = 10;
        int x$2 = 1;
        long x$3 = ReplicationQuotaManagerConfig$.MODULE$.apply$default$1();
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(x$3, x$1, x$2), this.metrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.updateQuota(new Quota(100.0, true));
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        this.time().sleep(1000L);
        this.time().sleep(500L);
        quota.record(1L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(149L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertEquals((double)100.66666666666667, (double)this.rate(this.metrics()), (double)0.0);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        this.time().sleep(500L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)75.5, (double)this.rate(this.metrics()), (double)0.1);
        this.time().sleep(500L);
        quota.record(99L);
        Assert.assertEquals((double)100.0, (double)this.rate(this.metrics()), (double)0.0);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        quota.record(1L);
        Assert.assertTrue((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)100.4, (double)this.rate(this.metrics()), (double)0.0);
        this.time().sleep(2000L);
        Assert.assertFalse((boolean)quota.isQuotaExceeded());
        Assert.assertEquals((double)55.77777777777778, (double)this.rate(this.metrics()), (double)0.0);
    }

    public double rate(Metrics metrics) {
        MetricName metricName = metrics.metricName("byte-rate", QuotaType.LeaderReplication$.MODULE$.toString(), new StringBuilder(23).append("Tracking byte-rate for ").append(QuotaType.LeaderReplication$.MODULE$).toString());
        return BoxesRunTime.unboxToDouble((Object)((KafkaMetric)((MapLike)JavaConverters$.MODULE$.mapAsScalaMapConverter(metrics.metrics()).asScala()).apply((Object)metricName)).metricValue());
    }

    @Test
    public void shouldSupportWildcardThrottledReplicas() {
        ReplicationQuotaManager quota = new ReplicationQuotaManager(new ReplicationQuotaManagerConfig(ReplicationQuotaManagerConfig$.MODULE$.apply$default$1(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$2(), ReplicationQuotaManagerConfig$.MODULE$.apply$default$3()), this.metrics(), (QuotaType)QuotaType.LeaderReplication$.MODULE$, (Time)this.time());
        quota.markThrottled("MyTopic");
        Assert.assertTrue((boolean)quota.isThrottled(new TopicPartition("MyTopic", 0)));
        Assert.assertFalse((boolean)quota.isThrottled(new TopicPartition("MyOtherTopic", 0)));
    }

    private TopicPartition tp1(int id) {
        return new TopicPartition("topic1", id);
    }
}

