/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import kafka.coordinator.transaction.CompleteAbort$;
import kafka.coordinator.transaction.CompleteCommit$;
import kafka.coordinator.transaction.Empty$;
import kafka.coordinator.transaction.Ongoing$;
import kafka.coordinator.transaction.PrepareAbort$;
import kafka.coordinator.transaction.PrepareCommit$;
import kafka.coordinator.transaction.PrepareEpochFence$;
import kafka.coordinator.transaction.TransactionMetadata;
import kafka.coordinator.transaction.TransactionMetadata$;
import kafka.coordinator.transaction.TransactionState;
import kafka.coordinator.transaction.TxnTransitMetadata;
import kafka.utils.MockTime;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.protocol.Errors;
import org.junit.Assert;
import org.junit.Test;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.collection.Seq;
import scala.collection.mutable.Set;
import scala.collection.mutable.Set$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0001\u0005Ma\u0001B\u000f\u001f\u0001\u0015BQ\u0001\f\u0001\u0005\u00025Bq\u0001\r\u0001C\u0002\u0013\u0005\u0011\u0007\u0003\u00049\u0001\u0001\u0006IA\r\u0005\bs\u0001\u0011\r\u0011\"\u0001;\u0011\u0019q\u0004\u0001)A\u0005w!9q\b\u0001b\u0001\n\u0003\u0001\u0005BB%\u0001A\u0003%\u0011\tC\u0003K\u0001\u0011\u00051\nC\u0003Y\u0001\u0011\u00051\nC\u0003[\u0001\u0011\u00051\nC\u0003b\u0001\u0011\u00051\nC\u0003d\u0001\u0011\u00051\nC\u0003f\u0001\u0011\u00051\nC\u0003h\u0001\u0011\u00051\nC\u0003j\u0001\u0011\u00051\nC\u0003l\u0001\u0011\u00051\nC\u0003n\u0001\u0011\u00051\nC\u0003p\u0001\u0011\u00051\nC\u0003r\u0001\u0011\u00051\nC\u0003t\u0001\u0011\u00051\nC\u0003v\u0001\u0011\u00051\nC\u0003x\u0001\u0011\u00051\nC\u0003z\u0001\u0011\u00051\nC\u0003|\u0001\u0011\u00051\nC\u0003~\u0001\u0011\u00051\nC\u0003\u0000\u0001\u0011\u00051\n\u0003\u0004\u0002\u0004\u0001!\ta\u0013\u0005\u0007k\u0002!I!a\u0002\u0003/Q\u0013\u0018M\\:bGRLwN\\'fi\u0006$\u0017\r^1UKN$(BA\u0010!\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005\u0005\u0012\u0013aC2p_J$\u0017N\\1u_JT\u0011aI\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001a\u0005\u0005\u0002(U5\t\u0001FC\u0001*\u0003\u0015\u00198-\u00197b\u0013\tY\u0003F\u0001\u0004B]f\u0014VMZ\u0001\u0007y%t\u0017\u000e\u001e \u0015\u00039\u0002\"a\f\u0001\u000e\u0003y\tA\u0001^5nKV\t!\u0007\u0005\u00024m5\tAG\u0003\u00026E\u0005)Q\u000f^5mg&\u0011q\u0007\u000e\u0002\t\u001b>\u001c7\u000eV5nK\u0006)A/[7fA\u0005Q\u0001O]8ek\u000e,'/\u00133\u0016\u0003m\u0002\"a\n\u001f\n\u0005uB#\u0001\u0002'p]\u001e\f1\u0002\u001d:pIV\u001cWM]%eA\u0005yAO]1og\u0006\u001cG/[8oC2LE-F\u0001B!\t\u0011u)D\u0001D\u0015\t!U)\u0001\u0003mC:<'\"\u0001$\u0002\t)\fg/Y\u0005\u0003\u0011\u000e\u0013aa\u0015;sS:<\u0017\u0001\u0005;sC:\u001c\u0018m\u0019;j_:\fG.\u00133!\u0003M!Xm\u001d;J]&$\u0018.\u00197ju\u0016,\u0005o\\2i)\u0005a\u0005CA\u0014N\u0013\tq\u0005F\u0001\u0003V]&$\bF\u0001\u0005Q!\t\tf+D\u0001S\u0015\t\u0019F+A\u0003kk:LGOC\u0001V\u0003\ry'oZ\u0005\u0003/J\u0013A\u0001V3ti\u0006\u0019B/Z:u\u001d>\u0014X.\u00197Fa>\u001c\u0007NQ;na\"\u0012\u0011\u0002U\u0001)i\u0016\u001cHOQ;na\u0016\u0003xn\u00195O_R\fE\u000e\\8xK\u0012Le-\u00129pG\"\u001cX\t\u001f5bkN$X\r\u001a\u0015\u0005\u0015AcV,\u0001\u0005fqB,7\r^3eG\u0005q\u0006C\u0001\"`\u0013\t\u00017IA\u000bJY2,w-\u00197Ti\u0006$X-\u0012=dKB$\u0018n\u001c8\u0002UQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3Va\u0012\fG/\u001a+j[\u0016\u001c\u0006.\u001b4u\tV\u0014\u0018N\\4Fa>\u001c\u0007NQ;na\"\u00121\u0002U\u00014i\u0016\u001cH\u000fV8mKJ\fG/Z+qI\u0006$X\rV5nKJ+7/\u001a;EkJLgn\u001a)s_\u0012,8-\u001a:JIJ{G/\u0019;j_:D#\u0001\u0004)\u0002QQ,7\u000f\u001e+pY\u0016\u0014\u0018\r^3US6,7\u000b[5gi\u0012+(/\u001b8h\u0003\u0012$\u0007+\u0019:uSRLwN\\:)\u00055\u0001\u0016\u0001\u000b;fgR$v\u000e\\3sCR,G+[7f'\"Lg\r\u001e#ve&tw\r\u0015:fa\u0006\u0014XmQ8n[&$\bF\u0001\bQ\u0003\u001d\"Xm\u001d;U_2,'/\u0019;f)&lWm\u00155jMR$UO]5oOB\u0013X\r]1sK\u0006\u0013wN\u001d;)\u0005=\u0001\u0016!\u000b;fgR$v\u000e\\3sCR,G+[7f'\"Lg\r\u001e#ve&twmQ8na2,G/Z\"p[6LG\u000f\u000b\u0002\u0011!\u0006AC/Z:u)>dWM]1uKRKW.Z*iS\u001a$H)\u001e:j]\u001e\u001cu.\u001c9mKR,\u0017IY8si\"\u0012\u0011\u0003U\u0001&i\u0016\u001cHOR3oG\u0016\u0004&o\u001c3vG\u0016\u0014\u0018I\u001a;fe\u0016\u0003xn\u00195t\u000bbD\u0017-^:uK\u0012D#A\u0005)\u0002YQ,7\u000f\u001e$f]\u000e,\u0007K]8ek\u000e,'OT8u\u00032dwn^3e\u0013\u001aLEoV8vY\u0012|e/\u001a:gY><\b\u0006B\nQ9v\u000bA\u0003^3tiJ{G/\u0019;f!J|G-^2fe&#\u0007F\u0001\u000bQ\u0003\t\"Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI&swJ\\4pS:<7\u000b^1uK\"\"Q\u0003\u0015/^\u0003\u001d\"Xm\u001d;S_R\fG/\u001a)s_\u0012,8-\u001a:JI&s\u0007K]3qCJ,\u0017IY8siN#\u0018\r^3)\tY\u0001F,X\u0001)i\u0016\u001cHOU8uCR,\u0007K]8ek\u000e,'/\u00133J]B\u0013X\r]1sK\u000e{W.\\5u'R\fG/\u001a\u0015\u0005/AcV,\u0001\u0018uKN$\u0018\t\u001e;f[B$X\rZ#q_\u000eD')^7q/&$\bNT3xYf\u001c%/Z1uK\u0012lU\r^1eCR\f\u0007F\u0001\rQ\u0003\u0015\"Xm\u001d;Fa>\u001c\u0007NQ;na^KG\u000f[\"veJ,g\u000e^#q_\u000eD\u0007K]8wS\u0012,G\r\u000b\u0002\u001a!\u0006\u0019C/Z:u\u0003R$X-\u001c9uK\u0012,\u0005o\\2i\u0005Vl\u0007oV5uQ2\u000b7\u000f^#q_\u000eD\u0007F\u0001\u000eQ\u0003\u0015\"Xm\u001d;BiR,W\u000e\u001d;fI\u0016\u0003xn\u00195Ck6\u0004x+\u001b;i\r\u0016t7-\u001a3Fa>\u001c\u0007\u000e\u000b\u0002\u001c!R\u0019A*!\u0003\t\u000f\u0005-A\u00041\u0001\u0002\u000e\u0005)1\u000f^1uKB\u0019q&a\u0004\n\u0007\u0005EaD\u0001\tUe\u0006t7/Y2uS>t7\u000b^1uK\u0002")
public class TransactionMetadataTest {
    private final MockTime time = new MockTime();
    private final long producerId;
    private final String transactionalId;

    public MockTime time() {
        return this.time;
    }

    public long producerId() {
        return this.producerId;
    }

    public String transactionalId() {
        return this.transactionalId;
    }

    @Test
    public void testInitializeEpoch() {
        short producerEpoch = -1;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testNormalEpochBump() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testBumpEpochNotAllowedIfEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareIncrementProducerEpoch(30000, (Option)None$.MODULE$, this.time().milliseconds());
    }

    @Test
    public void testTolerateUpdateTimeShiftDuringEpochBump() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, Option$.MODULE$.apply((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.time().milliseconds() - 1L).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateUpdateTimeResetDuringProducerIdRotation() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(this.producerId() + 1L, 30000, this.time().milliseconds() - 1L, true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)(this.producerId() + 1L), (long)txnMetadata.producerId());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringAddPartitions() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Empty$.MODULE$, Set$.MODULE$.empty(), this.time().milliseconds(), this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0)})), (Object)txnMetadata.topicPartitions());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
        transitMetadata = txnMetadata.prepareAddPartitions((scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic2", 0)})), this.time().milliseconds() - 2L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)Predef$.MODULE$.Set().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new TopicPartition[]{new TopicPartition("topic1", 0), new TopicPartition("topic2", 0)})), (Object)txnMetadata.topicPartitions());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 2L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareCommit$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)PrepareCommit$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringPrepareAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)Ongoing$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)PrepareAbort$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteCommit() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareCommit$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)CompleteCommit$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testTolerateTimeShiftDuringCompleteAbort() {
        short producerEpoch = 1;
        TransactionMetadata txnMetadata = new TransactionMetadata(this.transactionalId(), this.producerId(), -1L, producerEpoch, -1, 30000, (TransactionState)PrepareAbort$.MODULE$, Set$.MODULE$.empty(), 1L, this.time().milliseconds());
        TxnTransitMetadata transitMetadata = txnMetadata.prepareComplete(this.time().milliseconds() - 1L);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((Object)CompleteAbort$.MODULE$, (Object)txnMetadata.state());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)1L, (long)txnMetadata.txnStartTimestamp());
        Assert.assertEquals((long)(this.time().milliseconds() - 1L), (long)txnMetadata.txnLastUpdateTimestamp());
    }

    @Test
    public void testFenceProducerAfterEpochsExhausted() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        TxnTransitMetadata fencingTransitMetadata = txnMetadata.prepareFenceProducerEpoch();
        Assert.assertEquals((long)32767L, (long)fencingTransitMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)fencingTransitMetadata.lastProducerEpoch());
        Assert.assertEquals((Object)new Some((Object)PrepareEpochFence$.MODULE$), (Object)txnMetadata.pendingState());
        txnMetadata.pendingState_$eq((Option)None$.MODULE$);
        TxnTransitMetadata transitMetadata = txnMetadata.prepareAbortOrCommit((TransactionState)PrepareAbort$.MODULE$, this.time().milliseconds());
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)transitMetadata.producerId());
    }

    @Test(expected=IllegalStateException.class)
    public void testFenceProducerNotAllowedIfItWouldOverflow() {
        short producerEpoch = Short.MAX_VALUE;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Ongoing$ x$7 = Ongoing$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        Assert.assertTrue((boolean)txnMetadata.isProducerEpochExhausted());
        txnMetadata.prepareFenceProducerEpoch();
    }

    @Test
    public void testRotateProducerId() {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        long newProducerId = 9893L;
        TxnTransitMetadata transitMetadata = txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), true);
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)newProducerId, (long)txnMetadata.producerId());
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.lastProducerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInOngoingState() {
        this.testRotateProducerIdInOngoingState((TransactionState)Ongoing$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareAbortState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareAbort$.MODULE$);
    }

    @Test(expected=IllegalStateException.class)
    public void testRotateProducerIdInPrepareCommitState() {
        this.testRotateProducerIdInOngoingState((TransactionState)PrepareCommit$.MODULE$);
    }

    @Test
    public void testAttemptedEpochBumpWithNewlyCreatedMetadata() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$4 = -1;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, x$4, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)0L, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)-1L, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testEpochBumpWithCurrentEpochProvided() {
        short producerEpoch = (short)735;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        short x$5 = -1;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)producerEpoch)), this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)(producerEpoch + 1), (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithLastEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = -1L;
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, lastProducerEpoch, x$6, (TransactionState)x$7, x$8, x$10, x$9);
        TxnTransitMetadata transitMetadata = (TxnTransitMetadata)txnMetadata.prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)lastProducerEpoch)), this.time().milliseconds()).right().get();
        txnMetadata.completeTransitionTo(transitMetadata);
        Assert.assertEquals((long)this.producerId(), (long)txnMetadata.producerId());
        Assert.assertEquals((long)producerEpoch, (long)txnMetadata.producerEpoch());
        Assert.assertEquals((long)lastProducerEpoch, (long)txnMetadata.lastProducerEpoch());
    }

    @Test
    public void testAttemptedEpochBumpWithFencedEpoch() {
        short producerEpoch = (short)735;
        short lastProducerEpoch = (short)(producerEpoch - 1);
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        int x$6 = 30000;
        Empty$ x$7 = Empty$.MODULE$;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        Errors error = (Errors)new TransactionMetadata(x$1, x$2, x$3, producerEpoch, lastProducerEpoch, x$6, (TransactionState)x$7, x$8, x$10, x$9).prepareIncrementProducerEpoch(30000, (Option)new Some((Object)BoxesRunTime.boxToShort((short)((short)(lastProducerEpoch - 1)))), this.time().milliseconds()).left().get();
        Assert.assertEquals((Object)Errors.INVALID_PRODUCER_EPOCH, (Object)error);
    }

    private void testRotateProducerIdInOngoingState(TransactionState state) {
        short producerEpoch = (short)32766;
        String x$1 = this.transactionalId();
        long x$2 = this.producerId();
        long x$3 = this.producerId();
        short x$5 = -1;
        int x$6 = 30000;
        Set x$8 = Set$.MODULE$.empty();
        long x$9 = this.time().milliseconds();
        long x$10 = TransactionMetadata$.MODULE$.$lessinit$greater$default$9();
        TransactionMetadata txnMetadata = new TransactionMetadata(x$1, x$2, x$3, producerEpoch, x$5, x$6, state, x$8, x$10, x$9);
        long newProducerId = 9893L;
        txnMetadata.prepareProducerIdRotation(newProducerId, 30000, this.time().milliseconds(), false);
    }

    public TransactionMetadataTest() {
        this.producerId = 23423L;
        this.transactionalId = "txnlId";
    }
}

