/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kafka.admin.BrokerMetadata;
import kafka.api.LeaderAndIsr$;
import kafka.cluster.Broker;
import kafka.cluster.Broker$;
import kafka.cluster.EndPoint;
import kafka.controller.StateChangeLogger;
import kafka.server.MetadataCache;
import kafka.server.ZkMetadataCache$MetadataSnapshot$;
import kafka.utils.CoreUtils$;
import kafka.utils.Implicits$;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.Cluster;
import org.apache.kafka.common.Node;
import org.apache.kafka.common.PartitionInfo;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.internals.Topic;
import org.apache.kafka.common.message.MetadataResponseData;
import org.apache.kafka.common.message.UpdateMetadataRequestData;
import org.apache.kafka.common.network.ListenerName;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.UpdateMetadataRequest;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenSet;
import scala.collection.Iterable;
import scala.collection.IterableLike;
import scala.collection.Iterator;
import scala.collection.Map;
import scala.collection.MapLike;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.compat.MapExtensionMethods$;
import scala.collection.compat.package$;
import scala.collection.immutable.Iterable$;
import scala.collection.mutable.AnyRefMap;
import scala.collection.mutable.AnyRefMap$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.LongMap;
import scala.collection.mutable.LongMap$;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0001\u0011\u0005a\u0001B#G\u0001-C\u0001\u0002\u0018\u0001\u0003\u0002\u0003\u0006I!\u0018\u0005\u0006A\u0002!\t!\u0019\u0005\bI\u0002\u0011\r\u0011\"\u0003f\u0011\u0019\u0011\b\u0001)A\u0005M\"91\u000f\u0001a\u0001\n\u0013!\b\"\u0003B$\u0001\u0001\u0007I\u0011\u0002B%\u0011\u001d\u0011\u0019\u0006\u0001Q!\nUD\u0011B!\u0018\u0001\u0005\u0004%IAa\u0018\t\u0011\t5\u0004\u0001)A\u0005\u0005CBqAa\u001c\u0001\t\u0013\u0011\t\bC\u0004\u0003\u0012\u0002!IAa%\t\u000f\t\u001d\u0007\u0001\"\u0003\u0003J\"9!\u0011\u001b\u0001\u0005\n\tM\u0007b\u0002Bo\u0001\u0011\u0005!q\u001c\u0005\n\u0005{\u0004\u0011\u0013!C\u0001\u0005\u007fD\u0011ba\u0001\u0001#\u0003%\tAa@\t\u000f\r\u0015\u0001\u0001\"\u0011\u0004\b!91\u0011\u0002\u0001\u0005B\r-\u0001bBB\u0003\u0001\u0011%1\u0011\u0004\u0005\b\u0007;\u0001A\u0011BB\u0010\u0011\u001d\u0019)\u0003\u0001C\u0001\u0007OAqaa\u000b\u0001\t\u0003\u001ai\u0003C\u0004\u00042\u0001!\tea\r\t\u000f\r\r\u0003\u0001\"\u0011\u0004F!911\n\u0001\u0005B\r5\u0003bBB*\u0001\u0011%1Q\u000b\u0005\b\u0007G\u0002A\u0011AB3\u0011\u001d\u0019i\u0007\u0001C\u0001\u0007_Bqaa\u001d\u0001\t\u0003\u0019)\bC\u0004\u0004~\u0001!\taa \t\u000f\r%\u0005\u0001\"\u0001\u0002|!911\u0012\u0001\u0005\u0002\r5\u0005bBBN\u0001\u0011\u00051Q\u0014\u0005\b\u0007k\u0003A\u0011AB\\\u0011\u001d\u0019)\f\u0001C\u0001\u0007wCqaa0\u0001\t\u0013\u0019\tM\u0002\u0003x\u0001\u0001C\b\"C@&\u0005+\u0007I\u0011AA\u0001\u0011)\t\u0019'\nB\tB\u0003%\u00111\u0001\u0005\u000b\u0003K*#Q3A\u0005\u0002\u0005\u001d\u0004BCA<K\tE\t\u0015!\u0003\u0002j!Q\u0011\u0011P\u0013\u0003\u0016\u0004%\t!a\u001f\t\u0015\u0005\rUE!E!\u0002\u0013\ti\b\u0003\u0006\u0002\u0006\u0016\u0012)\u001a!C\u0001\u0003\u000fC!\"a&&\u0005#\u0005\u000b\u0011BAE\u0011)\tI*\nBK\u0002\u0013\u0005\u00111\u0014\u0005\u000b\u0003o+#\u0011#Q\u0001\n\u0005u\u0005B\u00021&\t\u0003\tI\fC\u0005\u0002F\u0016\n\t\u0011\"\u0001\u0002H\"I\u00111[\u0013\u0012\u0002\u0013\u0005\u0011Q\u001b\u0005\n\u0003W,\u0013\u0013!C\u0001\u0003[D\u0011\"!=&#\u0003%\t!a=\t\u0013\u0005]X%%A\u0005\u0002\u0005e\b\"CA\u007fKE\u0005I\u0011AA\u0000\u0011%\u0011\u0019!JA\u0001\n\u0003\u0012)\u0001C\u0005\u0003\u0012\u0015\n\t\u0011\"\u0001\u0003\u0014!I!QC\u0013\u0002\u0002\u0013\u0005!q\u0003\u0005\n\u0005G)\u0013\u0011!C!\u0005KA\u0011B!\f&\u0003\u0003%\tAa\f\t\u0013\teR%!A\u0005B\tm\u0002\"\u0003B\u001fK\u0005\u0005I\u0011\tB \u0011%\u0011\t%JA\u0001\n\u0003\u0012\u0019eB\u0005\u0004P\u0002\t\t\u0011#\u0001\u0004R\u001aAq\u000fAA\u0001\u0012\u0003\u0019\u0019\u000e\u0003\u0004a\u0001\u0012\u00051\u0011\u001d\u0005\n\u0005{\u0001\u0015\u0011!C#\u0005\u007fA\u0011ba9A\u0003\u0003%\ti!:\t\u0013\rE\b)!A\u0005\u0002\u000eM(a\u0004.l\u001b\u0016$\u0018\rZ1uC\u000e\u000b7\r[3\u000b\u0005\u001dC\u0015AB:feZ,'OC\u0001J\u0003\u0015Y\u0017MZ6b\u0007\u0001\u0019B\u0001\u0001'S-B\u0011Q\nU\u0007\u0002\u001d*\tq*A\u0003tG\u0006d\u0017-\u0003\u0002R\u001d\n1\u0011I\\=SK\u001a\u0004\"a\u0015+\u000e\u0003\u0019K!!\u0016$\u0003\u001b5+G/\u00193bi\u0006\u001c\u0015m\u00195f!\t9&,D\u0001Y\u0015\tI\u0006*A\u0003vi&d7/\u0003\u0002\\1\n9Aj\\4hS:<\u0017\u0001\u00032s_.,'/\u00133\u0011\u00055s\u0016BA0O\u0005\rIe\u000e^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0005\t\u001c\u0007CA*\u0001\u0011\u0015a&\u00011\u0001^\u0003U\u0001\u0018M\u001d;ji&|g.T3uC\u0012\fG/\u0019'pG.,\u0012A\u001a\t\u0003OBl\u0011\u0001\u001b\u0006\u0003S*\fQ\u0001\\8dWNT!a\u001b7\u0002\u0015\r|gnY;se\u0016tGO\u0003\u0002n]\u0006!Q\u000f^5m\u0015\u0005y\u0017\u0001\u00026bm\u0006L!!\u001d5\u0003-I+WM\u001c;sC:$(+Z1e/JLG/\u001a'pG.\fa\u0003]1si&$\u0018n\u001c8NKR\fG-\u0019;b\u0019>\u001c7\u000eI\u0001\u0011[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R,\u0012!\u001e\t\u0003m\u0016j\u0011\u0001\u0001\u0002\u0011\u001b\u0016$\u0018\rZ1uCNs\u0017\r]:i_R\u001cB!\n'zyB\u0011QJ_\u0005\u0003w:\u0013q\u0001\u0015:pIV\u001cG\u000f\u0005\u0002N{&\u0011aP\u0014\u0002\r'\u0016\u0014\u0018.\u00197ju\u0006\u0014G.Z\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgV\u0011\u00111\u0001\t\t\u0003\u000b\ty!a\u0005\u0002*5\u0011\u0011q\u0001\u0006\u0005\u0003\u0013\tY!A\u0004nkR\f'\r\\3\u000b\u0007\u00055a*\u0001\u0006d_2dWm\u0019;j_:LA!!\u0005\u0002\b\tI\u0011I\\=SK\u001al\u0015\r\u001d\t\u0005\u0003+\t\u0019C\u0004\u0003\u0002\u0018\u0005}\u0001cAA\r\u001d6\u0011\u00111\u0004\u0006\u0004\u0003;Q\u0015A\u0002\u001fs_>$h(C\u0002\u0002\"9\u000ba\u0001\u0015:fI\u00164\u0017\u0002BA\u0013\u0003O\u0011aa\u0015;sS:<'bAA\u0011\u001dB1\u0011QAA\u0016\u0003_IA!!\f\u0002\b\t9Aj\u001c8h\u001b\u0006\u0004\b\u0003BA\u0019\u0003;rA!a\r\u0002X9!\u0011QGA)\u001d\u0011\t9$a\u0013\u000f\t\u0005e\u0012q\t\b\u0005\u0003w\t\tE\u0004\u0003\u0002\u001a\u0005u\u0012BAA \u0003\ry'oZ\u0005\u0005\u0003\u0007\n)%\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0003\u0003\u007fI1!SA%\u0015\u0011\t\u0019%!\u0012\n\t\u00055\u0013qJ\u0001\u0007G>lWn\u001c8\u000b\u0007%\u000bI%\u0003\u0003\u0002T\u0005U\u0013aB7fgN\fw-\u001a\u0006\u0005\u0003\u001b\ny%\u0003\u0003\u0002Z\u0005m\u0013!G+qI\u0006$X-T3uC\u0012\fG/\u0019*fcV,7\u000f\u001e#bi\u0006TA!a\u0015\u0002V%!\u0011qLA1\u0005q)\u0006\u000fZ1uK6+G/\u00193bi\u0006\u0004\u0016M\u001d;ji&|gn\u0015;bi\u0016TA!!\u0017\u0002\\\u0005\u0001\u0002/\u0019:uSRLwN\\*uCR,7\u000fI\u0001\ti>\u0004\u0018nY%egV\u0011\u0011\u0011\u000e\t\t\u0003+\tY'a\u0005\u0002p%!\u0011QNA\u0014\u0005\ri\u0015\r\u001d\t\u0005\u0003c\n\u0019(\u0004\u0002\u0002V%!\u0011QOA+\u0005\u0011)V/\u001b3\u0002\u0013Q|\u0007/[2JIN\u0004\u0013\u0001D2p]R\u0014x\u000e\u001c7fe&#WCAA?!\u0011i\u0015qP/\n\u0007\u0005\u0005eJ\u0001\u0004PaRLwN\\\u0001\u000eG>tGO]8mY\u0016\u0014\u0018\n\u001a\u0011\u0002\u0019\u0005d\u0017N^3Ce>\\WM]:\u0016\u0005\u0005%\u0005CBA\u0003\u0003W\tY\t\u0005\u0003\u0002\u000e\u0006MUBAAH\u0015\r\t\t\nS\u0001\bG2,8\u000f^3s\u0013\u0011\t)*a$\u0003\r\t\u0013xn[3s\u00035\tG.\u001b<f\u0005J|7.\u001a:tA\u0005Q\u0011\r\\5wK:{G-Z:\u0016\u0005\u0005u\u0005CBA\u0003\u0003W\ty\n\u0005\u0005\u0002\"\u0006\r\u0016QUAY\u001b\t\tY!\u0003\u0003\u0002n\u0005-\u0001\u0003BAT\u0003[k!!!+\u000b\t\u0005-\u0016QK\u0001\b]\u0016$xo\u001c:l\u0013\u0011\ty+!+\u0003\u00191K7\u000f^3oKJt\u0015-\\3\u0011\t\u0005E\u00141W\u0005\u0005\u0003k\u000b)F\u0001\u0003O_\u0012,\u0017aC1mSZ,gj\u001c3fg\u0002\"2\"^A^\u0003{\u000by,!1\u0002D\"1q\u0010\ra\u0001\u0003\u0007Aq!!\u001a1\u0001\u0004\tI\u0007C\u0004\u0002zA\u0002\r!! \t\u000f\u0005\u0015\u0005\u00071\u0001\u0002\n\"9\u0011\u0011\u0014\u0019A\u0002\u0005u\u0015\u0001B2paf$2\"^Ae\u0003\u0017\fi-a4\u0002R\"Aq0\rI\u0001\u0002\u0004\t\u0019\u0001C\u0005\u0002fE\u0002\n\u00111\u0001\u0002j!I\u0011\u0011P\u0019\u0011\u0002\u0003\u0007\u0011Q\u0010\u0005\n\u0003\u000b\u000b\u0004\u0013!a\u0001\u0003\u0013C\u0011\"!'2!\u0003\u0005\r!!(\u0002\u001d\r|\u0007/\u001f\u0013eK\u001a\fW\u000f\u001c;%cU\u0011\u0011q\u001b\u0016\u0005\u0003\u0007\tIn\u000b\u0002\u0002\\B!\u0011Q\\At\u001b\t\tyN\u0003\u0003\u0002b\u0006\r\u0018!C;oG\",7m[3e\u0015\r\t)OT\u0001\u000bC:tw\u000e^1uS>t\u0017\u0002BAu\u0003?\u0014\u0011#\u001e8dQ\u0016\u001c7.\u001a3WCJL\u0017M\\2f\u00039\u0019w\u000e]=%I\u00164\u0017-\u001e7uII*\"!a<+\t\u0005%\u0014\u0011\\\u0001\u000fG>\u0004\u0018\u0010\n3fM\u0006,H\u000e\u001e\u00134+\t\t)P\u000b\u0003\u0002~\u0005e\u0017AD2paf$C-\u001a4bk2$H\u0005N\u000b\u0003\u0003wTC!!#\u0002Z\u0006q1m\u001c9zI\u0011,g-Y;mi\u0012*TC\u0001B\u0001U\u0011\ti*!7\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\u00119\u0001\u0005\u0003\u0003\n\t=QB\u0001B\u0006\u0015\r\u0011iA\\\u0001\u0005Y\u0006tw-\u0003\u0003\u0002&\t-\u0011\u0001\u00049s_\u0012,8\r^!sSRLX#A/\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\u0004B\u0010!\ri%1D\u0005\u0004\u0005;q%aA!os\"A!\u0011E\u001d\u0002\u0002\u0003\u0007Q,A\u0002yIE\nq\u0002\u001d:pIV\u001cG/\u0013;fe\u0006$xN]\u000b\u0003\u0005O\u0001b!!)\u0003*\te\u0011\u0002\u0002B\u0016\u0003\u0017\u0011\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!\u0011\u0007B\u001c!\ri%1G\u0005\u0004\u0005kq%a\u0002\"p_2,\u0017M\u001c\u0005\n\u0005CY\u0014\u0011!a\u0001\u00053\t\u0001\u0002[1tQ\u000e{G-\u001a\u000b\u0002;\u0006AAo\\*ue&tw\r\u0006\u0002\u0003\b\u00051Q-];bYN$BA!\r\u0003F!I!\u0011\u0005 \u0002\u0002\u0003\u0007!\u0011D\u0001\u0015[\u0016$\u0018\rZ1uCNs\u0017\r]:i_R|F%Z9\u0015\t\t-#\u0011\u000b\t\u0004\u001b\n5\u0013b\u0001B(\u001d\n!QK\\5u\u0011!\u0011\tCBA\u0001\u0002\u0004)\u0018!E7fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8uA!\u001aqAa\u0016\u0011\u00075\u0013I&C\u0002\u0003\\9\u0013\u0001B^8mCRLG.Z\u0001\u0012gR\fG/Z\"iC:<W\rT8hO\u0016\u0014XC\u0001B1!\u0011\u0011\u0019G!\u001b\u000e\u0005\t\u0015$b\u0001B4\u0011\u0006Q1m\u001c8ue>dG.\u001a:\n\t\t-$Q\r\u0002\u0012'R\fG/Z\"iC:<W\rT8hO\u0016\u0014\u0018AE:uCR,7\t[1oO\u0016dunZ4fe\u0002\n\u0001$\\1zE\u00164\u0015\u000e\u001c;fe\u0006c\u0017N^3SKBd\u0017nY1t))\u0011\u0019H!!\u0003\u0006\n%%Q\u0012\t\u0007\u0005k\u00129Ha\u001f\u000e\u00031L1A!\u001fm\u0005\u0011a\u0015n\u001d;\u0011\t\t%!QP\u0005\u0005\u0005\u007f\u0012YAA\u0004J]R,w-\u001a:\t\r\t\r%\u00021\u0001v\u0003!\u0019h.\u00199tQ>$\bb\u0002BD\u0015\u0001\u0007!1O\u0001\bEJ|7.\u001a:t\u0011\u001d\u0011YI\u0003a\u0001\u0003K\u000bA\u0002\\5ti\u0016tWM\u001d(b[\u0016DqAa$\u000b\u0001\u0004\u0011\t$\u0001\u000egS2$XM]+oCZ\f\u0017\u000e\\1cY\u0016,e\u000e\u001a9pS:$8/\u0001\u000bhKR\u0004\u0016M\u001d;ji&|g.T3uC\u0012\fG/\u0019\u000b\r\u0005+\u00139L!/\u0003>\n}&1\u0019\t\u0006\u001b\u0006}$q\u0013\t\u0007\u00053\u0013\u0019K!+\u000f\t\tm%q\u0014\b\u0005\u00033\u0011i*C\u0001P\u0013\r\u0011\tKT\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\u0011)Ka*\u0003\u0011%#XM]1cY\u0016T1A!)O!\u0011\u0011YK!-\u000f\t\u0005M\"QV\u0005\u0005\u0005_\u000bY&\u0001\u000bNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tK\u0012\u000bG/Y\u0005\u0005\u0005g\u0013)LA\rNKR\fG-\u0019;b%\u0016\u001c\bo\u001c8tKB\u000b'\u000f^5uS>t'\u0002\u0002BX\u00037BaAa!\f\u0001\u0004)\bb\u0002B^\u0017\u0001\u0007\u00111C\u0001\u0006i>\u0004\u0018n\u0019\u0005\b\u0005\u0017[\u0001\u0019AAS\u0011\u001d\u0011\tm\u0003a\u0001\u0005c\t\u0011$\u001a:s_J,f.\u0019<bS2\f'\r\\3F]\u0012\u0004x.\u001b8ug\"9!QY\u0006A\u0002\tE\u0012!G3se>\u0014XK\\1wC&d\u0017M\u00197f\u0019&\u001cH/\u001a8feN\f\u0001\u0003[1t\u00032Lg/Z#oIB|\u0017N\u001c;\u0015\u0011\tE\"1\u001aBg\u0005\u001fDaAa!\r\u0001\u0004)\b\"\u0002/\r\u0001\u0004i\u0006b\u0002BF\u0019\u0001\u0007\u0011QU\u0001\u0011O\u0016$\u0018\t\\5wK\u0016sG\r]8j]R$\u0002B!6\u0003X\ne'1\u001c\t\u0006\u001b\u0006}\u0014\u0011\u0017\u0005\u0007\u0005\u0007k\u0001\u0019A;\t\u000bqk\u0001\u0019A/\t\u000f\t-U\u00021\u0001\u0002&\u0006\u0001r-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u000b\u000b\u0005C\u0014iOa>\u0003z\nm\bCBAQ\u0005G\u00149/\u0003\u0003\u0003f\u0006-!aA*fcB!!1\u0016Bu\u0013\u0011\u0011YO!.\u0003+5+G/\u00193bi\u0006\u0014Vm\u001d9p]N,Gk\u001c9jG\"9!q\u001e\bA\u0002\tE\u0018A\u0002;pa&\u001c7\u000f\u0005\u0004\u0002\"\nM\u00181C\u0005\u0005\u0005k\fYAA\u0002TKRDqAa#\u000f\u0001\u0004\t)\u000bC\u0005\u0003B:\u0001\n\u00111\u0001\u00032!I!Q\u0019\b\u0011\u0002\u0003\u0007!\u0011G\u0001\u001bO\u0016$Hk\u001c9jG6+G/\u00193bi\u0006$C-\u001a4bk2$HeM\u000b\u0003\u0007\u0003QCA!\r\u0002Z\u0006Qr-\u001a;U_BL7-T3uC\u0012\fG/\u0019\u0013eK\u001a\fW\u000f\u001c;%i\u0005aq-\u001a;BY2$v\u000e]5dgR\u0011!\u0011_\u0001\u0013O\u0016$Hk\u001c9jGB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0004\u000e\rU\u0001CBAQ\u0005g\u001cy\u0001\u0005\u0003\u0002r\rE\u0011\u0002BB\n\u0003+\u0012a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g\u000eC\u0004\u0004\u0018I\u0001\r!a\u0005\u0002\u0013Q|\u0007/[2OC6,G\u0003\u0002By\u00077AaAa!\u0014\u0001\u0004)\u0018\u0001E4fi\u0006cG\u000eU1si&$\u0018n\u001c8t)\u0011\u0019\tca\t\u0011\u0011\u0005U\u00111NB\b\u0003_AaAa!\u0015\u0001\u0004)\u0018\u0001F4fi:{g.\u0012=jgRLgn\u001a+pa&\u001c7\u000f\u0006\u0003\u0003r\u000e%\u0002b\u0002Bx+\u0001\u0007!\u0011_\u0001\u000fQ\u0006\u001c\u0018\t\\5wK\n\u0013xn[3s)\u0011\u0011\tda\f\t\u000bq3\u0002\u0019A/\u0002\u001f\u001d,G/\u00117jm\u0016\u0014%o\\6feN$\"a!\u000e\u0011\r\te%1UB\u001c!\u0011\u0019Ida\u0010\u000e\u0005\rm\"bAB\u001f\u0011\u0006)\u0011\rZ7j]&!1\u0011IB\u001e\u00059\u0011%o\\6fe6+G/\u00193bi\u0006\f!cZ3u\u00032Lg/\u001a\"s_.,'OT8eKR1!Q[B$\u0007\u0013BQ\u0001\u0018\rA\u0002uCqAa#\u0019\u0001\u0004\t)+A\nhKR\fE.\u001b<f\u0005J|7.\u001a:O_\u0012,7\u000f\u0006\u0003\u0004P\rE\u0003C\u0002BM\u0005G\u000b\t\fC\u0004\u0003\ff\u0001\r!!*\u00021\u0005$Gm\u0014:Va\u0012\fG/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0006\u0003L\r]3\u0011LB.\u0007?Baa \u000eA\u0002\u0005\r\u0001b\u0002B^5\u0001\u0007\u00111\u0003\u0005\u0007\u0007;R\u0002\u0019A/\u0002\u0017A\f'\u000f^5uS>t\u0017\n\u001a\u0005\b\u0007CR\u0002\u0019AA\u0018\u0003%\u0019H/\u0019;f\u0013:4w.\u0001\thKR\u0004\u0016M\u001d;ji&|g.\u00138g_R11qMB5\u0007W\u0002R!TA@\u0003_AqAa/\u001c\u0001\u0004\t\u0019\u0002\u0003\u0004\u0004^m\u0001\r!X\u0001\u000e]Vl\u0007+\u0019:uSRLwN\\:\u0015\t\u0005u4\u0011\u000f\u0005\b\u0005wc\u0002\u0019AA\n\u0003i9W\r\u001e)beRLG/[8o\u0019\u0016\fG-\u001a:F]\u0012\u0004x.\u001b8u)!\u0011)na\u001e\u0004z\rm\u0004b\u0002B^;\u0001\u0007\u00111\u0003\u0005\u0007\u0007;j\u0002\u0019A/\t\u000f\t-U\u00041\u0001\u0002&\u0006ar-\u001a;QCJ$\u0018\u000e^5p]J+\u0007\u000f\\5dC\u0016sG\r]8j]R\u001cHCBBA\u0007\u0007\u001b9\tE\u0004\u0002\u0016\u0005-T,!-\t\u000f\r\u0015e\u00041\u0001\u0004\u0010\u0005\u0011A\u000f\u001d\u0005\b\u0005\u0017s\u0002\u0019AAS\u0003=9W\r^\"p]R\u0014x\u000e\u001c7fe&#\u0017AE4fi\u000ecWo\u001d;fe6+G/\u00193bi\u0006$baa$\u0004\u0016\u000ee\u0005\u0003BA9\u0007#KAaa%\u0002V\t91\t\\;ti\u0016\u0014\bbBBLA\u0001\u0007\u00111C\u0001\nG2,8\u000f^3s\u0013\u0012DqAa#!\u0001\u0004\t)+\u0001\bva\u0012\fG/Z'fi\u0006$\u0017\r^1\u0015\r\r}5\u0011UBS!\u0019\t\tKa9\u0004\u0010!111U\u0011A\u0002u\u000bQbY8se\u0016d\u0017\r^5p]&#\u0007bBBTC\u0001\u00071\u0011V\u0001\u0016kB$\u0017\r^3NKR\fG-\u0019;b%\u0016\fX/Z:u!\u0011\u0019Yk!-\u000e\u0005\r5&\u0002BBX\u0003+\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0007g\u001biKA\u000bVa\u0012\fG/Z'fi\u0006$\u0017\r^1SKF,Xm\u001d;\u0002\u0011\r|g\u000e^1j]N$BA!\r\u0004:\"9!1\u0018\u0012A\u0002\u0005MA\u0003\u0002B\u0019\u0007{Cqa!\"$\u0001\u0004\u0019y!A\nsK6|g/\u001a)beRLG/[8o\u0013:4w\u000e\u0006\u0006\u00032\r\r7QYBf\u0007\u001bDaa \u0013A\u0002\u0005\r\u0001bBA3I\u0001\u00071q\u0019\t\t\u0003\u000b\u0019I-a\u0005\u0002p%!\u0011QNA\u0004\u0011\u001d\u0011Y\f\na\u0001\u0003'Aaa!\u0018%\u0001\u0004i\u0016\u0001E'fi\u0006$\u0017\r^1T]\u0006\u00048\u000f[8u!\t1\bi\u0005\u0003A\u0007+d\bcDBl\u0007;\f\u0019!!\u001b\u0002~\u0005%\u0015QT;\u000e\u0005\re'bABn\u001d\u00069!/\u001e8uS6,\u0017\u0002BBp\u00073\u0014\u0011#\u00112tiJ\f7\r\u001e$v]\u000e$\u0018n\u001c86)\t\u0019\t.A\u0003baBd\u0017\u0010F\u0006v\u0007O\u001cIoa;\u0004n\u000e=\bBB@D\u0001\u0004\t\u0019\u0001C\u0004\u0002f\r\u0003\r!!\u001b\t\u000f\u0005e4\t1\u0001\u0002~!9\u0011QQ\"A\u0002\u0005%\u0005bBAM\u0007\u0002\u0007\u0011QT\u0001\bk:\f\u0007\u000f\u001d7z)\u0011\u0019)p!@\u0011\u000b5\u000byha>\u0011\u001b5\u001bI0a\u0001\u0002j\u0005u\u0014\u0011RAO\u0013\r\u0019YP\u0014\u0002\u0007)V\u0004H.Z\u001b\t\u0011\r}H)!AA\u0002U\f1\u0001\u001f\u00131\u0001")
public class ZkMetadataCache
implements MetadataCache,
Logging {
    private volatile ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot$module;
    private final int brokerId;
    private final ReentrantReadWriteLock partitionMetadataLock;
    private volatile MetadataSnapshot metadataSnapshot;
    private final StateChangeLogger stateChangeLogger;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    public ZkMetadataCache$MetadataSnapshot$ MetadataSnapshot() {
        if (this.MetadataSnapshot$module == null) {
            this.MetadataSnapshot$lzycompute$1();
        }
        return this.MetadataSnapshot$module;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private ReentrantReadWriteLock partitionMetadataLock() {
        return this.partitionMetadataLock;
    }

    private MetadataSnapshot metadataSnapshot() {
        return this.metadataSnapshot;
    }

    private void metadataSnapshot_$eq(MetadataSnapshot x$1) {
        this.metadataSnapshot = x$1;
    }

    private StateChangeLogger stateChangeLogger() {
        return this.stateChangeLogger;
    }

    private List<Integer> maybeFilterAliveReplicas(MetadataSnapshot snapshot, List<Integer> brokers, ListenerName listenerName, boolean filterUnavailableEndpoints) {
        if (!filterUnavailableEndpoints) {
            return brokers;
        }
        ArrayList<Integer> res = new ArrayList<Integer>(scala.math.package$.MODULE$.min(snapshot.aliveBrokers().size(), brokers.size()));
        ((IterableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(brokers).asScala()).foreach((Function1 & Serializable & scala.Serializable)brokerId -> {
            if (this.hasAliveEndpoint(snapshot, Predef$.MODULE$.Integer2int(brokerId), listenerName)) {
                return BoxesRunTime.boxToBoolean((boolean)res.add((Integer)brokerId));
            }
            return BoxedUnit.UNIT;
        });
        return res;
    }

    private Option<Iterable<MetadataResponseData.MetadataResponsePartition>> getPartitionMetadata(MetadataSnapshot snapshot, String topic, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        return snapshot.partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)partitions -> (Iterable)partitions.map((Function1 & Serializable & scala.Serializable)x0$1 -> {
            Errors errors;
            if (x0$1 == null) throw new MatchError(null);
            long partitionId = x0$1._1$mcJ$sp();
            UpdateMetadataRequestData.UpdateMetadataPartitionState partitionState = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$1._2();
            TopicPartition topicPartition = new TopicPartition(topic, (int)partitionId);
            int leaderBrokerId = partitionState.leader();
            int leaderEpoch = partitionState.leaderEpoch();
            Option<Node> maybeLeader = this.getAliveEndpoint(snapshot, leaderBrokerId, listenerName);
            List replicas = partitionState.replicas();
            List<Integer> filteredReplicas = this.maybeFilterAliveReplicas(snapshot, replicas, listenerName, errorUnavailableEndpoints);
            List isr = partitionState.isr();
            List<Integer> filteredIsr = this.maybeFilterAliveReplicas(snapshot, isr, listenerName, errorUnavailableEndpoints);
            List offlineReplicas = partitionState.offlineReplicas();
            if (None$.MODULE$.equals(maybeLeader)) {
                Errors errors2;
                if (!snapshot.aliveBrokers().contains((long)leaderBrokerId)) {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while fetching metadata for ").append(topicPartition).append(": leader not available").toString());
                    errors2 = Errors.LEADER_NOT_AVAILABLE;
                } else {
                    this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Error while fetching metadata for ").append(topicPartition).append(": listener ").append(listenerName).append(" ").append("not found on leader ").append(leaderBrokerId).toString());
                    errors2 = errorUnavailableListeners ? Errors.LISTENER_NOT_FOUND : Errors.LEADER_NOT_AVAILABLE;
                }
                Errors error = errors2;
                return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(-1).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
            }
            if (!(maybeLeader instanceof Some)) throw new MatchError(maybeLeader);
            if (filteredReplicas.size() < replicas.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(92).append("Error while fetching metadata for ").append(topicPartition).append(": replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicas).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredReplicas.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else if (filteredIsr.size() < isr.size()) {
                this.debug((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(100).append("Error while fetching metadata for ").append(topicPartition).append(": in sync replica information not available for ").append("following brokers ").append(((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(isr).asScala()).filterNot((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)filteredIsr.contains(x$1)))).mkString(",")).toString());
                errors = Errors.REPLICA_NOT_AVAILABLE;
            } else {
                errors = Errors.NONE;
            }
            Errors error = errors;
            return new MetadataResponseData.MetadataResponsePartition().setErrorCode(error.code()).setPartitionIndex((int)partitionId).setLeaderId(BoxesRunTime.unboxToInt((Object)maybeLeader.map((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToInteger((int)x$1.id())).getOrElse((Function0)(JFunction0.mcI.sp & Serializable & scala.Serializable)() -> -1))).setLeaderEpoch(leaderEpoch).setReplicaNodes(filteredReplicas).setIsrNodes(filteredIsr).setOfflineReplicas(offlineReplicas);
        }, scala.collection.mutable.Iterable$.MODULE$.canBuildFrom()));
    }

    private boolean hasAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).exists((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.contains((Object)listenerName)));
    }

    private Option<Node> getAliveEndpoint(MetadataSnapshot snapshot, int brokerId, ListenerName listenerName) {
        return snapshot.aliveNodes().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$3 -> x$3.get((Object)listenerName));
    }

    @Override
    public Seq<MetadataResponseData.MetadataResponseTopic> getTopicMetadata(Set<String> topics, ListenerName listenerName, boolean errorUnavailableEndpoints, boolean errorUnavailableListeners) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (Seq)topics.toSeq().flatMap((Function1 & Serializable & scala.Serializable)topic -> Option$.MODULE$.option2Iterable(this.getPartitionMetadata(snapshot, (String)topic, listenerName, errorUnavailableEndpoints, errorUnavailableListeners).map((Function1 & Serializable & scala.Serializable)partitionMetadata -> new MetadataResponseData.MetadataResponseTopic().setErrorCode(Errors.NONE.code()).setName(topic).setTopicId((Uuid)snapshot.topicIds().getOrElse(topic, (Function0 & Serializable & scala.Serializable)() -> Uuid.ZERO_UUID)).setIsInternal(Topic.isInternal((String)topic)).setPartitions((List)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitionMetadata.toBuffer()).asJava()))), Seq$.MODULE$.canBuildFrom());
    }

    @Override
    public boolean getTopicMetadata$default$3() {
        return false;
    }

    @Override
    public boolean getTopicMetadata$default$4() {
        return false;
    }

    @Override
    public Set<String> getAllTopics() {
        return this.getAllTopics(this.metadataSnapshot());
    }

    @Override
    public Set<TopicPartition> getTopicPartitions(String topicName) {
        return ((TraversableOnce)((MapLike)this.metadataSnapshot().partitionStates().getOrElse((Object)topicName, (Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty())).values().map((Function1 & Serializable & scala.Serializable)p -> new TopicPartition(topicName, p.partitionIndex()), scala.collection.Iterable$.MODULE$.canBuildFrom())).toSet();
    }

    private Set<String> getAllTopics(MetadataSnapshot snapshot) {
        return snapshot.partitionStates().keySet();
    }

    private scala.collection.immutable.Map<TopicPartition, UpdateMetadataRequestData.UpdateMetadataPartitionState> getAllPartitions(MetadataSnapshot snapshot) {
        return ((TraversableOnce)snapshot.partitionStates().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            String topic = (String)x0$1._1();
            scala.collection.mutable.Map map = (scala.collection.mutable.Map)((LongMap)x0$1._2()).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                if (x0$2 == null) {
                    throw new MatchError(null);
                }
                long partition = x0$2._1$mcJ$sp();
                UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2();
                Tuple2 tuple2 = new Tuple2((Object)new TopicPartition(topic, (int)partition), (Object)state);
                return tuple2;
            }, Map$.MODULE$.canBuildFrom());
            return map;
        }, AnyRefMap$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Set<String> getNonExistingTopics(Set<String> topics) {
        return topics.diff((GenSet)this.metadataSnapshot().partitionStates().keySet());
    }

    @Override
    public boolean hasAliveBroker(int brokerId) {
        return this.metadataSnapshot().aliveBrokers().contains((long)brokerId);
    }

    @Override
    public Iterable<BrokerMetadata> getAliveBrokers() {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().map((Function1 & Serializable & scala.Serializable)b -> new BrokerMetadata(b.id(), b.rack()), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    @Override
    public Option<Node> getAliveBrokerNode(int brokerId, ListenerName listenerName) {
        return this.metadataSnapshot().aliveBrokers().get((long)brokerId).flatMap((Function1 & Serializable & scala.Serializable)x$4 -> x$4.getNode(listenerName));
    }

    @Override
    public Iterable<Node> getAliveBrokerNodes(ListenerName listenerName) {
        return (Iterable)this.metadataSnapshot().aliveBrokers().values().flatMap((Function1 & Serializable & scala.Serializable)x$5 -> Option$.MODULE$.option2Iterable(x$5.getNode(listenerName)), scala.collection.Iterable$.MODULE$.canBuildFrom());
    }

    private void addOrUpdatePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, String topic, int partitionId, UpdateMetadataRequestData.UpdateMetadataPartitionState stateInfo) {
        ((LongMap)partitionStates.getOrElseUpdate((Object)topic, (Function0 & Serializable & scala.Serializable)() -> LongMap$.MODULE$.empty())).update((long)partitionId, (Object)stateInfo);
    }

    @Override
    public Option<UpdateMetadataRequestData.UpdateMetadataPartitionState> getPartitionInfo(String topic, int partitionId) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$6 -> x$6.get((long)partitionId));
    }

    @Override
    public Option<Object> numPartitions(String topic) {
        return this.metadataSnapshot().partitionStates().get((Object)topic).map((Function1 & Serializable & scala.Serializable)x$7 -> BoxesRunTime.boxToInteger((int)x$7.size()));
    }

    @Override
    public Option<Node> getPartitionLeaderEndpoint(String topic, int partitionId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return snapshot.partitionStates().get((Object)topic).flatMap((Function1 & Serializable & scala.Serializable)x$8 -> x$8.get((long)partitionId)).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            Node node;
            int leaderId = partitionInfo.leader();
            Option option = snapshot.aliveNodes().get((long)leaderId);
            if (option instanceof Some) {
                node = (Node)((Map)((Some)option).value()).getOrElse((Object)listenerName, (Function0 & Serializable & scala.Serializable)() -> Node.noNode());
            } else if (None$.MODULE$.equals(option)) {
                node = Node.noNode();
            } else {
                throw new MatchError((Object)option);
            }
            return node;
        });
    }

    @Override
    public scala.collection.immutable.Map<Object, Node> getPartitionReplicaEndpoints(TopicPartition tp, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        return (scala.collection.immutable.Map)snapshot.partitionStates().get((Object)tp.topic()).flatMap((Function1 & Serializable & scala.Serializable)x$9 -> x$9.get((long)tp.partition())).map((Function1 & Serializable & scala.Serializable)partitionInfo -> {
            List replicaIds = partitionInfo.replicas();
            return (scala.collection.immutable.Map)((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(replicaIds).asScala()).map((Function1 & Serializable & scala.Serializable)replicaId -> {
                Node node;
                Object object = Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToInteger((int)replicaId));
                Option option = snapshot.aliveBrokers().get(replicaId.longValue());
                if (option instanceof Some) {
                    node = (Node)((Broker)((Some)option).value()).getNode(listenerName).getOrElse((Function0 & Serializable & scala.Serializable)() -> Node.noNode());
                } else if (None$.MODULE$.equals(option)) {
                    node = Node.noNode();
                } else {
                    throw new MatchError((Object)option);
                }
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(object, (Object)node);
            }, Buffer$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms()).filter((Function1 & Serializable & scala.Serializable)pair -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getPartitionReplicaEndpoints$5(pair)));
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> Predef$.MODULE$.Map().empty());
    }

    @Override
    public Option<Object> getControllerId() {
        return this.metadataSnapshot().controllerId();
    }

    @Override
    public Cluster getClusterMetadata(String clusterId, ListenerName listenerName) {
        MetadataSnapshot snapshot = this.metadataSnapshot();
        LongMap nodes = (LongMap)snapshot.aliveNodes().flatMap((Function1 & Serializable & scala.Serializable)x0$1 -> {
            if (x0$1 == null) {
                throw new MatchError(null);
            }
            long id = x0$1._1$mcJ$sp();
            Map nodesByListener = (Map)x0$1._2();
            Iterable iterable = Option$.MODULE$.option2Iterable(nodesByListener.get((Object)listenerName).map((Function1 & Serializable & scala.Serializable)node -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)BoxesRunTime.boxToLong((long)id)), node)));
            return iterable;
        }, LongMap$.MODULE$.canBuildFrom());
        scala.collection.immutable.Iterable partitions = (scala.collection.immutable.Iterable)((TraversableLike)this.getAllPartitions(snapshot).filter((Function1 & Serializable & scala.Serializable)x0$2 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$4(x0$2)))).map((Function1 & Serializable & scala.Serializable)x0$3 -> {
            if (x0$3 == null) {
                throw new MatchError(null);
            }
            TopicPartition tp = (TopicPartition)x0$3._1();
            UpdateMetadataRequestData.UpdateMetadataPartitionState state = (UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$3._2();
            PartitionInfo partitionInfo = new PartitionInfo(tp.topic(), tp.partition(), ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(state.leader()), nodes), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.replicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.isr()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)), (Node[])((TraversableOnce)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(state.offlineReplicas()).asScala()).map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(id, nodes), Buffer$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.apply(Node.class)));
            return partitionInfo;
        }, Iterable$.MODULE$.canBuildFrom());
        java.util.Set unauthorizedTopics = Collections.emptySet();
        java.util.Set internalTopics = (java.util.Set)CollectionConverters$.MODULE$.setAsJavaSetConverter((Set)this.getAllTopics(snapshot).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$getClusterMetadata$9(x$1)))).asJava();
        return new Cluster(clusterId, (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(nodes.values().toBuffer()).asJava(), (Collection)CollectionConverters$.MODULE$.bufferAsJavaListConverter(partitions.toBuffer()).asJava(), unauthorizedTopics, internalTopics, (Node)snapshot.controllerId().map((Function1 & Serializable & scala.Serializable)id -> ZkMetadataCache.node$1(Predef$.MODULE$.int2Integer(BoxesRunTime.unboxToInt((Object)id)), nodes)).orNull(Predef$.MODULE$.$conforms()));
    }

    /*
     * WARNING - void declaration
     */
    public Seq<TopicPartition> updateMetadata(int correlationId, UpdateMetadataRequest updateMetadataRequest) {
        ArrayBuffer arrayBuffer;
        void inWriteLock_lock;
        ReentrantReadWriteLock reentrantReadWriteLock = this.partitionMetadataLock();
        if (CoreUtils$.MODULE$ == null) {
            throw null;
        }
        Lock inWriteLock_inLock_lock = inWriteLock_lock.writeLock();
        inWriteLock_inLock_lock.lock();
        try {
            arrayBuffer = ZkMetadataCache.$anonfun$updateMetadata$1(this, updateMetadataRequest, correlationId);
        }
        finally {
            inWriteLock_inLock_lock.unlock();
        }
        return arrayBuffer;
    }

    @Override
    public boolean contains(String topic) {
        return this.metadataSnapshot().partitionStates().contains((Object)topic);
    }

    @Override
    public boolean contains(TopicPartition tp) {
        return this.getPartitionInfo(tp.topic(), tp.partition()).isDefined();
    }

    private boolean removePartitionInfo(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.mutable.Map<String, Uuid> topicIds, String topic, int partitionId) {
        return partitionStates.get((Object)topic).exists((Function1 & Serializable & scala.Serializable)infos -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$removePartitionInfo$1(partitionId, partitionStates, topic, topicIds, infos)));
    }

    private final void MetadataSnapshot$lzycompute$1() {
        synchronized (this) {
            if (this.MetadataSnapshot$module == null) {
                this.MetadataSnapshot$module = new ZkMetadataCache$MetadataSnapshot$(this);
            }
            return;
        }
    }

    public static final /* synthetic */ boolean $anonfun$getPartitionReplicaEndpoints$5(Tuple2 pair) {
        if (pair == null) {
            throw new MatchError(null);
        }
        boolean bl = !((Node)pair._2()).isEmpty();
        return bl;
    }

    private static final Node node$1(Integer id, LongMap nodes$1) {
        return (Node)nodes$1.getOrElse((long)Predef$.MODULE$.Integer2int(id), (Function0 & Serializable & scala.Serializable)() -> new Node(Predef$.MODULE$.Integer2int(id), "", -1));
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$4(Tuple2 x0$2) {
        if (x0$2 == null) {
            throw new MatchError(null);
        }
        boolean bl = ((UpdateMetadataRequestData.UpdateMetadataPartitionState)x0$2._2()).leader() != LeaderAndIsr$.MODULE$.LeaderDuringDelete();
        return bl;
    }

    public static final /* synthetic */ boolean $anonfun$getClusterMetadata$9(String x$1) {
        return Topic.isInternal((String)x$1);
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$5(Set listeners$1, Map x$10) {
        Set set = x$10.keySet();
        return !(set != null ? !set.equals(listeners$1) : listeners$1 != null);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$4(ZkMetadataCache $this, LongMap aliveNodes$1, Map listenerMap) {
        Set listeners = listenerMap.keySet();
        if (!aliveNodes$1.values().forall((Function1 & Serializable & scala.Serializable)x$10 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$5(listeners, x$10)))) {
            $this.error((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(44).append("Listeners are not identical across brokers: ").append(aliveNodes$1).toString());
        }
    }

    public static final /* synthetic */ boolean $anonfun$updateMetadata$8(Tuple2 x$11) {
        Object object = x$11._2();
        Uuid uuid = Uuid.ZERO_UUID;
        return object == null ? uuid != null : !object.equals(uuid);
    }

    public static final /* synthetic */ void $anonfun$updateMetadata$9(AnyRefMap partitionStates$1, String topic, LongMap oldPartitionStates) {
        LongMap copy = new LongMap(oldPartitionStates.size());
        copy.$plus$plus$eq((TraversableOnce)oldPartitionStates);
        partitionStates$1.update((Object)topic, (Object)copy);
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ ArrayBuffer $anonfun$updateMetadata$1(ZkMetadataCache $this, UpdateMetadataRequest updateMetadataRequest$1, int correlationId$1) {
        LongMap aliveBrokers = new LongMap($this.metadataSnapshot().aliveBrokers().size());
        LongMap aliveNodes = new LongMap($this.metadataSnapshot().aliveNodes().size());
        int n = updateMetadataRequest$1.controllerId();
        switch (n) {
            default: 
        }
        None$ controllerIdOpt = n < 0 ? None$.MODULE$ : new Some((Object)BoxesRunTime.boxToInteger((int)n));
        updateMetadataRequest$1.liveBrokers().forEach(broker -> {
            HashMap nodes = new HashMap();
            ArrayBuffer endPoints = new ArrayBuffer();
            broker.endpoints().forEach(ep -> {
                ListenerName listenerName = new ListenerName(ep.listener());
                endPoints.$plus$eq((Object)new EndPoint(ep.host(), ep.port(), listenerName, SecurityProtocol.forId((short)ep.securityProtocol())));
                nodes.put(listenerName, new Node(broker.id(), ep.host(), ep.port()));
            });
            aliveBrokers.update((long)broker.id(), (Object)Broker$.MODULE$.apply(broker.id(), (Seq<EndPoint>)endPoints, (Option<String>)Option$.MODULE$.apply((Object)broker.rack())));
            aliveNodes.update((long)broker.id(), CollectionConverters$.MODULE$.mapAsScalaMapConverter(nodes).asScala());
        });
        aliveNodes.get((long)$this.brokerId).foreach((Function1 & Serializable & scala.Serializable)listenerMap -> {
            ZkMetadataCache.$anonfun$updateMetadata$4($this, aliveNodes, listenerMap);
            return BoxedUnit.UNIT;
        });
        scala.collection.immutable.Map newTopicIds = ((TraversableOnce)((TraversableLike)((TraversableLike)CollectionConverters$.MODULE$.asScalaBufferConverter(updateMetadataRequest$1.topicStates()).asScala()).map((Function1 & Serializable & scala.Serializable)topicState -> new Tuple2((Object)topicState.topicName(), (Object)topicState.topicId()), Buffer$.MODULE$.canBuildFrom())).filter((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ZkMetadataCache.$anonfun$updateMetadata$8(x$11)))).toMap(Predef$.MODULE$.$conforms());
        scala.collection.mutable.Map topicIds = Map$.MODULE$.empty();
        topicIds.$plus$plus$eq($this.metadataSnapshot().topicIds());
        topicIds.$plus$plus$eq((TraversableOnce)newTopicIds);
        ArrayBuffer deletedPartitions = new ArrayBuffer();
        if (!updateMetadataRequest$1.partitionStates().iterator().hasNext()) {
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, $this.metadataSnapshot().partitionStates(), (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        } else {
            void forKeyValue$extension_f;
            void forKeyValue$extension_$this;
            AnyRefMap partitionStates = new AnyRefMap($this.metadataSnapshot().partitionStates().size());
            Function2 & Serializable & scala.Serializable intersect = (Function2 & Serializable & scala.Serializable)(topic, oldPartitionStates) -> {
                ZkMetadataCache.$anonfun$updateMetadata$9(partitionStates, topic, oldPartitionStates);
                return BoxedUnit.UNIT;
            };
            Map<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> map = Implicits$.MODULE$.MapExtensionMethods($this.metadataSnapshot().partitionStates());
            if (Implicits$MapExtensionMethods$.MODULE$ == null) {
                throw null;
            }
            MapExtensionMethods$.MODULE$.foreachEntry$extension(package$.MODULE$.toMapExtensionMethods((Map)forKeyValue$extension_$this), (arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2)forKeyValue$extension_f, arg_0, arg_1));
            boolean traceEnabled = $this.stateChangeLogger().isTraceEnabled();
            int controllerId = updateMetadataRequest$1.controllerId();
            int controllerEpoch = updateMetadataRequest$1.controllerEpoch();
            Iterable newStates = (Iterable)CollectionConverters$.MODULE$.iterableAsScalaIterableConverter(updateMetadataRequest$1.partitionStates()).asScala();
            newStates.foreach((Function1 & Serializable & scala.Serializable)state -> {
                TopicPartition tp = new TopicPartition(state.topicName(), state.partitionIndex());
                if (state.leader() == LeaderAndIsr$.MODULE$.LeaderDuringDelete()) {
                    $this.removePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.mutable.Map<String, Uuid>)topicIds, tp.topic(), tp.partition());
                    if (traceEnabled) {
                        $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(124).append("Deleted partition ").append(tp).append(" from metadata cache in response to UpdateMetadata ").append("request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    }
                    return deletedPartitions.$plus$eq((Object)tp);
                }
                $this.addOrUpdatePartitionInfo((AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, tp.topic(), tp.partition(), (UpdateMetadataRequestData.UpdateMetadataPartitionState)state);
                if (traceEnabled) {
                    $this.stateChangeLogger().trace((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(120).append("Cached leader info ").append(state).append(" for partition ").append(tp).append(" in response to ").append("UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
                    return BoxedUnit.UNIT;
                }
                return BoxedUnit.UNIT;
            });
            int cachedPartitionsCount = newStates.size() - deletedPartitions.size();
            $this.stateChangeLogger().info((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(145).append("Add ").append(cachedPartitionsCount).append(" partitions and deleted ").append(deletedPartitions.size()).append(" partitions from metadata cache ").append("in response to UpdateMetadata request sent by controller ").append(controllerId).append(" epoch ").append(controllerEpoch).append(" with correlation id ").append(correlationId$1).toString());
            $this.metadataSnapshot_$eq(new MetadataSnapshot($this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)partitionStates, (scala.collection.immutable.Map<String, Uuid>)topicIds.toMap(Predef$.MODULE$.$conforms()), (Option<Object>)controllerIdOpt, (LongMap<Broker>)aliveBrokers, (LongMap<Map<ListenerName, Node>>)aliveNodes));
        }
        return deletedPartitions;
    }

    public static final /* synthetic */ boolean $anonfun$removePartitionInfo$1(int partitionId$3, AnyRefMap partitionStates$2, String topic$4, scala.collection.mutable.Map topicIds$2, LongMap infos) {
        infos.remove((Object)BoxesRunTime.boxToLong((long)partitionId$3));
        if (infos.isEmpty()) {
            partitionStates$2.remove((Object)topic$4);
            topicIds$2.remove((Object)topic$4);
        }
        return true;
    }

    public ZkMetadataCache(int brokerId) {
        this.brokerId = brokerId;
        Logging.$init$(this);
        this.partitionMetadataLock = new ReentrantReadWriteLock();
        this.metadataSnapshot = new MetadataSnapshot(this, (AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>>)AnyRefMap$.MODULE$.empty(), (scala.collection.immutable.Map<String, Uuid>)Predef$.MODULE$.Map().empty(), (Option<Object>)None$.MODULE$, (LongMap<Broker>)LongMap$.MODULE$.empty(), (LongMap<Map<ListenerName, Node>>)LongMap$.MODULE$.empty());
        this.logIdent_$eq(new StringBuilder(26).append("[MetadataCache brokerId=").append(brokerId).append("] ").toString());
        this.stateChangeLogger = new StateChangeLogger(brokerId, false, (Option<Object>)None$.MODULE$);
    }

    public class MetadataSnapshot
    implements Product,
    scala.Serializable {
        private final AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates;
        private final scala.collection.immutable.Map<String, Uuid> topicIds;
        private final Option<Object> controllerId;
        private final LongMap<Broker> aliveBrokers;
        private final LongMap<Map<ListenerName, Node>> aliveNodes;
        public final /* synthetic */ ZkMetadataCache $outer;

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates() {
            return this.partitionStates;
        }

        public scala.collection.immutable.Map<String, Uuid> topicIds() {
            return this.topicIds;
        }

        public Option<Object> controllerId() {
            return this.controllerId;
        }

        public LongMap<Broker> aliveBrokers() {
            return this.aliveBrokers;
        }

        public LongMap<Map<ListenerName, Node>> aliveNodes() {
            return this.aliveNodes;
        }

        public MetadataSnapshot copy(AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            return new MetadataSnapshot(this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer(), partitionStates, topicIds, controllerId, aliveBrokers, aliveNodes);
        }

        public AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> copy$default$1() {
            return this.partitionStates();
        }

        public scala.collection.immutable.Map<String, Uuid> copy$default$2() {
            return this.topicIds();
        }

        public Option<Object> copy$default$3() {
            return this.controllerId();
        }

        public LongMap<Broker> copy$default$4() {
            return this.aliveBrokers();
        }

        public LongMap<Map<ListenerName, Node>> copy$default$5() {
            return this.aliveNodes();
        }

        public String productPrefix() {
            return "MetadataSnapshot";
        }

        public int productArity() {
            return 5;
        }

        public Object productElement(int x$1) {
            switch (x$1) {
                case 0: {
                    return this.partitionStates();
                }
                case 1: {
                    return this.topicIds();
                }
                case 2: {
                    return this.controllerId();
                }
                case 3: {
                    return this.aliveBrokers();
                }
                case 4: {
                    return this.aliveNodes();
                }
            }
            throw new IndexOutOfBoundsException(Integer.toString(x$1));
        }

        public Iterator<Object> productIterator() {
            return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
        }

        public boolean canEqual(Object x$1) {
            return x$1 instanceof MetadataSnapshot;
        }

        public int hashCode() {
            return ScalaRunTime$.MODULE$._hashCode((Product)this);
        }

        public String toString() {
            return ScalaRunTime$.MODULE$._toString((Product)this);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean equals(Object x$1) {
            if (this == x$1) return true;
            if (!(x$1 instanceof MetadataSnapshot)) return false;
            if (((MetadataSnapshot)x$1).kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() != this.kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer()) return false;
            boolean bl = true;
            if (!bl) return false;
            MetadataSnapshot metadataSnapshot = (MetadataSnapshot)x$1;
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap = this.partitionStates();
            AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> anyRefMap2 = metadataSnapshot.partitionStates();
            if (anyRefMap == null) {
                if (anyRefMap2 != null) {
                    return false;
                }
            } else if (!anyRefMap.equals(anyRefMap2)) return false;
            scala.collection.immutable.Map<String, Uuid> map = this.topicIds();
            scala.collection.immutable.Map<String, Uuid> map2 = metadataSnapshot.topicIds();
            if (map == null) {
                if (map2 != null) {
                    return false;
                }
            } else if (!map.equals(map2)) return false;
            Option<Object> option = this.controllerId();
            Option<Object> option2 = metadataSnapshot.controllerId();
            if (option == null) {
                if (option2 != null) {
                    return false;
                }
            } else if (!option.equals(option2)) return false;
            LongMap<Broker> longMap = this.aliveBrokers();
            LongMap<Broker> longMap2 = metadataSnapshot.aliveBrokers();
            if (longMap == null) {
                if (longMap2 != null) {
                    return false;
                }
            } else if (!longMap.equals(longMap2)) return false;
            LongMap<Map<ListenerName, Node>> longMap3 = this.aliveNodes();
            LongMap<Map<ListenerName, Node>> longMap4 = metadataSnapshot.aliveNodes();
            if (longMap3 == null) {
                if (longMap4 != null) {
                    return false;
                }
            } else if (!longMap3.equals(longMap4)) return false;
            if (!metadataSnapshot.canEqual(this)) return false;
            return true;
        }

        public /* synthetic */ ZkMetadataCache kafka$server$ZkMetadataCache$MetadataSnapshot$$$outer() {
            return this.$outer;
        }

        public MetadataSnapshot(ZkMetadataCache $outer, AnyRefMap<String, LongMap<UpdateMetadataRequestData.UpdateMetadataPartitionState>> partitionStates, scala.collection.immutable.Map<String, Uuid> topicIds, Option<Object> controllerId, LongMap<Broker> aliveBrokers, LongMap<Map<ListenerName, Node>> aliveNodes) {
            this.partitionStates = partitionStates;
            this.topicIds = topicIds;
            this.controllerId = controllerId;
            this.aliveBrokers = aliveBrokers;
            this.aliveNodes = aliveNodes;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            Product.$init$((Product)this);
        }
    }
}

