/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.tooling.tracker;

import java.io.File;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import org.apache.karaf.shell.api.action.lifecycle.Service;
import org.apache.karaf.util.tracker.annotation.Managed;
import org.apache.karaf.util.tracker.annotation.ProvideService;
import org.apache.karaf.util.tracker.annotation.RequireService;
import org.apache.karaf.util.tracker.annotation.Services;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.model.Resource;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.LifecyclePhase;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.plugins.annotations.ResolutionScope;
import org.apache.maven.project.MavenProject;
import org.apache.xbean.finder.ClassFinder;
import org.osgi.framework.BundleActivator;
import org.sonatype.plexus.build.incremental.BuildContext;

@Mojo(name="service-metadata-generate", defaultPhase=LifecyclePhase.PROCESS_CLASSES, requiresDependencyResolution=ResolutionScope.COMPILE_PLUS_RUNTIME, inheritByDefault=false)
public class GenerateServiceMetadata
extends AbstractMojo {
    @Parameter(defaultValue="${project}")
    protected MavenProject project;
    @Parameter(defaultValue="BNDExtension-Bundle-Activator")
    protected String activatorProperty;
    @Parameter(defaultValue="BNDExtension-Require-Capability")
    protected String requirementsProperty;
    @Parameter(defaultValue="BNDExtension-Provide-Capability")
    protected String capabilitiesProperty;
    @Parameter(defaultValue="${project.build.directory}/generated/karaf-tracker")
    protected String outputDirectory;
    @Parameter(defaultValue="project")
    protected String classLoader;
    @Component
    private BuildContext buildContext;

    public void execute() throws MojoExecutionException, MojoFailureException {
        try {
            boolean addSourceDirectory = false;
            StringBuilder requirements = new StringBuilder();
            StringBuilder capabilities = new StringBuilder();
            ClassFinder finder = this.createFinder(this.classLoader);
            List classes = finder.findAnnotatedClasses(Services.class);
            ArrayList<Class> activators = new ArrayList<Class>();
            for (Class clazz : classes) {
                Managed managed;
                URL classUrl = clazz.getClassLoader().getResource(clazz.getName().replace('.', '/') + ".class");
                URL outputDirectoryUrl = new File(this.project.getBuild().getOutputDirectory()).toURI().toURL();
                if (classUrl == null || !classUrl.getPath().startsWith(outputDirectoryUrl.getPath())) {
                    System.out.println("Ignoring " + classUrl);
                    continue;
                }
                if (BundleActivator.class.isAssignableFrom(clazz)) {
                    activators.add(clazz);
                }
                Properties props = new Properties();
                Services services = clazz.getAnnotation(Services.class);
                if (services != null) {
                    for (RequireService requireService : services.requires()) {
                        String fltWithClass = this.combine(requireService.filter(), "(objectClass=" + requireService.value().getName() + ")");
                        this.addServiceReq(requirements, fltWithClass);
                        props.setProperty(requireService.value().getName(), requireService.filter());
                    }
                    for (RequireService requireService : services.provides()) {
                        this.addServiceCap(capabilities, (ProvideService)requireService);
                    }
                }
                if ((managed = clazz.getAnnotation(Managed.class)) != null) {
                    props.setProperty("pid", managed.value());
                }
                File file = new File(this.outputDirectory, "OSGI-INF/karaf-tracker/" + clazz.getName());
                file.getParentFile().mkdirs();
                Throwable throwable = null;
                try (OutputStream os = this.buildContext.newFileOutputStream(file);){
                    props.store(os, null);
                }
                catch (Throwable throwable2) {
                    Throwable throwable3 = throwable2;
                    throw throwable2;
                }
                addSourceDirectory = true;
            }
            if (addSourceDirectory) {
                Resource resource = new Resource();
                resource.setDirectory(this.outputDirectory);
                this.project.addResource(resource);
            }
            this.project.getProperties().setProperty(this.requirementsProperty, requirements.toString());
            this.project.getProperties().setProperty(this.capabilitiesProperty, capabilities.toString());
            if (activators.size() == 1) {
                this.project.getProperties().setProperty(this.activatorProperty, ((Class)activators.get(0)).getName());
            }
            this.project.getProperties().setProperty("BNDExtension-Private-Package", "org.apache.karaf.util.tracker");
            this.project.getProperties().setProperty("BNDPrependExtension-Import-Package", "!org.apache.karaf.util.tracker.annotation");
            List services = finder.findAnnotatedClasses(Service.class);
            TreeSet<String> packages = new TreeSet<String>();
            for (Class clazz : services) {
                packages.add(clazz.getPackage().getName());
            }
            if (!packages.isEmpty()) {
                this.project.getProperties().setProperty("BNDExtension-Karaf-Commands", this.join(packages, ","));
            }
        }
        catch (Exception e) {
            throw new MojoExecutionException("Error building commands help", e);
        }
    }

    private String join(Set<String> packages, String separator) {
        StringBuilder sb = new StringBuilder();
        for (String pkg : packages) {
            if (sb.length() > 0) {
                sb.append(separator);
            }
            sb.append(pkg);
        }
        return sb.toString();
    }

    private void addServiceCap(StringBuilder capabilities, ProvideService cap) {
        if (capabilities.length() > 0) {
            capabilities.append(",");
        }
        capabilities.append("osgi.service;effective:=active;objectClass=").append(cap.value().getName());
    }

    private void addServiceReq(StringBuilder requirements, String fltWithClass) {
        if (requirements.length() > 0) {
            requirements.append(",");
        }
        requirements.append("osgi.service;effective:=active;filter:=\"").append(fltWithClass).append("\"");
    }

    private String combine(String filter1, String filter2) {
        if (filter1 != null && !filter1.isEmpty()) {
            return "(&" + filter2 + filter1 + ")";
        }
        return filter2;
    }

    private ClassFinder createFinder(String classloaderType) throws Exception {
        ClassFinder finder;
        if ("project".equals(classloaderType)) {
            ArrayList<URL> urls = new ArrayList<URL>();
            urls.add(new File(this.project.getBuild().getOutputDirectory()).toURI().toURL());
            for (Artifact artifact : this.project.getArtifacts()) {
                File file = artifact.getFile();
                if (file == null) continue;
                urls.add(file.toURI().toURL());
                System.out.println("classpath: " + file);
            }
            URLClassLoader loader = new URLClassLoader(urls.toArray(new URL[urls.size()]), ((Object)((Object)this)).getClass().getClassLoader());
            finder = new ClassFinder((ClassLoader)loader, urls);
        } else if ("plugin".equals(this.classLoader)) {
            finder = new ClassFinder(((Object)((Object)this)).getClass().getClassLoader());
        } else {
            throw new MojoFailureException("classLoader attribute must be 'project' or 'plugin'");
        }
        return finder;
    }
}

