/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.plugin.surefire;

import java.io.File;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.factory.ArtifactFactory;
import org.apache.maven.artifact.metadata.ArtifactMetadataSource;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.resolver.ArtifactResolutionResult;
import org.apache.maven.artifact.resolver.ArtifactResolver;
import org.apache.maven.artifact.resolver.filter.ArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ExcludesArtifactFilter;
import org.apache.maven.artifact.resolver.filter.ScopeArtifactFilter;
import org.apache.maven.artifact.versioning.ArtifactVersion;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.apache.maven.artifact.versioning.InvalidVersionSpecificationException;
import org.apache.maven.artifact.versioning.VersionRange;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.model.Plugin;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.plugin.descriptor.PluginDescriptor;
import org.apache.maven.plugin.surefire.ClasspathCache;
import org.apache.maven.plugin.surefire.ConfigurableProviderInfo;
import org.apache.maven.plugin.surefire.InPluginVMSurefireStarter;
import org.apache.maven.plugin.surefire.ProviderInfo;
import org.apache.maven.plugin.surefire.ProviderList;
import org.apache.maven.plugin.surefire.StartupReportConfiguration;
import org.apache.maven.plugin.surefire.Summary;
import org.apache.maven.plugin.surefire.SurefireDependencyResolver;
import org.apache.maven.plugin.surefire.SurefireExecutionParameters;
import org.apache.maven.plugin.surefire.SurefireProperties;
import org.apache.maven.plugin.surefire.booterclient.ChecksumCalculator;
import org.apache.maven.plugin.surefire.booterclient.ForkConfiguration;
import org.apache.maven.plugin.surefire.booterclient.ForkStarter;
import org.apache.maven.plugin.surefire.util.DirectoryScanner;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;
import org.apache.maven.shared.artifact.filter.PatternIncludesArtifactFilter;
import org.apache.maven.surefire.booter.ClassLoaderConfiguration;
import org.apache.maven.surefire.booter.Classpath;
import org.apache.maven.surefire.booter.ClasspathConfiguration;
import org.apache.maven.surefire.booter.ProviderConfiguration;
import org.apache.maven.surefire.booter.StartupConfiguration;
import org.apache.maven.surefire.booter.SurefireBooterForkException;
import org.apache.maven.surefire.booter.SurefireExecutionException;
import org.apache.maven.surefire.report.ReporterConfiguration;
import org.apache.maven.surefire.suite.RunResult;
import org.apache.maven.surefire.testset.DirectoryScannerParameters;
import org.apache.maven.surefire.testset.RunOrderParameters;
import org.apache.maven.surefire.testset.TestArtifactInfo;
import org.apache.maven.surefire.testset.TestRequest;
import org.apache.maven.surefire.util.DefaultScanResult;
import org.apache.maven.surefire.util.NestedRuntimeException;
import org.apache.maven.surefire.util.RunOrder;
import org.apache.maven.toolchain.Toolchain;
import org.apache.maven.toolchain.ToolchainManager;
import org.codehaus.plexus.util.FileUtils;
import org.codehaus.plexus.util.StringUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractSurefireMojo
extends AbstractMojo
implements SurefireExecutionParameters {
    @Parameter(defaultValue="${plugin}", readonly=true)
    protected PluginDescriptor pluginDescriptor;
    @Parameter(property="skipTests", defaultValue="false")
    protected boolean skipTests;
    @Parameter(property="maven.test.skip.exec")
    protected boolean skipExec;
    @Parameter(property="maven.test.skip", defaultValue="false")
    protected boolean skip;
    @Component
    protected MavenProject project;
    @Parameter(defaultValue="${basedir}")
    protected File basedir;
    @Parameter(defaultValue="${project.build.testOutputDirectory}")
    protected File testClassesDirectory;
    @Parameter(defaultValue="${project.build.outputDirectory}")
    protected File classesDirectory;
    @Parameter
    protected List<String> classpathDependencyExcludes;
    @Parameter(defaultValue="")
    protected String classpathDependencyScopeExclude;
    @Parameter
    protected List<String> additionalClasspathElements;
    @Parameter(defaultValue="${project.build.testSourceDirectory}", required=true)
    protected File testSourceDirectory;
    @Parameter
    protected List<String> includes;
    @Parameter
    protected List<String> excludes;
    @Parameter(defaultValue="${localRepository}", required=true, readonly=true)
    protected ArtifactRepository localRepository;
    @Parameter
    protected Properties systemProperties;
    @Parameter
    protected Map<String, String> systemPropertyVariables;
    @Parameter
    protected File systemPropertiesFile;
    @Parameter
    protected Properties properties;
    @Parameter(property="plugin.artifactMap", required=true, readonly=true)
    protected Map<String, Artifact> pluginArtifactMap;
    @Parameter(property="project.artifactMap", readonly=true, required=true)
    protected Map<String, Artifact> projectArtifactMap;
    @Parameter(property="surefire.reportNameSuffix", defaultValue="")
    protected String reportNameSuffix;
    @Parameter(property="maven.test.redirectTestOutputToFile", defaultValue="false")
    protected boolean redirectTestOutputToFile;
    @Parameter(property="failIfNoTests")
    protected Boolean failIfNoTests;
    @Parameter(property="forkMode", defaultValue="once")
    protected String forkMode;
    @Parameter(property="jvm")
    protected String jvm;
    @Parameter(property="argLine")
    protected String argLine;
    @Parameter
    protected Map<String, String> environmentVariables = new HashMap<String, String>();
    @Parameter(property="basedir")
    protected File workingDirectory;
    @Parameter(property="childDelegation", defaultValue="false")
    protected boolean childDelegation;
    @Parameter(property="groups")
    protected String groups;
    @Parameter(property="excludedGroups")
    protected String excludedGroups;
    @Parameter
    protected File[] suiteXmlFiles;
    @Parameter(property="junitArtifactName", defaultValue="junit:junit")
    protected String junitArtifactName;
    @Parameter(property="testNGArtifactName", defaultValue="org.testng:testng")
    protected String testNGArtifactName;
    @Parameter(property="threadCount")
    protected int threadCount;
    @Parameter(property="perCoreThreadCount", defaultValue="true")
    protected boolean perCoreThreadCount;
    @Parameter(property="useUnlimitedThreads", defaultValue="false")
    protected boolean useUnlimitedThreads;
    @Parameter(property="parallel")
    protected String parallel;
    @Parameter(property="trimStackTrace", defaultValue="true")
    protected boolean trimStackTrace;
    @Component
    protected ArtifactResolver artifactResolver;
    @Component
    protected ArtifactFactory artifactFactory;
    @Parameter(defaultValue="${project.pluginArtifactRepositories}")
    protected List<ArtifactRepository> remoteRepositories;
    @Component
    protected ArtifactMetadataSource metadataSource;
    @Parameter(property="disableXmlReport", defaultValue="false")
    protected boolean disableXmlReport;
    @Parameter(property="enableAssertions", defaultValue="true")
    protected boolean enableAssertions;
    @Component
    protected MavenSession session;
    @Parameter(property="objectFactory")
    protected String objectFactory;
    @Parameter(defaultValue="${session.parallel}", readonly=true)
    protected Boolean parallelMavenExecution;
    @Parameter(defaultValue="filesystem")
    protected String runOrder;
    @Component
    protected ToolchainManager toolchainManager;
    private Artifact surefireBooterArtifact;
    private Toolchain toolchain;
    private SurefireDependencyResolver dependencyResolver;

    protected abstract String getPluginName();

    public void execute() throws MojoExecutionException, MojoFailureException {
        this.setupStuff();
        if (this.verifyParameters() && !this.hasExecutedBefore()) {
            DefaultScanResult scan = this.scanDirectories();
            if (scan.isEmpty()) {
                if (this.getEffectiveFailIfNoTests()) {
                    throw new MojoFailureException("No tests were executed!  (Set -DfailIfNoTests=false to ignore this error.)");
                }
                this.handleSummary(Summary.noTestsRun());
                return;
            }
            this.logReportsDirectory();
            this.executeAfterPreconditionsChecked(scan);
        }
    }

    private void setupStuff() {
        this.createDependencyResolver();
        this.surefireBooterArtifact = this.getSurefireBooterArtifact();
        this.toolchain = this.getToolchain();
    }

    private DefaultScanResult scanDirectories() {
        return new DirectoryScanner(this.getTestClassesDirectory(), this.getIncludeList(), this.getExcludeList(), this.getSpecificTests()).scan();
    }

    boolean verifyParameters() throws MojoFailureException, MojoExecutionException {
        this.setProperties(new SurefireProperties(this.getProperties()));
        if (this.isSkipExecution()) {
            this.getLog().info((CharSequence)"Tests are skipped.");
            return false;
        }
        String jvmToUse = this.getJvm();
        if (this.toolchain != null) {
            this.getLog().info((CharSequence)("Toolchain in " + this.getPluginName() + "-plugin: " + this.toolchain));
            if (jvmToUse != null) {
                this.getLog().warn((CharSequence)("Toolchains are ignored, 'executable' parameter is set to " + jvmToUse));
            }
        }
        if (!this.getTestClassesDirectory().exists()) {
            if (Boolean.TRUE.equals(this.getFailIfNoTests())) {
                throw new MojoFailureException("No tests to run!");
            }
            this.getLog().info((CharSequence)"No tests to run.");
        } else {
            this.ensureWorkingDirectoryExists();
            this.ensureParallelRunningCompatibility();
            this.ensureThreadCountWithPerThread();
            this.warnIfUselessUseSystemClassLoaderParameter();
            this.warnIfDefunctGroupsCombinations();
        }
        return true;
    }

    protected abstract boolean isSkipExecution();

    protected void executeAfterPreconditionsChecked(DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        Summary summary = this.executeAllProviders(scanResult);
        this.handleSummary(summary);
    }

    private void createDependencyResolver() {
        this.dependencyResolver = new SurefireDependencyResolver(this.getArtifactResolver(), this.getArtifactFactory(), this.getLog(), this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), this.getPluginName());
    }

    protected List<ProviderInfo> createProviders() throws MojoFailureException, MojoExecutionException {
        Artifact junitDepArtifact = this.getJunitDepArtifact();
        ProviderList wellKnownProviders = new ProviderList(new DynamicProviderInfo(null), new TestNgProviderInfo(this.getTestNgArtifact()), new JUnitCoreProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit4ProviderInfo(this.getJunitArtifact(), junitDepArtifact), new JUnit3ProviderInfo());
        return wellKnownProviders.resolve(this.getLog());
    }

    private Summary executeAllProviders(DefaultScanResult scanResult) throws MojoExecutionException, MojoFailureException {
        List<ProviderInfo> providers = this.createProviders();
        Summary summary = new Summary();
        for (ProviderInfo provider : providers) {
            this.executeProvider(provider, scanResult, summary);
        }
        return summary;
    }

    private SurefireProperties setupProperties() {
        SurefireProperties result = SurefireProperties.calculateEffectiveProperties(this.getSystemProperties(), this.getSystemPropertiesFile(), this.getSystemPropertyVariables(), this.getUserProperties(), this.getLog());
        result.setProperty("basedir", this.getBasedir().getAbsolutePath());
        result.setProperty("user.dir", this.getWorkingDirectory().getAbsolutePath());
        result.setProperty("localRepository", this.getLocalRepository().getBasedir());
        result.verifyLegalSystemProperties(this.getLog());
        if (this.getLog().isDebugEnabled()) {
            result.showToLog(this.getLog(), "system property");
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeProvider(ProviderInfo provider, DefaultScanResult scanResult, Summary summary) throws MojoExecutionException, MojoFailureException {
        SurefireProperties effectiveProperties = this.setupProperties();
        summary.reportForkConfiguration(this.isForking());
        ClassLoaderConfiguration classLoaderConfiguration = this.getClassLoaderConfiguration(this.isForking());
        try {
            RunResult result;
            RunOrderParameters runOrderParameters = new RunOrderParameters(this.getRunOrder(), this.getStatisticsFileName(this.getConfigChecksum()));
            if (this.isForkModeNever()) {
                effectiveProperties.copyToSystemProperties();
                InPluginVMSurefireStarter surefireStarter = this.createInprocessStarter(provider, classLoaderConfiguration, runOrderParameters);
                result = surefireStarter.runSuitesInProcess(scanResult);
            } else {
                ForkConfiguration forkConfiguration = this.getForkConfiguration();
                if (this.getLog().isDebugEnabled()) {
                    this.showMap(this.getEnvironmentVariables(), "environment variable");
                }
                Properties originalSystemProperties = (Properties)System.getProperties().clone();
                try {
                    ForkStarter forkStarter = this.createForkStarter(provider, forkConfiguration, classLoaderConfiguration, runOrderParameters, effectiveProperties);
                    result = forkStarter.run(effectiveProperties, scanResult, this.getEffectiveForkMode());
                }
                finally {
                    System.setProperties(originalSystemProperties);
                    this.cleanupForkConfiguration(forkConfiguration);
                }
            }
            summary.registerRunResult(result);
        }
        catch (SurefireBooterForkException e) {
            summary.registerException((Exception)((Object)e));
        }
        catch (SurefireExecutionException e) {
            summary.registerException((Exception)((Object)e));
        }
    }

    protected void cleanupForkConfiguration(ForkConfiguration forkConfiguration) {
        if (!this.getLog().isDebugEnabled() && forkConfiguration != null) {
            File tempDirectory = forkConfiguration.getTempDirectory();
            try {
                FileUtils.deleteDirectory(tempDirectory);
            }
            catch (IOException ioe) {
                this.getLog().warn((CharSequence)("Could not delete temp direcotry " + tempDirectory + " because " + ioe.getMessage()));
            }
        }
    }

    protected abstract void handleSummary(Summary var1) throws MojoExecutionException, MojoFailureException;

    protected void logReportsDirectory() {
        this.getLog().info((CharSequence)(StringUtils.capitalizeFirstLetter(this.getPluginName()) + " report directory: " + this.getReportsDirectory()));
    }

    final Toolchain getToolchain() {
        Toolchain tc = null;
        if (this.getToolchainManager() != null) {
            tc = this.getToolchainManager().getToolchainFromBuildContext("jdk", this.getSession());
        }
        return tc;
    }

    private void convertTestNGParameters() {
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        this.convertGroupParameters();
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        if (this.getObjectFactory() != null) {
            this.getProperties().setProperty("objectfactory", this.getObjectFactory());
        }
        if (this.getTestClassesDirectory() != null) {
            this.getProperties().setProperty("testng.test.classpath", this.getTestClassesDirectory().getAbsolutePath());
        }
    }

    private void convertGroupParameters() {
        if (this.getExcludedGroups() != null) {
            this.getProperties().setProperty("excludegroups", this.getExcludedGroups());
        }
        if (this.getGroups() != null) {
            this.getProperties().setProperty("groups", this.getGroups());
        }
    }

    protected boolean isAnyConcurrencySelected() {
        return this.getParallel() != null && this.getParallel().trim().length() > 0;
    }

    protected boolean isAnyGroupsSelected() {
        return this.getGroups() != null || this.getExcludedGroups() != null;
    }

    private void convertJunitCoreParameters() {
        if (this.getParallel() != null) {
            this.getProperties().setProperty("parallel", this.getParallel());
        }
        if (this.getThreadCount() > 0) {
            this.getProperties().setProperty("threadcount", Integer.toString(this.getThreadCount()));
        }
        this.getProperties().setProperty("perCoreThreadCount", Boolean.toString(this.getPerCoreThreadCount()));
        this.getProperties().setProperty("useUnlimitedThreads", Boolean.toString(this.getUseUnlimitedThreads()));
    }

    private boolean isJunit47Compatible(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.7,)");
    }

    private boolean isAnyJunit4(Artifact artifact) {
        return this.dependencyResolver.isWithinVersionSpec(artifact, "[4.0,)");
    }

    boolean isForkModeNever() {
        return "never".equals(this.getEffectiveForkMode());
    }

    boolean isForking() {
        return !this.isForkModeNever();
    }

    private String getEffectiveForkMode() {
        String forkMode1 = this.getForkMode();
        if (this.toolchain != null && this.isForkModeNever()) {
            return "once";
        }
        return ForkConfiguration.getEffectiveForkMode(forkMode1);
    }

    private List<RunOrder> getRunOrders() {
        String runOrderString = this.getRunOrder();
        RunOrder[] runOrder = runOrderString == null ? RunOrder.DEFAULT : RunOrder.valueOfMulti((String)runOrderString);
        return Arrays.asList(runOrder);
    }

    private boolean requiresRunHistory() {
        List<RunOrder> runOrders = this.getRunOrders();
        return runOrders.contains(RunOrder.BALANCED) || runOrders.contains(RunOrder.FAILEDFIRST);
    }

    private boolean getEffectiveFailIfNoTests() {
        if (this.isSpecificTestSpecified()) {
            if (this.getFailIfNoSpecifiedTests() != null) {
                return this.getFailIfNoSpecifiedTests();
            }
            if (this.getFailIfNoTests() != null) {
                return this.getFailIfNoTests();
            }
            return true;
        }
        return this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
    }

    private ProviderConfiguration createProviderConfiguration(RunOrderParameters runOrderParameters) throws MojoExecutionException, MojoFailureException {
        boolean failIfNoTests;
        ReporterConfiguration reporterConfiguration = new ReporterConfiguration(this.getReportsDirectory(), Boolean.valueOf(this.isTrimStackTrace()));
        Artifact testNgArtifact = this.getTestNgArtifact();
        DirectoryScannerParameters directoryScannerParameters = null;
        boolean isTestNg = testNgArtifact != null;
        TestArtifactInfo testNg = isTestNg ? new TestArtifactInfo(testNgArtifact.getVersion(), testNgArtifact.getClassifier()) : null;
        List<File> testXml = this.getSuiteXmlFiles() != null ? Arrays.asList(this.getSuiteXmlFiles()) : null;
        TestRequest testSuiteDefinition = new TestRequest(testXml, this.getTestSourceDirectory(), this.getTest(), this.getTestMethod());
        if (this.isValidSuiteXmlFileConfig() && this.getTest() == null) {
            boolean bl = failIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            if (!isTestNg) {
                throw new MojoExecutionException("suiteXmlFiles is configured, but there is no TestNG dependency");
            }
        } else {
            if (this.isSpecificTestSpecified()) {
                failIfNoTests = this.getEffectiveFailIfNoTests();
                this.setFailIfNoTests(failIfNoTests);
            } else {
                failIfNoTests = this.getFailIfNoTests() != null && this.getFailIfNoTests() != false;
            }
            List<String> includes = this.getIncludeList();
            List<String> excludes = this.getExcludeList();
            List<String> specificTests = this.getSpecificTests();
            directoryScannerParameters = new DirectoryScannerParameters(this.getTestClassesDirectory(), includes, excludes, specificTests, Boolean.valueOf(failIfNoTests), this.getRunOrder());
        }
        Properties providerProperties = this.getProperties();
        return new ProviderConfiguration(directoryScannerParameters, runOrderParameters, failIfNoTests, reporterConfiguration, testNg, testSuiteDefinition, providerProperties, null);
    }

    public String getStatisticsFileName(String configurationHash) {
        return this.getReportsDirectory().getParentFile().getParentFile() + File.separator + ".surefire-" + configurationHash;
    }

    StartupConfiguration createStartupConfiguration(ProviderInfo provider, ClassLoaderConfiguration classLoaderConfiguration) throws MojoExecutionException, MojoFailureException {
        try {
            provider.addProviderProperties();
            String providerName = provider.getProviderName();
            Classpath providerClasspath = ClasspathCache.getCachedClassPath(providerName);
            if (providerClasspath == null) {
                providerClasspath = provider.getProviderClasspath();
                ClasspathCache.setCachedClasspath(providerName, providerClasspath);
            }
            Classpath inprocClassPath = new Classpath(providerClasspath);
            Artifact surefireArtifact = this.getCommonArtifact();
            inprocClassPath.addClassPathElementUrl(surefireArtifact.getFile().getAbsolutePath());
            Classpath testClasspath = this.generateTestClasspath();
            this.logClasspath(testClasspath, "test classpath");
            this.logClasspath(providerClasspath, "provider classpath");
            ClasspathConfiguration classpathConfiguration = new ClasspathConfiguration(testClasspath, providerClasspath, inprocClassPath, this.effectiveIsEnableAssertions(), this.isChildDelegation());
            return new StartupConfiguration(providerName, classpathConfiguration, classLoaderConfiguration, this.isForking(), false);
        }
        catch (ArtifactResolutionException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (ArtifactNotFoundException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
        catch (InvalidVersionSpecificationException e) {
            throw new MojoExecutionException("Unable to generate classpath: " + (Object)((Object)e), (Exception)((Object)e));
        }
    }

    private Artifact getCommonArtifact() {
        return this.getPluginArtifactMap().get("org.apache.maven.surefire:maven-surefire-common");
    }

    private StartupReportConfiguration getStartupReportConfiguration(String configChecksum) {
        return new StartupReportConfiguration(this.isUseFile(), this.isPrintSummary(), this.getReportFormat(), this.isRedirectTestOutputToFile(), this.isDisableXmlReport(), this.getReportsDirectory(), this.isTrimStackTrace(), this.getReportNameSuffix(), configChecksum, this.requiresRunHistory());
    }

    void logClasspath(Classpath classpath, String descriptor) {
        this.getLog().debug((CharSequence)(descriptor + " classpath:"));
        List classPath = classpath.getClassPath();
        for (String classpathElement : classPath) {
            if (classpathElement == null) {
                this.getLog().warn((CharSequence)"The test classpath contains a null element.");
                continue;
            }
            this.getLog().debug((CharSequence)("  " + classpathElement));
        }
    }

    private boolean isSpecificTestSpecified() {
        return this.getTest() != null;
    }

    private boolean isValidSuiteXmlFileConfig() {
        return this.getSuiteXmlFiles() != null && this.getSuiteXmlFiles().length > 0;
    }

    private List<String> getExcludeList() {
        List<String> excludes;
        if (this.isSpecificTestSpecified()) {
            excludes = new ArrayList<String>();
        } else {
            excludes = this.getExcludes();
            if (excludes == null || excludes.size() == 0) {
                excludes = new ArrayList<String>(Arrays.asList("**/*$*"));
            }
        }
        return excludes;
    }

    private List<String> getIncludeList() {
        List<String> includes = this.isSpecificTestSpecified() && !this.isMultipleExecutionBlocksDetected() ? this.getSpecificTests() : this.getIncludes();
        if (includes == null || includes.size() == 0) {
            includes = new ArrayList<String>(Arrays.asList(this.getDefaultIncludes()));
        }
        return includes;
    }

    private boolean isMultipleExecutionBlocksDetected() {
        MavenProject project = this.getProject();
        if (project != null) {
            String key = this.getPluginDescriptor().getPluginLookupKey();
            Plugin plugin = (Plugin)project.getBuild().getPluginsAsMap().get(key);
            if (plugin != null) {
                List executions = plugin.getExecutions();
                return executions != null && executions.size() > 1;
            }
        }
        return false;
    }

    private List<String> getSpecificTests() {
        String[] testRegexes;
        if (!this.isSpecificTestSpecified()) {
            return Collections.emptyList();
        }
        ArrayList<String> specificTests = new ArrayList<String>();
        for (String testRegexe : testRegexes = StringUtils.split(this.getTest(), ",")) {
            String testRegex = testRegexe;
            if (testRegex.endsWith(".java")) {
                testRegex = testRegex.substring(0, testRegex.length() - 5);
            }
            testRegex = testRegex.replace('.', '/');
            specificTests.add("**/" + testRegex + ".java");
        }
        return specificTests;
    }

    private Artifact getTestNgArtifact() throws MojoExecutionException {
        VersionRange range;
        Artifact artifact = this.getProjectArtifactMap().get(this.getTestNGArtifactName());
        if (artifact != null && !(range = this.createVersionRange()).containsVersion((ArtifactVersion)new DefaultArtifactVersion(artifact.getVersion()))) {
            throw new MojoExecutionException("TestNG support requires version 4.7 or above. You have declared version " + artifact.getVersion());
        }
        return artifact;
    }

    private VersionRange createVersionRange() {
        try {
            return VersionRange.createFromVersionSpec((String)"[4.7,)");
        }
        catch (InvalidVersionSpecificationException e) {
            throw new RuntimeException(e);
        }
    }

    private Artifact getJunitArtifact() {
        return this.getProjectArtifactMap().get(this.getJunitArtifactName());
    }

    private Artifact getJunitDepArtifact() {
        return this.getProjectArtifactMap().get("junit:junit-dep");
    }

    protected ForkStarter createForkStarter(ProviderInfo provider, ForkConfiguration forkConfiguration, ClassLoaderConfiguration classLoaderConfiguration, RunOrderParameters runOrderParameters, SurefireProperties effectiveSystemProperties) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, classLoaderConfiguration);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new ForkStarter(providerConfiguration, startupConfiguration, forkConfiguration, this.getForkedProcessTimeoutInSeconds(), startupReportConfiguration);
    }

    protected InPluginVMSurefireStarter createInprocessStarter(ProviderInfo provider, ClassLoaderConfiguration classLoaderConfiguration, RunOrderParameters runOrderParameters) throws MojoExecutionException, MojoFailureException {
        StartupConfiguration startupConfiguration = this.createStartupConfiguration(provider, classLoaderConfiguration);
        String configChecksum = this.getConfigChecksum();
        StartupReportConfiguration startupReportConfiguration = this.getStartupReportConfiguration(configChecksum);
        ProviderConfiguration providerConfiguration = this.createProviderConfiguration(runOrderParameters);
        return new InPluginVMSurefireStarter(startupConfiguration, providerConfiguration, startupReportConfiguration);
    }

    protected ForkConfiguration getForkConfiguration() {
        File tmpDir = this.getSurefireTempDir();
        tmpDir.mkdirs();
        Artifact shadeFire = this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-shadefire");
        Classpath bootClasspathConfiguration = this.getArtifactClasspath(shadeFire != null ? shadeFire : this.surefireBooterArtifact);
        return new ForkConfiguration(bootClasspathConfiguration, tmpDir, this.getEffectiveDebugForkedProcess(), this.getEffectiveJvm(), this.getWorkingDirectory() != null ? this.getWorkingDirectory() : this.getBasedir(), this.getArgLine(), this.getEnvironmentVariables(), this.getLog().isDebugEnabled(), this.getEffectiveForkCount());
    }

    private int getEffectiveForkCount() {
        return "perthread".equals(this.getEffectiveForkMode()) ? this.getThreadCount() : 1;
    }

    private String getEffectiveDebugForkedProcess() {
        String debugForkedProcess = this.getDebugForkedProcess();
        if ("true".equals(debugForkedProcess)) {
            return "-Xdebug -Xnoagent -Djava.compiler=NONE -Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=5005";
        }
        return debugForkedProcess;
    }

    private String getEffectiveJvm() {
        String jvmToUse = this.getJvm();
        if (this.toolchain != null && jvmToUse == null) {
            jvmToUse = this.toolchain.findTool("java");
        }
        if (StringUtils.isEmpty(jvmToUse)) {
            jvmToUse = System.getProperty("java.home") + File.separator + "bin" + File.separator + "java";
            this.getLog().debug((CharSequence)("Using JVM: " + jvmToUse));
        }
        return jvmToUse;
    }

    private Artifact getSurefireBooterArtifact() {
        Artifact artifact = this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        if (artifact == null) {
            throw new RuntimeException("Unable to locate surefire-booter in the list of plugin artifacts");
        }
        artifact.isSnapshot();
        return artifact;
    }

    private File getSurefireTempDir() {
        return new File(this.getReportsDirectory().getParentFile(), "surefire");
    }

    private String getConfigChecksum() {
        ChecksumCalculator checksum = new ChecksumCalculator();
        checksum.add(this.getPluginName());
        checksum.add(this.isSkipTests());
        checksum.add(this.isSkipExec());
        checksum.add(this.isSkip());
        checksum.add(this.getTestClassesDirectory());
        checksum.add(this.getClassesDirectory());
        checksum.add(this.getClasspathDependencyExcludes());
        checksum.add(this.getClasspathDependencyScopeExclude());
        checksum.add(this.getAdditionalClasspathElements());
        checksum.add(this.getReportsDirectory());
        checksum.add(this.getTestSourceDirectory());
        checksum.add(this.getTest());
        checksum.add(this.getIncludes());
        checksum.add(this.getExcludes());
        checksum.add(this.getLocalRepository());
        checksum.add(this.getSystemProperties());
        checksum.add(this.getSystemPropertyVariables());
        checksum.add(this.getSystemPropertiesFile());
        checksum.add(this.getProperties());
        checksum.add(this.isPrintSummary());
        checksum.add(this.getReportFormat());
        checksum.add(this.getReportNameSuffix());
        checksum.add(this.isUseFile());
        checksum.add(this.isRedirectTestOutputToFile());
        checksum.add(this.getForkMode());
        checksum.add(this.getJvm());
        checksum.add(this.getArgLine());
        checksum.add(this.getDebugForkedProcess());
        checksum.add(this.getForkedProcessTimeoutInSeconds());
        checksum.add(this.getEnvironmentVariables());
        checksum.add(this.getWorkingDirectory());
        checksum.add(this.isChildDelegation());
        checksum.add(this.getGroups());
        checksum.add(this.getExcludedGroups());
        checksum.add(this.getSuiteXmlFiles());
        checksum.add(this.getJunitArtifact());
        checksum.add(this.getTestNGArtifactName());
        checksum.add(this.getThreadCount());
        checksum.add(this.getPerCoreThreadCount());
        checksum.add(this.getUseUnlimitedThreads());
        checksum.add(this.getParallel());
        checksum.add(this.isTrimStackTrace());
        checksum.add(this.getRemoteRepositories());
        checksum.add(this.isDisableXmlReport());
        checksum.add(this.isUseSystemClassLoader());
        checksum.add(this.isUseManifestOnlyJar());
        checksum.add(this.isEnableAssertions());
        checksum.add(this.getObjectFactory());
        checksum.add(this.getFailIfNoTests());
        checksum.add(this.getRunOrder());
        this.addPluginSpecificChecksumItems(checksum);
        return checksum.getSha1();
    }

    protected void addPluginSpecificChecksumItems(ChecksumCalculator checksum) {
    }

    protected boolean hasExecutedBefore() {
        String configChecksum = this.getConfigChecksum();
        Map pluginContext = this.getPluginContext();
        if (pluginContext.containsKey(configChecksum)) {
            this.getLog().info((CharSequence)"Skipping execution of surefire because it has already been run for this configuration");
            return true;
        }
        pluginContext.put(configChecksum, configChecksum);
        return false;
    }

    protected ClassLoaderConfiguration getClassLoaderConfiguration(boolean isForking) {
        return isForking ? new ClassLoaderConfiguration(this.isUseSystemClassLoader(), this.isUseManifestOnlyJar()) : new ClassLoaderConfiguration(false, false);
    }

    protected abstract String[] getDefaultIncludes();

    Classpath generateTestClasspath() throws InvalidVersionSpecificationException, MojoFailureException, ArtifactResolutionException, ArtifactNotFoundException, MojoExecutionException {
        PatternIncludesArtifactFilter dependencyFilter;
        ArrayList<String> classpath = new ArrayList<String>(2 + this.getProject().getArtifacts().size());
        classpath.add(this.getTestClassesDirectory().getAbsolutePath());
        classpath.add(this.getClassesDirectory().getAbsolutePath());
        Set<Artifact> classpathArtifacts = this.getProject().getArtifacts();
        if (this.getClasspathDependencyScopeExclude() != null && !this.getClasspathDependencyScopeExclude().equals("")) {
            dependencyFilter = new ScopeArtifactFilter(this.getClasspathDependencyScopeExclude());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        if (this.getClasspathDependencyExcludes() != null) {
            dependencyFilter = new PatternIncludesArtifactFilter(this.getClasspathDependencyExcludes());
            classpathArtifacts = this.filterArtifacts(classpathArtifacts, (ArtifactFilter)dependencyFilter);
        }
        for (Artifact artifact : classpathArtifacts) {
            File file;
            if (!artifact.getArtifactHandler().isAddedToClasspath() || (file = artifact.getFile()) == null) continue;
            classpath.add(file.getPath());
        }
        if (this.getAdditionalClasspathElements() != null) {
            for (String classpathElement : this.getAdditionalClasspathElements()) {
                if (classpathElement == null) continue;
                classpath.add(classpathElement);
            }
        }
        if (this.getTestNgArtifact() != null) {
            this.addTestNgUtilsArtifacts(classpath);
        }
        return new Classpath(classpath);
    }

    void addTestNgUtilsArtifacts(List<String> classpath) throws ArtifactResolutionException, ArtifactNotFoundException {
        Artifact[] extraTestNgArtifacts;
        Artifact surefireArtifact = this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
        String surefireVersion = surefireArtifact.getBaseVersion();
        for (Artifact artifact : extraTestNgArtifacts = new Artifact[]{this.getArtifactFactory().createArtifact("org.apache.maven.surefire", "surefire-testng-utils", surefireVersion, "runtime", "jar"), this.getArtifactFactory().createArtifact("org.apache.maven.surefire", "surefire-grouper", surefireVersion, "runtime", "jar")}) {
            this.getArtifactResolver().resolve(artifact, this.getRemoteRepositories(), this.getLocalRepository());
            String path = artifact.getFile().getPath();
            classpath.add(path);
        }
    }

    private Set<Artifact> filterArtifacts(Set<Artifact> artifacts, ArtifactFilter filter) {
        LinkedHashSet<Artifact> filteredArtifacts = new LinkedHashSet<Artifact>();
        for (Artifact artifact : artifacts) {
            if (filter.include(artifact)) continue;
            filteredArtifacts.add(artifact);
        }
        return filteredArtifacts;
    }

    private void showMap(Map<?, ?> map, String setting) {
        for (Object o : map.keySet()) {
            String key = (String)o;
            String value = (String)map.get(key);
            this.getLog().debug((CharSequence)("Setting " + setting + " [" + key + "]=[" + value + "]"));
        }
    }

    private ArtifactResolutionResult resolveArtifact(Artifact filteredArtifact, Artifact providerArtifact) {
        ExcludesArtifactFilter filter = null;
        if (filteredArtifact != null) {
            filter = new ExcludesArtifactFilter(Collections.singletonList(filteredArtifact.getGroupId() + ":" + filteredArtifact.getArtifactId()));
        }
        Artifact originatingArtifact = this.getArtifactFactory().createBuildArtifact("dummy", "dummy", "1.0", "jar");
        try {
            return this.getArtifactResolver().resolveTransitively(Collections.singleton(providerArtifact), originatingArtifact, this.getLocalRepository(), this.getRemoteRepositories(), this.getMetadataSource(), (ArtifactFilter)filter);
        }
        catch (ArtifactResolutionException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
        catch (ArtifactNotFoundException e) {
            throw new NestedRuntimeException((Throwable)e);
        }
    }

    private Classpath getArtifactClasspath(Artifact surefireArtifact) {
        Classpath existing = ClasspathCache.getCachedClassPath(surefireArtifact.getArtifactId());
        if (existing == null) {
            ArtifactResolutionResult result = this.resolveArtifact(null, surefireArtifact);
            ArrayList<String> items = new ArrayList<String>();
            for (Object o : result.getArtifacts()) {
                Artifact artifact = (Artifact)o;
                this.getLog().debug((CharSequence)("Adding to " + this.getPluginName() + " booter test classpath: " + artifact.getFile().getAbsolutePath() + " Scope: " + artifact.getScope()));
                items.add(artifact.getFile().getAbsolutePath());
            }
            existing = new Classpath(items);
            ClasspathCache.setCachedClasspath(surefireArtifact.getArtifactId(), existing);
        }
        return existing;
    }

    private Properties getUserProperties() {
        Properties props = null;
        try {
            Method getUserProperties = this.getSession().getClass().getMethod("getUserProperties", new Class[0]);
            props = (Properties)getUserProperties.invoke((Object)this.getSession(), new Object[0]);
        }
        catch (Exception e) {
            String msg = "Build uses Maven 2.0.x, cannot propagate system properties from command line to tests (cf. SUREFIRE-121)";
            if (this.getLog().isDebugEnabled()) {
                this.getLog().warn((CharSequence)msg, (Throwable)e);
            }
            this.getLog().warn((CharSequence)msg);
        }
        if (props == null) {
            props = new Properties();
        }
        return props;
    }

    void ensureWorkingDirectoryExists() throws MojoFailureException {
        if (this.getWorkingDirectory() == null) {
            throw new MojoFailureException("workingDirectory cannot be null");
        }
        if (!this.getWorkingDirectory().exists() && !this.getWorkingDirectory().mkdirs()) {
            throw new MojoFailureException("Cannot create workingDirectory " + this.getWorkingDirectory());
        }
        if (!this.getWorkingDirectory().isDirectory()) {
            throw new MojoFailureException("workingDirectory " + this.getWorkingDirectory() + " exists and is not a directory");
        }
    }

    void ensureParallelRunningCompatibility() throws MojoFailureException {
        if (this.isMavenParallel() && this.isForkModeNever()) {
            throw new MojoFailureException("parallel maven execution is not compatible with surefire forkmode NEVER");
        }
    }

    void ensureThreadCountWithPerThread() throws MojoFailureException {
        if ("perthread".equals(this.getEffectiveForkMode()) && this.getThreadCount() < 1) {
            throw new MojoFailureException("Fork mode perthread requires a thread count");
        }
    }

    void warnIfUselessUseSystemClassLoaderParameter() {
        if (this.isUseSystemClassLoader() && this.isForkModeNever()) {
            this.getLog().warn((CharSequence)"useSystemClassloader setting has no effect when not forking");
        }
    }

    void warnIfDefunctGroupsCombinations() throws MojoFailureException, MojoExecutionException {
        if (this.isAnyGroupsSelected()) {
            if (this.getTestNgArtifact() != null) {
                return;
            }
            Artifact junitArtifact = this.getJunitArtifact();
            boolean junit47Compatible = this.isJunit47Compatible(junitArtifact);
            if (junit47Compatible) {
                return;
            }
            if (junitArtifact != null && !junit47Compatible) {
                throw new MojoFailureException("groups/excludedGroups are specified but JUnit version on classpath is too old to support groups. Check your dependency:tree to see if your project is picking up an old junit version");
            }
            throw new MojoFailureException("groups/excludedGroups require TestNG or JUunit48+ on project test classpath");
        }
    }

    @Override
    public List<String> getIncludes() {
        return this.includes;
    }

    @Override
    public void setIncludes(List<String> includes) {
        this.includes = includes;
    }

    @Override
    public List<String> getExcludes() {
        return this.excludes;
    }

    @Override
    public void setExcludes(List<String> excludes) {
        this.excludes = excludes;
    }

    @Override
    public ArtifactRepository getLocalRepository() {
        return this.localRepository;
    }

    @Override
    public void setLocalRepository(ArtifactRepository localRepository) {
        this.localRepository = localRepository;
    }

    public Properties getSystemProperties() {
        return this.systemProperties;
    }

    public void setSystemProperties(Properties systemProperties) {
        this.systemProperties = systemProperties;
    }

    public Map<String, String> getSystemPropertyVariables() {
        return this.systemPropertyVariables;
    }

    public void setSystemPropertyVariables(Map<String, String> systemPropertyVariables) {
        this.systemPropertyVariables = systemPropertyVariables;
    }

    public File getSystemPropertiesFile() {
        return this.systemPropertiesFile;
    }

    public void setSystemPropertiesFile(File systemPropertiesFile) {
        this.systemPropertiesFile = systemPropertiesFile;
    }

    public Properties getProperties() {
        return this.properties;
    }

    public void setProperties(Properties properties) {
        this.properties = properties;
    }

    public Map<String, Artifact> getPluginArtifactMap() {
        return this.pluginArtifactMap;
    }

    public void setPluginArtifactMap(Map<String, Artifact> pluginArtifactMap) {
        this.pluginArtifactMap = pluginArtifactMap;
    }

    public Map<String, Artifact> getProjectArtifactMap() {
        return this.projectArtifactMap;
    }

    public void setProjectArtifactMap(Map<String, Artifact> projectArtifactMap) {
        this.projectArtifactMap = projectArtifactMap;
    }

    public String getReportNameSuffix() {
        return this.reportNameSuffix;
    }

    public void setReportNameSuffix(String reportNameSuffix) {
        this.reportNameSuffix = reportNameSuffix;
    }

    public boolean isRedirectTestOutputToFile() {
        return this.redirectTestOutputToFile;
    }

    public void setRedirectTestOutputToFile(boolean redirectTestOutputToFile) {
        this.redirectTestOutputToFile = redirectTestOutputToFile;
    }

    public Boolean getFailIfNoTests() {
        return this.failIfNoTests;
    }

    public void setFailIfNoTests(Boolean failIfNoTests) {
        this.failIfNoTests = failIfNoTests;
    }

    public String getForkMode() {
        return this.forkMode;
    }

    public void setForkMode(String forkMode) {
        this.forkMode = forkMode;
    }

    public String getJvm() {
        return this.jvm;
    }

    public String getArgLine() {
        return this.argLine;
    }

    public void setArgLine(String argLine) {
        this.argLine = argLine;
    }

    public Map<String, String> getEnvironmentVariables() {
        return this.environmentVariables;
    }

    public void setEnvironmentVariables(Map<String, String> environmentVariables) {
        this.environmentVariables = environmentVariables;
    }

    public File getWorkingDirectory() {
        return this.workingDirectory;
    }

    public void setWorkingDirectory(File workingDirectory) {
        this.workingDirectory = workingDirectory;
    }

    public boolean isChildDelegation() {
        return this.childDelegation;
    }

    public void setChildDelegation(boolean childDelegation) {
        this.childDelegation = childDelegation;
    }

    public String getGroups() {
        return this.groups;
    }

    public void setGroups(String groups) {
        this.groups = groups;
    }

    public String getExcludedGroups() {
        return this.excludedGroups;
    }

    public void setExcludedGroups(String excludedGroups) {
        this.excludedGroups = excludedGroups;
    }

    public File[] getSuiteXmlFiles() {
        return this.suiteXmlFiles;
    }

    public void setSuiteXmlFiles(File[] suiteXmlFiles) {
        this.suiteXmlFiles = suiteXmlFiles;
    }

    public String getJunitArtifactName() {
        return this.junitArtifactName;
    }

    public void setJunitArtifactName(String junitArtifactName) {
        this.junitArtifactName = junitArtifactName;
    }

    public String getTestNGArtifactName() {
        return this.testNGArtifactName;
    }

    public void setTestNGArtifactName(String testNGArtifactName) {
        this.testNGArtifactName = testNGArtifactName;
    }

    public int getThreadCount() {
        return this.threadCount;
    }

    public void setThreadCount(int threadCount) {
        this.threadCount = threadCount;
    }

    public boolean getPerCoreThreadCount() {
        return this.perCoreThreadCount;
    }

    public void setPerCoreThreadCount(boolean perCoreThreadCount) {
        this.perCoreThreadCount = perCoreThreadCount;
    }

    public boolean getUseUnlimitedThreads() {
        return this.useUnlimitedThreads;
    }

    public void setUseUnlimitedThreads(boolean useUnlimitedThreads) {
        this.useUnlimitedThreads = useUnlimitedThreads;
    }

    public String getParallel() {
        return this.parallel;
    }

    public void setParallel(String parallel) {
        this.parallel = parallel;
    }

    public boolean isTrimStackTrace() {
        return this.trimStackTrace;
    }

    public void setTrimStackTrace(boolean trimStackTrace) {
        this.trimStackTrace = trimStackTrace;
    }

    public ArtifactResolver getArtifactResolver() {
        return this.artifactResolver;
    }

    public void setArtifactResolver(ArtifactResolver artifactResolver) {
        this.artifactResolver = artifactResolver;
    }

    public ArtifactFactory getArtifactFactory() {
        return this.artifactFactory;
    }

    public void setArtifactFactory(ArtifactFactory artifactFactory) {
        this.artifactFactory = artifactFactory;
    }

    public List<ArtifactRepository> getRemoteRepositories() {
        return this.remoteRepositories;
    }

    public void setRemoteRepositories(List<ArtifactRepository> remoteRepositories) {
        this.remoteRepositories = remoteRepositories;
    }

    public ArtifactMetadataSource getMetadataSource() {
        return this.metadataSource;
    }

    public void setMetadataSource(ArtifactMetadataSource metadataSource) {
        this.metadataSource = metadataSource;
    }

    public boolean isDisableXmlReport() {
        return this.disableXmlReport;
    }

    public void setDisableXmlReport(boolean disableXmlReport) {
        this.disableXmlReport = disableXmlReport;
    }

    public boolean isEnableAssertions() {
        return this.enableAssertions;
    }

    public boolean effectiveIsEnableAssertions() {
        List<String> args;
        if (this.getArgLine() != null && ((args = Arrays.asList(this.getArgLine().split(" "))).contains("-da") || args.contains("-disableassertions"))) {
            return false;
        }
        return this.isEnableAssertions();
    }

    public void setEnableAssertions(boolean enableAssertions) {
        this.enableAssertions = enableAssertions;
    }

    public MavenSession getSession() {
        return this.session;
    }

    public void setSession(MavenSession session) {
        this.session = session;
    }

    public String getObjectFactory() {
        return this.objectFactory;
    }

    public void setObjectFactory(String objectFactory) {
        this.objectFactory = objectFactory;
    }

    public ToolchainManager getToolchainManager() {
        return this.toolchainManager;
    }

    public void setToolchainManager(ToolchainManager toolchainManager) {
        this.toolchainManager = toolchainManager;
    }

    public boolean isMavenParallel() {
        return this.parallelMavenExecution != null && this.parallelMavenExecution != false;
    }

    public String getRunOrder() {
        return this.runOrder;
    }

    public void setRunOrder(String runOrder) {
        this.runOrder = runOrder;
    }

    public PluginDescriptor getPluginDescriptor() {
        return this.pluginDescriptor;
    }

    public MavenProject getProject() {
        return this.project;
    }

    public void setProject(MavenProject project) {
        this.project = project;
    }

    @Override
    public File getTestSourceDirectory() {
        return this.testSourceDirectory;
    }

    @Override
    public void setTestSourceDirectory(File testSourceDirectory) {
        this.testSourceDirectory = testSourceDirectory;
    }

    public class DynamicProviderInfo
    implements ConfigurableProviderInfo {
        final String providerName;

        DynamicProviderInfo(String providerName) {
            this.providerName = providerName;
        }

        public ProviderInfo instantiate(String providerName) {
            return new DynamicProviderInfo(providerName);
        }

        public String getProviderName() {
            return this.providerName;
        }

        public boolean isApplicable() {
            return true;
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            Map<String, Artifact> pluginArtifactMap = AbstractSurefireMojo.this.getPluginArtifactMap();
            Artifact plugin = pluginArtifactMap.get("org.apache.maven.plugins:maven-surefire-plugin");
            return AbstractSurefireMojo.this.dependencyResolver.addProviderToClasspath(pluginArtifactMap, plugin);
        }
    }

    class JUnitCoreProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnitCoreProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junitcore.JUnitCoreProvider";
        }

        private boolean is47CompatibleJunitDep() {
            return this.junitDepArtifact != null && AbstractSurefireMojo.this.isJunit47Compatible(this.junitDepArtifact);
        }

        public boolean isApplicable() {
            boolean isJunitArtifact47 = AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact) && AbstractSurefireMojo.this.isJunit47Compatible(this.junitArtifact);
            boolean isAny47ProvidersForcers = AbstractSurefireMojo.this.isAnyConcurrencySelected() || AbstractSurefireMojo.this.isAnyGroupsSelected();
            return isAny47ProvidersForcers && (isJunitArtifact47 || this.is47CompatibleJunitDep());
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertJunitCoreParameters();
            AbstractSurefireMojo.this.convertGroupParameters();
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit47", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    class JUnit4ProviderInfo
    implements ProviderInfo {
        private final Artifact junitArtifact;
        private final Artifact junitDepArtifact;

        JUnit4ProviderInfo(Artifact junitArtifact, Artifact junitDepArtifact) {
            this.junitArtifact = junitArtifact;
            this.junitDepArtifact = junitDepArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junit4.JUnit4Provider";
        }

        public boolean isApplicable() {
            return this.junitDepArtifact != null || AbstractSurefireMojo.this.isAnyJunit4(this.junitArtifact);
        }

        public void addProviderProperties() {
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit4", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    class JUnit3ProviderInfo
    implements ProviderInfo {
        JUnit3ProviderInfo() {
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.junit.JUnit3Provider";
        }

        public boolean isApplicable() {
            return true;
        }

        public void addProviderProperties() {
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-junit3", AbstractSurefireMojo.this.surefireBooterArtifact.getBaseVersion(), null);
        }
    }

    class TestNgProviderInfo
    implements ProviderInfo {
        private final Artifact testNgArtifact;

        TestNgProviderInfo(Artifact testNgArtifact) {
            this.testNgArtifact = testNgArtifact;
        }

        public String getProviderName() {
            return "org.apache.maven.surefire.testng.TestNGProvider";
        }

        public boolean isApplicable() {
            return this.testNgArtifact != null;
        }

        public void addProviderProperties() {
            AbstractSurefireMojo.this.convertTestNGParameters();
        }

        public Classpath getProviderClasspath() throws ArtifactResolutionException, ArtifactNotFoundException {
            Artifact surefireArtifact = AbstractSurefireMojo.this.getPluginArtifactMap().get("org.apache.maven.surefire:surefire-booter");
            return AbstractSurefireMojo.this.dependencyResolver.getProviderClasspath("surefire-testng", surefireArtifact.getBaseVersion(), this.testNgArtifact);
        }
    }
}

