/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.custom.date;

import java.io.Serializable;
import java.text.ParseException;
import java.util.Calendar;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.faces.component.UIComponent;
import javax.faces.component.UIInput;
import javax.faces.context.FacesContext;
import javax.faces.el.ValueBinding;
import org.apache.commons.lang.StringUtils;
import org.apache.myfaces.component.UserRoleAware;
import org.apache.myfaces.component.UserRoleUtils;
import org.apache.myfaces.component.html.util.HtmlComponentUtils;
import org.apache.myfaces.shared_tomahawk.util._ComponentUtils;

public class HtmlInputDate
extends UIInput
implements UserRoleAware {
    public static final String COMPONENT_TYPE = "org.apache.myfaces.HtmlInputDate";
    public static final String COMPONENT_FAMILY = "javax.faces.Input";
    private static final String DEFAULT_RENDERER_TYPE = "org.apache.myfaces.Date";
    private static final boolean DEFAULT_DISABLED = false;
    private Boolean _readonly = null;
    private String _enabledOnUserRole = null;
    private String _visibleOnUserRole = null;
    private String _type = null;
    private Boolean _popupCalendar = null;
    private String _timeZone = null;
    private Boolean _ampm = null;
    private String _emptyMonthSelection = null;
    private String _emptyAmpmSelection = null;
    private Boolean _disabled = null;

    public HtmlInputDate() {
        this.setRendererType(DEFAULT_RENDERER_TYPE);
    }

    public UserData getUserData(Locale currentLocale) {
        return new UserData((Date)this.getValue(), currentLocale, this.getTimeZone(), this.isAmpm(), this.getType());
    }

    public String getClientId(FacesContext context) {
        String clientId = HtmlComponentUtils.getClientId((UIComponent)this, this.getRenderer(context), context);
        if (clientId == null) {
            clientId = super.getClientId(context);
        }
        return clientId;
    }

    public String getType() {
        if (this._type != null) {
            return this._type;
        }
        ValueBinding vb = this.getValueBinding("type");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : "date";
    }

    public void setType(String string) {
        this._type = string;
    }

    public boolean isPopupCalendar() {
        if (this._popupCalendar != null) {
            return this._popupCalendar;
        }
        ValueBinding vb = this.getValueBinding("popupCalendar");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setPopupCalendar(boolean popupCalendar) {
        this._popupCalendar = popupCalendar;
    }

    public boolean isAmpm() {
        if (this._ampm != null) {
            return this._ampm;
        }
        ValueBinding vb = this.getValueBinding("ampm");
        return vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : false;
    }

    public void setAmpm(boolean ampm) {
        this._ampm = ampm;
    }

    public String getTimeZone() {
        if (this._timeZone != null) {
            return this._timeZone;
        }
        ValueBinding vb = this.getValueBinding("timeZone");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setTimeZone(String timeZone) {
        this._timeZone = timeZone;
    }

    public String getEmptyMonthSelection() {
        if (this._emptyMonthSelection != null) {
            return this._emptyMonthSelection;
        }
        ValueBinding vb = this.getValueBinding("emptyMonthSelection");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : "";
    }

    public void setEmptyMonthSelection(String string) {
        this._emptyMonthSelection = string;
    }

    public String getEmptyAmpmSelection() {
        if (this._emptyAmpmSelection != null) {
            return this._emptyAmpmSelection;
        }
        ValueBinding vb = this.getValueBinding("emptyAmpmSelection");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : "";
    }

    public void setEmptyAmpmSelection(String string) {
        this._emptyAmpmSelection = string;
    }

    public boolean isReadonly() {
        if (this._readonly != null) {
            return this._readonly;
        }
        ValueBinding vb = this.getValueBinding("readonly");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setReadonly(boolean readonly) {
        this._readonly = readonly;
    }

    public void setEnabledOnUserRole(String enabledOnUserRole) {
        this._enabledOnUserRole = enabledOnUserRole;
    }

    public String getEnabledOnUserRole() {
        if (this._enabledOnUserRole != null) {
            return this._enabledOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("enabledOnUserRole");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public void setVisibleOnUserRole(String visibleOnUserRole) {
        this._visibleOnUserRole = visibleOnUserRole;
    }

    public String getVisibleOnUserRole() {
        if (this._visibleOnUserRole != null) {
            return this._visibleOnUserRole;
        }
        ValueBinding vb = this.getValueBinding("visibleOnUserRole");
        return vb != null ? _ComponentUtils.getStringValue(this.getFacesContext(), vb) : null;
    }

    public boolean isRendered() {
        if (!UserRoleUtils.isVisibleOnUserRole((UIComponent)this)) {
            return false;
        }
        return super.isRendered();
    }

    public boolean isDisabled() {
        if (this._disabled != null) {
            return this._disabled;
        }
        ValueBinding vb = this.getValueBinding("disabled");
        Boolean v = vb != null ? (Boolean)vb.getValue(this.getFacesContext()) : null;
        return v != null ? v : false;
    }

    public void setDisabled(boolean disabled) {
        this._disabled = disabled;
    }

    public Object saveState(FacesContext context) {
        Object[] values = new Object[]{super.saveState(context), this._type, this._popupCalendar, this._disabled, this._readonly, this._enabledOnUserRole, this._visibleOnUserRole, this._timeZone, this._ampm, this._emptyMonthSelection, this._emptyAmpmSelection};
        return values;
    }

    public void restoreState(FacesContext context, Object state) {
        Object[] values = (Object[])state;
        super.restoreState(context, values[0]);
        this._type = (String)values[1];
        this._popupCalendar = (Boolean)values[2];
        this._disabled = (Boolean)values[3];
        this._readonly = (Boolean)values[4];
        this._enabledOnUserRole = (String)values[5];
        this._visibleOnUserRole = (String)values[6];
        this._timeZone = (String)values[7];
        this._ampm = (Boolean)values[8];
        this._emptyMonthSelection = (String)values[9];
        this._emptyAmpmSelection = (String)values[10];
    }

    public static class UserData
    implements Serializable {
        private static final long serialVersionUID = -6507279524833267707L;
        private String day;
        private String month;
        private String year;
        private String hours;
        private String minutes;
        private String seconds;
        private TimeZone timeZone = null;
        private String ampm;
        private boolean uses_ampm;
        private String type;

        public UserData(Date date, Locale currentLocale, String _timeZone, boolean uses_ampm, String type) {
            this.uses_ampm = uses_ampm;
            this.type = type;
            Calendar calendar = Calendar.getInstance(currentLocale);
            if (_timeZone != null) {
                this.timeZone = TimeZone.getTimeZone(_timeZone);
                calendar.setTimeZone(this.timeZone);
            }
            if (date == null) {
                return;
            }
            calendar.setTime(date);
            this.day = Integer.toString(calendar.get(5));
            this.month = Integer.toString(calendar.get(2) + 1);
            this.year = Integer.toString(calendar.get(1));
            if (uses_ampm) {
                int int_hours = calendar.get(10);
                if (int_hours == 0) {
                    int_hours = 12;
                }
                this.hours = Integer.toString(int_hours);
                this.ampm = Integer.toString(calendar.get(9));
            } else {
                this.hours = Integer.toString(calendar.get(11));
            }
            this.minutes = Integer.toString(calendar.get(12));
            this.seconds = Integer.toString(calendar.get(13));
        }

        public Date parse() throws ParseException {
            Date retDate = null;
            Calendar tempCalendar = Calendar.getInstance();
            tempCalendar.setLenient(Boolean.FALSE);
            if (this.timeZone != null) {
                tempCalendar.setTimeZone(this.timeZone);
            }
            try {
                if (!this.isSubmitValid(this.uses_ampm, this.type)) {
                    return null;
                }
                if (!this.type.equals("time") && !this.type.equals("short_time")) {
                    tempCalendar.set(5, Integer.parseInt(this.day));
                    tempCalendar.set(2, Integer.parseInt(this.month) - 1);
                    tempCalendar.set(1, Integer.parseInt(this.year));
                }
                if (!this.type.equals("date")) {
                    if (this.uses_ampm) {
                        int int_hours = Integer.parseInt(this.hours);
                        if (int_hours == 12) {
                            int_hours = 0;
                        }
                        tempCalendar.set(10, int_hours);
                        tempCalendar.set(9, Integer.parseInt(this.ampm));
                    } else {
                        tempCalendar.set(11, Integer.parseInt(this.hours));
                    }
                    tempCalendar.set(12, Integer.parseInt(this.minutes));
                    if (this.type.equals("full") || this.type.equals("time")) {
                        tempCalendar.set(13, Integer.parseInt(this.seconds));
                    }
                }
                tempCalendar.set(14, 0);
                retDate = tempCalendar.getTime();
            }
            catch (NumberFormatException e) {
                throw new ParseException(e.getMessage(), 0);
            }
            catch (IllegalArgumentException e) {
                throw new ParseException(e.getMessage(), 0);
            }
            return retDate;
        }

        private String formatedInt(String toFormat) {
            if (toFormat == null) {
                return null;
            }
            int i = -1;
            try {
                i = Integer.parseInt(toFormat);
            }
            catch (NumberFormatException nfe) {
                return toFormat;
            }
            if (i >= 0 && i < 10) {
                return "0" + i;
            }
            return Integer.toString(i);
        }

        private boolean isDateSubmitted(boolean usesAmpm, String type) {
            boolean isDateSubmitted;
            boolean bl = isDateSubmitted = !StringUtils.isEmpty((String)this.getDay()) || this.getMonth() != null && !this.getMonth().equals("-1") || !StringUtils.isEmpty((String)this.getYear());
            if (usesAmpm) {
                isDateSubmitted = isDateSubmitted || this.isAmpmSubmitted();
            }
            return isDateSubmitted;
        }

        private boolean isTimeSubmitted(boolean usesAmpm, String type) {
            boolean isTimeSubmitted;
            boolean bl = isTimeSubmitted = !StringUtils.isEmpty((String)this.getHours()) || !StringUtils.isEmpty((String)this.getMinutes());
            if (type.equals("time") || type.equals("full")) {
                boolean bl2 = isTimeSubmitted = isTimeSubmitted || !StringUtils.isEmpty((String)this.getSeconds());
            }
            if (usesAmpm) {
                isTimeSubmitted = isTimeSubmitted || this.isAmpmSubmitted();
            }
            return isTimeSubmitted;
        }

        private boolean isSubmitValid(boolean usesAmpm, String type) {
            if (type.equals("date")) {
                return this.isDateSubmitted(usesAmpm, type);
            }
            if (type.equals("time") || type.equals("short_time")) {
                return this.isTimeSubmitted(usesAmpm, type);
            }
            if (type.equals("full") || type.equals("both")) {
                return this.isDateSubmitted(usesAmpm, type) || this.isTimeSubmitted(usesAmpm, type);
            }
            return false;
        }

        private boolean isAmpmSubmitted() {
            if (this.getAmpm() == null) {
                return false;
            }
            return !this.getAmpm().equals("-1");
        }

        public String getDay() {
            return this.formatedInt(this.day);
        }

        public void setDay(String day) {
            this.day = day;
        }

        public String getMonth() {
            return this.month;
        }

        public void setMonth(String month) {
            this.month = month;
        }

        public String getYear() {
            return this.year;
        }

        public void setYear(String year) {
            this.year = year;
        }

        public String getHours() {
            return this.formatedInt(this.hours);
        }

        public void setHours(String hours) {
            this.hours = hours;
        }

        public String getMinutes() {
            return this.formatedInt(this.minutes);
        }

        public void setMinutes(String minutes) {
            this.minutes = minutes;
        }

        public String getSeconds() {
            return this.formatedInt(this.seconds);
        }

        public void setSeconds(String seconds) {
            this.seconds = seconds;
        }

        public String getAmpm() {
            return this.ampm;
        }

        public void setAmpm(String ampm) {
            this.ampm = ampm;
        }

        public String getType() {
            return this.type;
        }

        public void setType(String type) {
            this.type = type;
        }
    }
}

