/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.macros;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PushbackInputStream;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OfficeXmlFileException;
import org.apache.poi.util.IOUtils;
import org.apache.poi.util.RLEDecompressingInputStream;
import org.apache.poi.util.StringUtil;

public class VBAMacroReader
implements Closeable {
    protected static final String VBA_PROJECT_OOXML = "vbaProject.bin";
    protected static final String VBA_PROJECT_POIFS = "VBA";
    private NPOIFSFileSystem fs;

    public VBAMacroReader(InputStream rstream) throws IOException {
        PushbackInputStream stream = new PushbackInputStream(rstream, 8);
        byte[] header8 = IOUtils.peekFirst8Bytes(stream);
        if (NPOIFSFileSystem.hasPOIFSHeader(header8)) {
            this.fs = new NPOIFSFileSystem(stream);
        } else {
            this.openOOXML(stream);
        }
    }

    public VBAMacroReader(File file) throws IOException {
        try {
            this.fs = new NPOIFSFileSystem(file);
        }
        catch (OfficeXmlFileException e) {
            this.openOOXML(new FileInputStream(file));
        }
    }

    public VBAMacroReader(NPOIFSFileSystem fs) {
        this.fs = fs;
    }

    private void openOOXML(InputStream zipFile) throws IOException {
        ZipEntry zipEntry;
        ZipInputStream zis = new ZipInputStream(zipFile);
        while ((zipEntry = zis.getNextEntry()) != null) {
            if (!StringUtil.endsWithIgnoreCase(zipEntry.getName(), VBA_PROJECT_OOXML)) continue;
            try {
                this.fs = new NPOIFSFileSystem(zis);
                return;
            }
            catch (IOException e) {
                zis.close();
                throw e;
            }
        }
        zis.close();
        throw new IllegalArgumentException("No VBA project found");
    }

    @Override
    public void close() throws IOException {
        this.fs.close();
        this.fs = null;
    }

    public Map<String, String> readMacros() throws IOException {
        ModuleMap modules = new ModuleMap();
        this.findMacros(this.fs.getRoot(), modules);
        HashMap<String, String> moduleSources = new HashMap<String, String>();
        for (Map.Entry entry : modules.entrySet()) {
            Module module = (Module)entry.getValue();
            if (module.buf == null || module.buf.length <= 0) continue;
            moduleSources.put((String)entry.getKey(), new String(module.buf, modules.charset));
        }
        return moduleSources;
    }

    protected void findMacros(DirectoryNode dir, ModuleMap modules) throws IOException {
        if (VBA_PROJECT_POIFS.equalsIgnoreCase(dir.getName())) {
            this.readMacros(dir, modules);
        } else {
            for (Entry child : dir) {
                if (!(child instanceof DirectoryNode)) continue;
                this.findMacros((DirectoryNode)child, modules);
            }
        }
    }

    private static String readString(InputStream stream, int length, Charset charset) throws IOException {
        byte[] buffer = new byte[length];
        int count = stream.read(buffer);
        return new String(buffer, 0, count, charset);
    }

    private static void trySkip(InputStream in, long n) throws IOException {
        long skippedBytes = in.skip(n);
        if (skippedBytes != n) {
            throw new IOException("Skipped only " + skippedBytes + " while trying to skip " + n + " bytes. " + " This should never happen.");
        }
    }

    protected void readMacros(DirectoryNode macroDir, ModuleMap modules) throws IOException {
        for (Entry entry : macroDir) {
            InputStream in;
            if (!(entry instanceof DocumentNode)) continue;
            String name = entry.getName();
            DocumentNode document = (DocumentNode)entry;
            DocumentInputStream dis = new DocumentInputStream(document);
            if ("dir".equalsIgnoreCase(name)) {
                int id;
                RLEDecompressingInputStream in2 = new RLEDecompressingInputStream(dis);
                String streamName = null;
                block7: while ((id = in2.readShort()) != -1 && id != 16) {
                    int len = in2.readInt();
                    switch (id) {
                        case 9: {
                            VBAMacroReader.trySkip(in2, 6L);
                            continue block7;
                        }
                        case 3: {
                            int codepage = in2.readShort();
                            modules.charset = Charset.forName("Cp" + codepage);
                            continue block7;
                        }
                        case 26: {
                            streamName = VBAMacroReader.readString(in2, len, modules.charset);
                            continue block7;
                        }
                        case 49: {
                            int moduleOffset = in2.readInt();
                            Module module = (Module)modules.get(streamName);
                            if (module != null) {
                                ByteArrayOutputStream out = new ByteArrayOutputStream();
                                RLEDecompressingInputStream stream = new RLEDecompressingInputStream(new ByteArrayInputStream(module.buf, moduleOffset, module.buf.length - moduleOffset));
                                IOUtils.copy(stream, out);
                                stream.close();
                                out.close();
                                module.buf = out.toByteArray();
                                continue block7;
                            }
                            module = new Module();
                            module.offset = moduleOffset;
                            modules.put(streamName, module);
                            continue block7;
                        }
                    }
                    VBAMacroReader.trySkip(in2, len);
                }
                in2.close();
                continue;
            }
            if (StringUtil.startsWithIgnoreCase(name, "__SRP") || StringUtil.startsWithIgnoreCase(name, "_VBA_PROJECT")) continue;
            Module module = (Module)modules.get(name);
            if (module == null) {
                module = new Module();
                modules.put(name, module);
                in = dis;
            } else {
                dis.skip(module.offset.intValue());
                in = new RLEDecompressingInputStream(dis);
            }
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            IOUtils.copy(in, out);
            in.close();
            out.close();
            module.buf = out.toByteArray();
        }
    }

    protected static class ModuleMap
    extends HashMap<String, Module> {
        Charset charset = Charset.forName("Cp1252");

        protected ModuleMap() {
        }
    }

    protected static class Module {
        Integer offset;
        byte[] buf;

        protected Module() {
        }
    }
}

