/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.util;

import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public final class CellUtil {
    public static final String ALIGNMENT = "alignment";
    public static final String BORDER_BOTTOM = "borderBottom";
    public static final String BORDER_LEFT = "borderLeft";
    public static final String BORDER_RIGHT = "borderRight";
    public static final String BORDER_TOP = "borderTop";
    public static final String BOTTOM_BORDER_COLOR = "bottomBorderColor";
    public static final String DATA_FORMAT = "dataFormat";
    public static final String FILL_BACKGROUND_COLOR = "fillBackgroundColor";
    public static final String FILL_FOREGROUND_COLOR = "fillForegroundColor";
    public static final String FILL_PATTERN = "fillPattern";
    public static final String FONT = "font";
    public static final String HIDDEN = "hidden";
    public static final String INDENTION = "indention";
    public static final String LEFT_BORDER_COLOR = "leftBorderColor";
    public static final String LOCKED = "locked";
    public static final String RIGHT_BORDER_COLOR = "rightBorderColor";
    public static final String ROTATION = "rotation";
    public static final String TOP_BORDER_COLOR = "topBorderColor";
    public static final String VERTICAL_ALIGNMENT = "verticalAlignment";
    public static final String WRAP_TEXT = "wrapText";
    private static UnicodeMapping[] unicodeMappings = new UnicodeMapping[]{CellUtil.um("alpha", "\u03b1"), CellUtil.um("beta", "\u03b2"), CellUtil.um("gamma", "\u03b3"), CellUtil.um("delta", "\u03b4"), CellUtil.um("epsilon", "\u03b5"), CellUtil.um("zeta", "\u03b6"), CellUtil.um("eta", "\u03b7"), CellUtil.um("theta", "\u03b8"), CellUtil.um("iota", "\u03b9"), CellUtil.um("kappa", "\u03ba"), CellUtil.um("lambda", "\u03bb"), CellUtil.um("mu", "\u03bc"), CellUtil.um("nu", "\u03bd"), CellUtil.um("xi", "\u03be"), CellUtil.um("omicron", "\u03bf")};

    private CellUtil() {
    }

    public static Row getRow(int rowIndex, Sheet sheet) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            row = sheet.createRow(rowIndex);
        }
        return row;
    }

    public static Cell getCell(Row row, int columnIndex) {
        Cell cell = row.getCell(columnIndex);
        if (cell == null) {
            cell = row.createCell(columnIndex);
        }
        return cell;
    }

    public static Cell createCell(Row row, int column, String value, CellStyle style) {
        Cell cell = CellUtil.getCell(row, column);
        cell.setCellValue(cell.getRow().getSheet().getWorkbook().getCreationHelper().createRichTextString(value));
        if (style != null) {
            cell.setCellStyle(style);
        }
        return cell;
    }

    public static Cell createCell(Row row, int column, String value) {
        return CellUtil.createCell(row, column, value, null);
    }

    public static void setAlignment(Cell cell, Workbook workbook, short align) {
        CellUtil.setAlignment(cell, align);
    }

    public static void setAlignment(Cell cell, short align) {
        CellUtil.setCellStyleProperty(cell, ALIGNMENT, align);
    }

    public static void setFont(Cell cell, Workbook workbook, Font font) {
        CellUtil.setFont(cell, font);
    }

    public static void setFont(Cell cell, Font font) {
        short fontIndex;
        Workbook wb = cell.getSheet().getWorkbook();
        if (!wb.getFontAt(fontIndex = font.getIndex()).equals(font)) {
            throw new IllegalArgumentException("Font does not belong to this workbook");
        }
        CellUtil.setCellStyleProperty(cell, FONT, fontIndex);
    }

    public static void setCellStyleProperties(Cell cell, Map<String, Object> properties) {
        Workbook workbook = cell.getSheet().getWorkbook();
        CellStyle originalStyle = cell.getCellStyle();
        CellStyle newStyle = null;
        Map<String, Object> values = CellUtil.getFormatProperties(originalStyle);
        values.putAll(properties);
        int numberCellStyles = workbook.getNumCellStyles();
        for (int i = 0; i < numberCellStyles; ++i) {
            CellStyle wbStyle = workbook.getCellStyleAt(i);
            Map<String, Object> wbStyleMap = CellUtil.getFormatProperties(wbStyle);
            if (!((Object)wbStyleMap).equals(values)) continue;
            newStyle = wbStyle;
            break;
        }
        if (newStyle == null) {
            newStyle = workbook.createCellStyle();
            CellUtil.setFormatProperties(newStyle, workbook, values);
        }
        cell.setCellStyle(newStyle);
    }

    public static void setCellStyleProperty(Cell cell, Workbook workbook, String propertyName, Object propertyValue) {
        CellUtil.setCellStyleProperty(cell, propertyName, propertyValue);
    }

    public static void setCellStyleProperty(Cell cell, String propertyName, Object propertyValue) {
        Map<String, Object> property = Collections.singletonMap(propertyName, propertyValue);
        CellUtil.setCellStyleProperties(cell, property);
    }

    private static Map<String, Object> getFormatProperties(CellStyle style) {
        HashMap<String, Object> properties = new HashMap<String, Object>();
        CellUtil.putShort(properties, ALIGNMENT, style.getAlignment());
        CellUtil.putBorderStyle(properties, BORDER_BOTTOM, style.getBorderBottom());
        CellUtil.putBorderStyle(properties, BORDER_LEFT, style.getBorderLeft());
        CellUtil.putBorderStyle(properties, BORDER_RIGHT, style.getBorderRight());
        CellUtil.putBorderStyle(properties, BORDER_TOP, style.getBorderTop());
        CellUtil.putShort(properties, BOTTOM_BORDER_COLOR, style.getBottomBorderColor());
        CellUtil.putShort(properties, DATA_FORMAT, style.getDataFormat());
        CellUtil.putShort(properties, FILL_BACKGROUND_COLOR, style.getFillBackgroundColor());
        CellUtil.putShort(properties, FILL_FOREGROUND_COLOR, style.getFillForegroundColor());
        CellUtil.putShort(properties, FILL_PATTERN, style.getFillPattern());
        CellUtil.putShort(properties, FONT, style.getFontIndex());
        CellUtil.putBoolean(properties, HIDDEN, style.getHidden());
        CellUtil.putShort(properties, INDENTION, style.getIndention());
        CellUtil.putShort(properties, LEFT_BORDER_COLOR, style.getLeftBorderColor());
        CellUtil.putBoolean(properties, LOCKED, style.getLocked());
        CellUtil.putShort(properties, RIGHT_BORDER_COLOR, style.getRightBorderColor());
        CellUtil.putShort(properties, ROTATION, style.getRotation());
        CellUtil.putShort(properties, TOP_BORDER_COLOR, style.getTopBorderColor());
        CellUtil.putShort(properties, VERTICAL_ALIGNMENT, style.getVerticalAlignment());
        CellUtil.putBoolean(properties, WRAP_TEXT, style.getWrapText());
        return properties;
    }

    private static void setFormatProperties(CellStyle style, Workbook workbook, Map<String, Object> properties) {
        style.setAlignment(CellUtil.getShort(properties, ALIGNMENT));
        style.setBorderBottom(CellUtil.getBorderStyle(properties, BORDER_BOTTOM));
        style.setBorderLeft(CellUtil.getBorderStyle(properties, BORDER_LEFT));
        style.setBorderRight(CellUtil.getBorderStyle(properties, BORDER_RIGHT));
        style.setBorderTop(CellUtil.getBorderStyle(properties, BORDER_TOP));
        style.setBottomBorderColor(CellUtil.getShort(properties, BOTTOM_BORDER_COLOR));
        style.setDataFormat(CellUtil.getShort(properties, DATA_FORMAT));
        style.setFillBackgroundColor(CellUtil.getShort(properties, FILL_BACKGROUND_COLOR));
        style.setFillForegroundColor(CellUtil.getShort(properties, FILL_FOREGROUND_COLOR));
        style.setFillPattern(CellUtil.getShort(properties, FILL_PATTERN));
        style.setFont(workbook.getFontAt(CellUtil.getShort(properties, FONT)));
        style.setHidden(CellUtil.getBoolean(properties, HIDDEN));
        style.setIndention(CellUtil.getShort(properties, INDENTION));
        style.setLeftBorderColor(CellUtil.getShort(properties, LEFT_BORDER_COLOR));
        style.setLocked(CellUtil.getBoolean(properties, LOCKED));
        style.setRightBorderColor(CellUtil.getShort(properties, RIGHT_BORDER_COLOR));
        style.setRotation(CellUtil.getShort(properties, ROTATION));
        style.setTopBorderColor(CellUtil.getShort(properties, TOP_BORDER_COLOR));
        style.setVerticalAlignment(CellUtil.getShort(properties, VERTICAL_ALIGNMENT));
        style.setWrapText(CellUtil.getBoolean(properties, WRAP_TEXT));
    }

    private static short getShort(Map<String, Object> properties, String name) {
        Object value = properties.get(name);
        if (value instanceof Short) {
            return (Short)value;
        }
        return 0;
    }

    private static BorderStyle getBorderStyle(Map<String, Object> properties, String name) {
        BorderStyle border;
        Object value = properties.get(name);
        if (value instanceof BorderStyle) {
            border = (BorderStyle)((Object)value);
        } else if (value instanceof Short) {
            short code = (Short)value;
            border = BorderStyle.valueOf(code);
        } else {
            throw new RuntimeException("Unexpected border style class. Must be BorderStyle or Short (deprecated)");
        }
        return border != null ? border : BorderStyle.NONE;
    }

    private static boolean getBoolean(Map<String, Object> properties, String name) {
        Object value = properties.get(name);
        if (value instanceof Boolean) {
            return (Boolean)value;
        }
        return false;
    }

    private static void putShort(Map<String, Object> properties, String name, short value) {
        properties.put(name, value);
    }

    private static void putBorderStyle(Map<String, Object> properties, String name, BorderStyle border) {
        properties.put(name, (Object)border);
    }

    private static void putBoolean(Map<String, Object> properties, String name, boolean value) {
        properties.put(name, value);
    }

    public static Cell translateUnicodeValues(Cell cell) {
        String s = cell.getRichStringCellValue().getString();
        boolean foundUnicode = false;
        String lowerCaseStr = s.toLowerCase(Locale.ROOT);
        for (UnicodeMapping entry : unicodeMappings) {
            String key = entry.entityName;
            if (!lowerCaseStr.contains(key)) continue;
            s = s.replaceAll(key, entry.resolvedValue);
            foundUnicode = true;
        }
        if (foundUnicode) {
            cell.setCellValue(cell.getRow().getSheet().getWorkbook().getCreationHelper().createRichTextString(s));
        }
        return cell;
    }

    private static UnicodeMapping um(String entityName, String resolvedValue) {
        return new UnicodeMapping(entityName, resolvedValue);
    }

    private static final class UnicodeMapping {
        public final String entityName;
        public final String resolvedValue;

        public UnicodeMapping(String pEntityName, String pResolvedValue) {
            this.entityName = "&" + pEntityName + ";";
            this.resolvedValue = pResolvedValue;
        }
    }
}

