/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.core.store.db.sql.distributed.lock;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.seata.common.loader.EnhancedServiceLoader;
import org.apache.seata.common.loader.EnhancedServiceNotFoundException;
import org.apache.seata.core.store.db.sql.distributed.lock.DistributedLockSql;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DistributedLockSqlFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(DistributedLockSqlFactory.class);
    protected static Map<String, DistributedLockSql> distributedLockSqlCache = new ConcurrentHashMap<String, DistributedLockSql>(4);

    public static DistributedLockSql getDistributedLogStoreSql(String dbType) {
        return distributedLockSqlCache.computeIfAbsent(dbType, method -> {
            try {
                return EnhancedServiceLoader.load(DistributedLockSql.class, dbType);
            }
            catch (EnhancedServiceNotFoundException ex) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Can't special implementation of DistributedLockSql for {}", (Object)dbType);
                }
                return EnhancedServiceLoader.load(DistributedLockSql.class, "default");
            }
        });
    }
}

