/*
 * Decompiled with CFR 0.152.
 */
package org.apache.seata.discovery.registry;

import java.net.InetSocketAddress;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import org.apache.seata.config.ConfigurationFactory;

public interface RegistryService<T> {
    public static final String PREFIX_SERVICE_MAPPING = "vgroupMapping.";
    public static final String PREFIX_SERVICE_ROOT = "service";
    public static final String CONFIG_SPLIT_CHAR = ".";
    public static final Set<String> SERVICE_GROUP_NAME = new HashSet<String>();
    public static final Map<String, List<InetSocketAddress>> CURRENT_ADDRESS_MAP = new ConcurrentHashMap<String, List<InetSocketAddress>>();

    public void register(InetSocketAddress var1) throws Exception;

    public void unregister(InetSocketAddress var1) throws Exception;

    public void subscribe(String var1, T var2) throws Exception;

    public void unsubscribe(String var1, T var2) throws Exception;

    public List<InetSocketAddress> lookup(String var1) throws Exception;

    public void close() throws Exception;

    default public String getServiceGroup(String key) {
        key = "service.vgroupMapping." + key;
        if (!SERVICE_GROUP_NAME.contains(key)) {
            SERVICE_GROUP_NAME.add(key);
        }
        return ConfigurationFactory.getInstance().getConfig(key);
    }

    default public List<InetSocketAddress> aliveLookup(String transactionServiceGroup) {
        return CURRENT_ADDRESS_MAP.computeIfAbsent(this.getServiceGroup(transactionServiceGroup), k -> new ArrayList());
    }

    default public List<InetSocketAddress> refreshAliveLookup(String transactionServiceGroup, List<InetSocketAddress> aliveAddress) {
        return CURRENT_ADDRESS_MAP.put(this.getServiceGroup(transactionServiceGroup), aliveAddress);
    }

    default public void removeOfflineAddressesIfNecessary(String clusterName, Collection<InetSocketAddress> newAddressed) {
        List currentAddresses = CURRENT_ADDRESS_MAP.getOrDefault(clusterName, Collections.emptyList());
        List inetSocketAddresses = currentAddresses.stream().filter(newAddressed::contains).collect(Collectors.toList());
        CURRENT_ADDRESS_MAP.put(clusterName, inetSocketAddresses);
    }
}

