/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.core;

import com.google.common.base.Optional;
import java.beans.ConstructorProperties;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import org.apache.shardingsphere.api.hint.HintManager;
import org.apache.shardingsphere.core.constant.properties.ShardingProperties;
import org.apache.shardingsphere.core.constant.properties.ShardingPropertiesConstant;
import org.apache.shardingsphere.core.metadata.ShardingMetaData;
import org.apache.shardingsphere.core.optimize.api.statement.OptimizedStatement;
import org.apache.shardingsphere.core.rewrite.SQLRewriteEngine;
import org.apache.shardingsphere.core.route.RouteUnit;
import org.apache.shardingsphere.core.route.SQLLogger;
import org.apache.shardingsphere.core.route.SQLRouteResult;
import org.apache.shardingsphere.core.route.SQLUnit;
import org.apache.shardingsphere.core.route.hook.SPIRoutingHook;
import org.apache.shardingsphere.core.route.type.RoutingUnit;
import org.apache.shardingsphere.core.route.type.TableUnit;
import org.apache.shardingsphere.core.rule.BindingTableRule;
import org.apache.shardingsphere.core.rule.ShardingRule;

public abstract class BaseShardingEngine {
    private final ShardingRule shardingRule;
    private final ShardingProperties shardingProperties;
    private final ShardingMetaData metaData;
    private final SPIRoutingHook routingHook = new SPIRoutingHook();

    public SQLRouteResult shard(String sql, List<Object> parameters) {
        List<Object> clonedParameters = this.cloneParameters(parameters);
        SQLRouteResult result = this.executeRoute(sql, clonedParameters);
        result.getRouteUnits().addAll(HintManager.isDatabaseShardingOnly() ? this.convert(sql, clonedParameters, result) : this.rewriteAndConvert(sql, clonedParameters, result));
        if (((Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SHOW)).booleanValue()) {
            boolean showSimple = (Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.SQL_SIMPLE);
            SQLLogger.logSQL((String)sql, (boolean)showSimple, (OptimizedStatement)result.getOptimizedStatement(), (Collection)result.getRouteUnits());
        }
        return result;
    }

    protected abstract List<Object> cloneParameters(List<Object> var1);

    protected abstract SQLRouteResult route(String var1, List<Object> var2);

    private SQLRouteResult executeRoute(String sql, List<Object> clonedParameters) {
        this.routingHook.start(sql);
        try {
            SQLRouteResult result = this.route(sql, clonedParameters);
            this.routingHook.finishSuccess(result, this.metaData.getTable());
            return result;
        }
        catch (Exception ex) {
            this.routingHook.finishFailure(ex);
            throw ex;
        }
    }

    private Collection<RouteUnit> convert(String sql, List<Object> parameters, SQLRouteResult sqlRouteResult) {
        LinkedHashSet<RouteUnit> result = new LinkedHashSet<RouteUnit>();
        for (RoutingUnit each : sqlRouteResult.getRoutingResult().getRoutingUnits()) {
            result.add(new RouteUnit(each.getDataSourceName(), new SQLUnit(sql, parameters)));
        }
        return result;
    }

    private Collection<RouteUnit> rewriteAndConvert(String sql, List<Object> parameters, SQLRouteResult sqlRouteResult) {
        SQLRewriteEngine rewriteEngine = new SQLRewriteEngine(this.shardingRule, sqlRouteResult, sql, parameters, sqlRouteResult.getRoutingResult().isSingleRouting(), ((Boolean)this.shardingProperties.getValue(ShardingPropertiesConstant.QUERY_WITH_CIPHER_COLUMN)).booleanValue());
        LinkedHashSet<RouteUnit> result = new LinkedHashSet<RouteUnit>();
        for (RoutingUnit each : sqlRouteResult.getRoutingResult().getRoutingUnits()) {
            result.add(new RouteUnit(each.getDataSourceName(), rewriteEngine.generateSQL(each, this.getLogicAndActualTables(each, sqlRouteResult.getOptimizedStatement().getTables().getTableNames()))));
        }
        return result;
    }

    private Map<String, String> getLogicAndActualTables(RoutingUnit routingUnit, Collection<String> parsedTableNames) {
        HashMap<String, String> result = new HashMap<String, String>();
        for (TableUnit each : routingUnit.getTableUnits()) {
            String logicTableName = each.getLogicTableName().toLowerCase();
            result.put(logicTableName, each.getActualTableName());
            result.putAll(this.getLogicAndActualTablesFromBindingTable(routingUnit.getMasterSlaveLogicDataSourceName(), each, parsedTableNames));
        }
        return result;
    }

    private Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, TableUnit tableUnit, Collection<String> parsedTableNames) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        Optional bindingTableRule = this.shardingRule.findBindingTableRule(tableUnit.getLogicTableName());
        if (bindingTableRule.isPresent()) {
            result.putAll(this.getLogicAndActualTablesFromBindingTable(dataSourceName, tableUnit, parsedTableNames, (BindingTableRule)bindingTableRule.get()));
        }
        return result;
    }

    private Map<String, String> getLogicAndActualTablesFromBindingTable(String dataSourceName, TableUnit tableUnit, Collection<String> parsedTableNames, BindingTableRule bindingTableRule) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (String each : parsedTableNames) {
            String tableName = each.toLowerCase();
            if (tableName.equals(tableUnit.getLogicTableName().toLowerCase()) || !bindingTableRule.hasLogicTable(tableName)) continue;
            result.put(tableName, bindingTableRule.getBindingActualTable(dataSourceName, tableName, tableUnit.getActualTableName()));
        }
        return result;
    }

    @ConstructorProperties(value={"shardingRule", "shardingProperties", "metaData"})
    public BaseShardingEngine(ShardingRule shardingRule, ShardingProperties shardingProperties, ShardingMetaData metaData) {
        this.shardingRule = shardingRule;
        this.shardingProperties = shardingProperties;
        this.metaData = metaData;
    }
}

