/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.provider.database;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.authority.model.AuthorityRegistry;
import org.apache.shardingsphere.authority.provider.database.builder.DatabasePrivilegeBuilder;
import org.apache.shardingsphere.authority.registry.UserPrivilegeMapAuthorityRegistry;
import org.apache.shardingsphere.authority.spi.AuthorityProviderAlgorithm;
import org.apache.shardingsphere.infra.metadata.database.ShardingSphereDatabase;
import org.apache.shardingsphere.infra.metadata.user.ShardingSphereUser;

public final class DatabasePermittedPrivilegesProviderAlgorithm
implements AuthorityProviderAlgorithm {
    public static final String PROP_USER_DATABASE_MAPPINGS = "user-database-mappings";
    private Properties props;

    public void init(Properties props) {
        this.props = props;
    }

    public AuthorityRegistry buildAuthorityRegistry(Map<String, ShardingSphereDatabase> databases, Collection<ShardingSphereUser> users) {
        return new UserPrivilegeMapAuthorityRegistry(DatabasePrivilegeBuilder.build(users, this.props));
    }

    public String getType() {
        return "DATABASE_PERMITTED";
    }

    public Collection<String> getTypeAliases() {
        return Collections.singleton("SCHEMA_PRIVILEGES_PERMITTED");
    }

    @Generated
    public Properties getProps() {
        return this.props;
    }
}

