/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.authority.yaml.swapper;

import java.util.Collection;
import org.apache.shardingsphere.authority.config.AuthorityRuleConfiguration;
import org.apache.shardingsphere.authority.rule.builder.DefaultAuthorityRuleConfigurationBuilder;
import org.apache.shardingsphere.authority.yaml.config.YamlAuthorityRuleConfiguration;
import org.apache.shardingsphere.infra.config.algorithm.AlgorithmConfiguration;
import org.apache.shardingsphere.infra.metadata.user.yaml.config.YamlUsersConfigurationConverter;
import org.apache.shardingsphere.infra.yaml.config.swapper.algorithm.YamlAlgorithmConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapper;

public final class YamlAuthorityRuleConfigurationSwapper
implements YamlRuleConfigurationSwapper<YamlAuthorityRuleConfiguration, AuthorityRuleConfiguration> {
    private final YamlAlgorithmConfigurationSwapper algorithmSwapper = new YamlAlgorithmConfigurationSwapper();

    public YamlAuthorityRuleConfiguration swapToYamlConfiguration(AuthorityRuleConfiguration data) {
        YamlAuthorityRuleConfiguration result = new YamlAuthorityRuleConfiguration();
        result.setProvider(this.algorithmSwapper.swapToYamlConfiguration(data.getProvider()));
        result.setUsers(YamlUsersConfigurationConverter.convertYamlUserConfigurations((Collection)data.getUsers()));
        return result;
    }

    public AuthorityRuleConfiguration swapToObject(YamlAuthorityRuleConfiguration yamlConfig) {
        Collection users = YamlUsersConfigurationConverter.convertShardingSphereUser(yamlConfig.getUsers());
        AlgorithmConfiguration provider = this.algorithmSwapper.swapToObject(yamlConfig.getProvider());
        if (null == provider) {
            provider = new DefaultAuthorityRuleConfigurationBuilder().build().getProvider();
        }
        return new AuthorityRuleConfiguration(users, provider);
    }

    public Class<AuthorityRuleConfiguration> getTypeClass() {
        return AuthorityRuleConfiguration.class;
    }

    public String getRuleTagName() {
        return "AUTHORITY";
    }

    public int getOrder() {
        return 500;
    }
}

