/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster;

import java.sql.SQLException;
import java.util.Map;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.InstanceContextAware;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.infra.lock.LockContext;
import org.apache.shardingsphere.infra.metadata.data.ShardingSphereDatabaseData;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.lock.ShardingSphereLockContext;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilder;
import org.apache.shardingsphere.mode.manager.ContextManagerBuilderParameter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.ClusterContextManagerCoordinator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.generator.ClusterWorkerIdGenerator;
import org.apache.shardingsphere.mode.metadata.MetaDataContexts;
import org.apache.shardingsphere.mode.metadata.MetaDataContextsFactory;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryFactory;

public final class ClusterContextManagerBuilder
implements ContextManagerBuilder {
    public ContextManager build(ContextManagerBuilderParameter parameter) throws SQLException {
        ClusterPersistRepository repository = ClusterPersistRepositoryFactory.getInstance((ClusterPersistRepositoryConfiguration)((ClusterPersistRepositoryConfiguration)parameter.getModeConfiguration().getRepository()));
        MetaDataPersistService persistService = new MetaDataPersistService((PersistRepository)repository);
        this.persistConfigurations(persistService, parameter);
        RegistryCenter registryCenter = new RegistryCenter(repository, new EventBusContext(), parameter.getInstanceMetaData(), parameter.getDatabaseConfigs());
        InstanceContext instanceContext = this.buildInstanceContext(registryCenter, parameter);
        ClusterPersistRepository persistRepository = registryCenter.getRepository();
        if (persistRepository instanceof InstanceContextAware) {
            ((InstanceContextAware)persistRepository).setInstanceContext(instanceContext);
        }
        MetaDataContexts metaDataContexts = MetaDataContextsFactory.create((MetaDataPersistService)persistService, (ContextManagerBuilderParameter)parameter, (InstanceContext)instanceContext, registryCenter.getStorageNodeStatusService().loadStorageNodes());
        this.persistMetaData(metaDataContexts);
        ContextManager result = new ContextManager(metaDataContexts, instanceContext);
        this.registerOnline(persistService, registryCenter, parameter, result);
        return result;
    }

    private void persistConfigurations(MetaDataPersistService persistService, ContextManagerBuilderParameter parameter) {
        if (!parameter.isEmpty()) {
            persistService.persistConfigurations(parameter.getDatabaseConfigs(), parameter.getGlobalRuleConfigs(), parameter.getProps());
        }
    }

    private InstanceContext buildInstanceContext(RegistryCenter registryCenter, ContextManagerBuilderParameter parameter) {
        return new InstanceContext(new ComputeNodeInstance(parameter.getInstanceMetaData()), (WorkerIdGenerator)new ClusterWorkerIdGenerator(registryCenter, parameter.getInstanceMetaData()), parameter.getModeConfiguration(), (LockContext)new ShardingSphereLockContext(registryCenter.getLockPersistService()), registryCenter.getEventBusContext());
    }

    private void persistMetaData(MetaDataContexts metaDataContexts) {
        metaDataContexts.getMetaData().getDatabases().values().forEach(each -> each.getSchemas().forEach((schemaName, schema) -> metaDataContexts.getPersistService().getDatabaseMetaDataService().persist(each.getName(), schemaName, schema)));
        for (Map.Entry entry : metaDataContexts.getShardingSphereData().getDatabaseData().entrySet()) {
            ((ShardingSphereDatabaseData)entry.getValue()).getSchemaData().forEach((schemaName, schemaData) -> metaDataContexts.getPersistService().getShardingSphereDataPersistService().persist((String)entry.getKey(), schemaName, schemaData));
        }
    }

    private void registerOnline(MetaDataPersistService persistService, RegistryCenter registryCenter, ContextManagerBuilderParameter parameter, ContextManager contextManager) {
        contextManager.getInstanceContext().getInstance().setLabels(parameter.getLabels());
        contextManager.getInstanceContext().getAllClusterInstances().addAll(registryCenter.getComputeNodeStatusService().loadAllComputeNodeInstances());
        new ClusterContextManagerCoordinator(persistService, registryCenter, contextManager);
        registryCenter.onlineInstance(contextManager.getInstanceContext().getInstance());
    }

    public String getType() {
        return "Cluster";
    }
}

