/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator;

import com.google.common.eventbus.Subscribe;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.datasource.state.DataSourceState;
import org.apache.shardingsphere.infra.datasource.state.DataSourceStateManager;
import org.apache.shardingsphere.infra.executor.sql.process.model.yaml.BatchYamlExecuteProcessContext;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.rule.ShardingSphereRule;
import org.apache.shardingsphere.infra.rule.event.DataSourceStatusChangedEvent;
import org.apache.shardingsphere.infra.rule.identifier.type.DynamicDataSourceContainedRule;
import org.apache.shardingsphere.infra.rule.identifier.type.StaticDataSourceContainedRule;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.manager.ContextManager;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.props.PropertiesChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.GlobalRuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.TableMetaDataChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.ViewMetaDataChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.DatabaseVersionChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.DatabaseDataAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.DatabaseDataDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.SchemaDataAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.SchemaDataDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.TableDataChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.KillProcessListIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.KillProcessListIdUnitCompleteEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListTriggerEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListUnitCompleteEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.StateEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.PrimaryStateChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.event.StorageNodeChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.mode.metadata.storage.event.StorageNodeDataSourceChangedEvent;
import org.apache.shardingsphere.mode.process.ShowProcessListManager;
import org.apache.shardingsphere.mode.process.lock.ShowProcessListSimpleLock;
import org.apache.shardingsphere.mode.process.node.ProcessNode;

public final class ClusterContextManagerCoordinator {
    private final MetaDataPersistService persistService;
    private final RegistryCenter registryCenter;
    private final ContextManager contextManager;

    public ClusterContextManagerCoordinator(MetaDataPersistService persistService, RegistryCenter registryCenter, ContextManager contextManager) {
        this.persistService = persistService;
        this.registryCenter = registryCenter;
        this.contextManager = contextManager;
        contextManager.getInstanceContext().getEventBusContext().register((Object)this);
        this.disableDataSources();
    }

    @Subscribe
    public synchronized void renew(DatabaseAddedEvent event) {
        this.contextManager.addDatabase(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(DatabaseDeletedEvent event) {
        this.contextManager.dropDatabase(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(SchemaAddedEvent event) {
        this.contextManager.addSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(SchemaDeletedEvent event) {
        this.contextManager.dropSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(TableMetaDataChangedEvent event) {
        this.contextManager.alterSchema(event.getDatabaseName(), event.getSchemaName(), event.getChangedTableMetaData(), null);
        this.contextManager.alterSchema(event.getDatabaseName(), event.getSchemaName(), event.getDeletedTable(), null);
    }

    @Subscribe
    public synchronized void renew(ViewMetaDataChangedEvent event) {
        this.contextManager.alterSchema(event.getDatabaseName(), event.getSchemaName(), null, event.getChangedViewMetaData());
        this.contextManager.alterSchema(event.getDatabaseName(), event.getSchemaName(), null, event.getDeletedView());
    }

    @Subscribe
    public synchronized void renew(RuleConfigurationsChangedEvent event) {
        if (this.persistService.getMetaDataVersionPersistService().isActiveVersion(event.getDatabaseName(), event.getDatabaseVersion())) {
            this.contextManager.alterRuleConfiguration(event.getDatabaseName(), event.getRuleConfigurations());
            this.disableDataSources();
        }
    }

    @Subscribe
    public synchronized void renew(DataSourceChangedEvent event) {
        if (this.persistService.getMetaDataVersionPersistService().isActiveVersion(event.getDatabaseName(), event.getDatabaseVersion())) {
            this.contextManager.alterDataSourceConfiguration(event.getDatabaseName(), event.getDataSourcePropertiesMap());
            this.disableDataSources();
        }
    }

    @Subscribe
    public synchronized void renew(StorageNodeChangedEvent event) {
        QualifiedDatabase qualifiedDatabase = event.getQualifiedDatabase();
        if (!this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(event.getQualifiedDatabase().getDatabaseName())) {
            return;
        }
        Optional<ShardingSphereRule> dynamicDataSourceRule = this.contextManager.getMetaDataContexts().getMetaData().getDatabase(qualifiedDatabase.getDatabaseName()).getRuleMetaData().getRules().stream().filter(each -> each instanceof DynamicDataSourceContainedRule).findFirst();
        if (dynamicDataSourceRule.isPresent()) {
            ((DynamicDataSourceContainedRule)dynamicDataSourceRule.get()).updateStatus((DataSourceStatusChangedEvent)new StorageNodeDataSourceChangedEvent(qualifiedDatabase, event.getDataSource()));
            return;
        }
        Optional<ShardingSphereRule> staticDataSourceRule = this.contextManager.getMetaDataContexts().getMetaData().getDatabase(qualifiedDatabase.getDatabaseName()).getRuleMetaData().getRules().stream().filter(each -> each instanceof StaticDataSourceContainedRule).findFirst();
        staticDataSourceRule.ifPresent(optional -> ((StaticDataSourceContainedRule)optional).updateStatus((DataSourceStatusChangedEvent)new StorageNodeDataSourceChangedEvent(qualifiedDatabase, event.getDataSource())));
        DataSourceStateManager.getInstance().updateState(qualifiedDatabase.getDatabaseName(), qualifiedDatabase.getDataSourceName(), DataSourceState.valueOf((String)event.getDataSource().getStatus().toUpperCase()));
    }

    @Subscribe
    public synchronized void renew(PrimaryStateChangedEvent event) {
        if (!this.contextManager.getMetaDataContexts().getMetaData().containsDatabase(event.getQualifiedDatabase().getDatabaseName())) {
            return;
        }
        QualifiedDatabase qualifiedDatabase = event.getQualifiedDatabase();
        this.contextManager.getMetaDataContexts().getMetaData().getDatabase(qualifiedDatabase.getDatabaseName()).getRuleMetaData().getRules().stream().filter(each -> each instanceof DynamicDataSourceContainedRule).forEach(each -> ((DynamicDataSourceContainedRule)each).restartHeartBeatJob((DataSourceStatusChangedEvent)new PrimaryDataSourceChangedEvent(qualifiedDatabase)));
    }

    @Subscribe
    public synchronized void renew(GlobalRuleConfigurationsChangedEvent event) {
        this.contextManager.alterGlobalRuleConfiguration(event.getRuleConfigurations());
        this.disableDataSources();
    }

    @Subscribe
    public synchronized void renew(StateEvent event) {
        this.contextManager.getInstanceContext().updateInstanceStatus(event.getInstanceId(), event.getStatus());
    }

    @Subscribe
    public synchronized void renew(LabelsEvent event) {
        this.contextManager.getInstanceContext().updateLabel(event.getInstanceId(), event.getLabels());
    }

    @Subscribe
    public synchronized void renew(InstanceOnlineEvent event) {
        this.contextManager.getInstanceContext().addComputeNodeInstance(this.registryCenter.getComputeNodeStatusService().loadComputeNodeInstance(event.getInstanceMetaData()));
    }

    @Subscribe
    public synchronized void renew(InstanceOfflineEvent event) {
        this.contextManager.getInstanceContext().deleteComputeNodeInstance(new ComputeNodeInstance(event.getInstanceMetaData()));
    }

    @Subscribe
    public synchronized void renew(DatabaseVersionChangedEvent event) {
        Map dataSourcePropertiesMap = this.persistService.getDataSourceService().load(event.getDatabaseName(), event.getActiveVersion());
        Collection ruleConfigs = this.persistService.getDatabaseRulePersistService().load(event.getDatabaseName(), event.getActiveVersion());
        this.contextManager.alterDataSourceAndRuleConfiguration(event.getDatabaseName(), dataSourcePropertiesMap, ruleConfigs);
        this.disableDataSources();
    }

    @Subscribe
    public synchronized void renew(PropertiesChangedEvent event) {
        this.contextManager.alterProperties(event.getProps());
    }

    @Subscribe
    public synchronized void renew(DatabaseDataAddedEvent event) {
        this.contextManager.addShardingSphereDatabaseData(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(DatabaseDataDeletedEvent event) {
        this.contextManager.dropShardingSphereDatabaseData(event.getDatabaseName());
    }

    @Subscribe
    public synchronized void renew(SchemaDataAddedEvent event) {
        this.contextManager.addShardingSphereSchemaData(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(SchemaDataDeletedEvent event) {
        this.contextManager.dropShardingSphereSchemaData(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public synchronized void renew(TableDataChangedEvent event) {
        this.contextManager.alterSchemaData(event.getDatabaseName(), event.getSchemaName(), event.getChangedTableData());
        this.contextManager.alterSchemaData(event.getDatabaseName(), event.getSchemaName(), event.getDeletedTable());
    }

    @Subscribe
    public synchronized void triggerShowProcessList(ShowProcessListTriggerEvent event) {
        if (!event.getInstanceId().equals(this.contextManager.getInstanceContext().getInstance().getMetaData().getId())) {
            return;
        }
        Collection processContexts = ShowProcessListManager.getInstance().getAllProcessContext();
        if (!processContexts.isEmpty()) {
            this.registryCenter.getRepository().persist(ProcessNode.getProcessListInstancePath((String)event.getProcessListId(), (String)event.getInstanceId()), YamlEngine.marshal((Object)new BatchYamlExecuteProcessContext(processContexts)));
        }
        this.registryCenter.getRepository().delete(ComputeNode.getProcessTriggerInstanceIdNodePath((String)event.getInstanceId(), (String)event.getProcessListId()));
    }

    @Subscribe
    public synchronized void killProcessListId(KillProcessListIdEvent event) throws SQLException {
        if (!event.getInstanceId().equals(this.contextManager.getInstanceContext().getInstance().getMetaData().getId())) {
            return;
        }
        Collection statements = ShowProcessListManager.getInstance().getProcessStatement(event.getProcessListId());
        for (Statement statement : statements) {
            statement.cancel();
        }
        this.registryCenter.getRepository().delete(ComputeNode.getProcessKillInstanceIdNodePath((String)event.getInstanceId(), (String)event.getProcessListId()));
    }

    @Subscribe
    public synchronized void completeUnitShowProcessList(ShowProcessListUnitCompleteEvent event) {
        ShowProcessListSimpleLock simpleLock = (ShowProcessListSimpleLock)ShowProcessListManager.getInstance().getLocks().get(event.getProcessListId());
        if (null != simpleLock) {
            simpleLock.doNotify();
        }
    }

    @Subscribe
    public synchronized void completeUnitKillProcessListId(KillProcessListIdUnitCompleteEvent event) {
        ShowProcessListSimpleLock simpleLock = (ShowProcessListSimpleLock)ShowProcessListManager.getInstance().getLocks().get(event.getProcessListId());
        if (null != simpleLock) {
            simpleLock.doNotify();
        }
    }

    private void disableDataSources() {
        this.contextManager.getMetaDataContexts().getMetaData().getDatabases().forEach((key, value) -> value.getRuleMetaData().getRules().forEach(each -> {
            if (each instanceof StaticDataSourceContainedRule) {
                this.disableDataSources((StaticDataSourceContainedRule)each);
            }
        }));
    }

    private void disableDataSources(StaticDataSourceContainedRule rule) {
        Map<String, StorageNodeDataSource> storageNodes = this.registryCenter.getStorageNodeStatusService().loadStorageNodes();
        Map<String, StorageNodeDataSource> disableDataSources = storageNodes.entrySet().stream().filter(entry -> StorageNodeStatus.isDisable((String)((StorageNodeDataSource)entry.getValue()).getStatus())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
        disableDataSources.forEach((key, value) -> rule.updateStatus((DataSourceStatusChangedEvent)new StorageNodeDataSourceChangedEvent(new QualifiedDatabase(key), value)));
    }
}

