/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator;

import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.config.database.DatabaseConfiguration;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.jdbc.JDBCInstanceMetaData;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.lock.LockPersistService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.ClusterLockPersistService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcherFactory;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.subscriber.SchemaMetaDataRegistrySubscriber;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.subscriber.ShardingSphereSchemaDataRegistrySubscriber;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.service.ComputeNodeStatusService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.subscriber.ComputeNodeStatusSubscriber;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.service.StorageNodeStatusService;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.subscriber.StorageNodeStatusSubscriber;
import org.apache.shardingsphere.mode.manager.cluster.process.subscriber.ProcessRegistrySubscriber;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class RegistryCenter {
    private final ClusterPersistRepository repository;
    private final StorageNodeStatusService storageNodeStatusService;
    private final ComputeNodeStatusService computeNodeStatusService;
    private final LockPersistService lockPersistService;
    private final EventBusContext eventBusContext;
    private final InstanceMetaData instanceMetaData;
    private final Map<String, DatabaseConfiguration> databaseConfigs;
    private final GovernanceWatcherFactory listenerFactory;

    public RegistryCenter(ClusterPersistRepository repository, EventBusContext eventBusContext, InstanceMetaData instanceMetaData, Map<String, DatabaseConfiguration> databaseConfigs) {
        this.repository = repository;
        this.eventBusContext = eventBusContext;
        this.instanceMetaData = instanceMetaData;
        this.databaseConfigs = databaseConfigs;
        this.storageNodeStatusService = new StorageNodeStatusService(repository);
        this.computeNodeStatusService = new ComputeNodeStatusService(repository);
        this.lockPersistService = new ClusterLockPersistService(repository);
        this.listenerFactory = new GovernanceWatcherFactory(repository, eventBusContext, this.getJDBCDatabaseName());
        this.createSubscribers(repository);
    }

    private String getJDBCDatabaseName() {
        return this.instanceMetaData instanceof JDBCInstanceMetaData ? (String)this.databaseConfigs.keySet().stream().findFirst().orElse(null) : null;
    }

    private void createSubscribers(ClusterPersistRepository repository) {
        new SchemaMetaDataRegistrySubscriber(repository, this.eventBusContext);
        new ComputeNodeStatusSubscriber(this, repository);
        new StorageNodeStatusSubscriber(repository, this.eventBusContext);
        new ProcessRegistrySubscriber((PersistRepository)repository, this.eventBusContext);
        new ShardingSphereSchemaDataRegistrySubscriber(repository, this.eventBusContext);
    }

    public void onlineInstance(ComputeNodeInstance computeNodeInstance) {
        this.computeNodeStatusService.registerOnline(computeNodeInstance.getMetaData());
        this.computeNodeStatusService.persistInstanceLabels(computeNodeInstance.getCurrentInstanceId(), computeNodeInstance.getLabels());
        this.listenerFactory.watchListeners();
    }

    @Generated
    public ClusterPersistRepository getRepository() {
        return this.repository;
    }

    @Generated
    public StorageNodeStatusService getStorageNodeStatusService() {
        return this.storageNodeStatusService;
    }

    @Generated
    public ComputeNodeStatusService getComputeNodeStatusService() {
        return this.computeNodeStatusService;
    }

    @Generated
    public LockPersistService getLockPersistService() {
        return this.lockPersistService;
    }

    @Generated
    public EventBusContext getEventBusContext() {
        return this.eventBusContext;
    }
}

