/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry;

import lombok.Generated;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.infra.util.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class GovernanceWatcherFactory {
    private final ClusterPersistRepository repository;
    private final EventBusContext eventBusContext;
    private final String databaseName;

    public void watchListeners() {
        for (GovernanceWatcher each : ShardingSphereServiceLoader.getServiceInstances(GovernanceWatcher.class)) {
            this.watch(each);
        }
    }

    private void watch(GovernanceWatcher<?> listener) {
        for (String each : listener.getWatchingKeys(this.databaseName)) {
            this.watch(each, listener);
        }
    }

    private void watch(String watchingKey, GovernanceWatcher<?> listener) {
        this.repository.watch(watchingKey, dataChangedEventListener -> {
            if (listener.getWatchingTypes().contains(dataChangedEventListener.getType())) {
                listener.createGovernanceEvent(dataChangedEventListener).ifPresent(arg_0 -> ((EventBusContext)this.eventBusContext).post(arg_0));
            }
        }, null);
    }

    @Generated
    public GovernanceWatcherFactory(ClusterPersistRepository repository, EventBusContext eventBusContext, String databaseName) {
        this.repository = repository;
        this.eventBusContext = eventBusContext;
        this.databaseName = databaseName;
    }

    static {
        ShardingSphereServiceLoader.register(GovernanceWatcher.class);
    }
}

