/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data;

import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.data.pojo.YamlShardingSphereTableData;
import org.apache.shardingsphere.infra.yaml.data.swapper.YamlShardingSphereTableDataSwapper;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.DatabaseDataAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.DatabaseDataDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.SchemaDataAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.SchemaDataDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.data.event.TableDataChangedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.ShardingSphereDataNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class ShardingSphereDataChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys(String databaseName) {
        return Collections.singleton(ShardingSphereDataNode.getShardingSphereDataNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        if (this.isDatabaseChanged(event)) {
            return this.createDatabaseChangedEvent(event);
        }
        if (this.isSchemaChanged(event)) {
            return this.createSchemaChangedEvent(event);
        }
        if (this.isSchemaDataChanged(event)) {
            return this.createSchemaDataChangedEvent(event);
        }
        return Optional.empty();
    }

    private boolean isDatabaseChanged(DataChangedEvent event) {
        return ShardingSphereDataNode.getDatabaseName((String)event.getKey()).isPresent();
    }

    private boolean isSchemaChanged(DataChangedEvent event) {
        return ShardingSphereDataNode.getDatabaseNameByDatabasePath((String)event.getKey()).isPresent() && ShardingSphereDataNode.getSchemaName((String)event.getKey()).isPresent();
    }

    private boolean isSchemaDataChanged(DataChangedEvent event) {
        Optional databaseName = ShardingSphereDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Optional schemaName = ShardingSphereDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        Optional tableName = ShardingSphereDataNode.getTableName((String)event.getKey());
        return databaseName.isPresent() && schemaName.isPresent() && null != event.getValue() && !event.getValue().isEmpty() && tableName.isPresent();
    }

    private Optional<GovernanceEvent> createDatabaseChangedEvent(DataChangedEvent event) {
        Optional databaseName = ShardingSphereDataNode.getDatabaseName((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new DatabaseDataAddedEvent((String)databaseName.get()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new DatabaseDataDeletedEvent((String)databaseName.get()));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createSchemaChangedEvent(DataChangedEvent event) {
        Optional databaseName = ShardingSphereDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        Optional schemaName = ShardingSphereDataNode.getSchemaName((String)event.getKey());
        Preconditions.checkState((boolean)schemaName.isPresent());
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new SchemaDataAddedEvent((String)databaseName.get(), (String)schemaName.get()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new SchemaDataDeletedEvent((String)databaseName.get(), (String)schemaName.get()));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createSchemaDataChangedEvent(DataChangedEvent event) {
        Optional databaseName = ShardingSphereDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        Optional schemaName = ShardingSphereDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        Preconditions.checkState((boolean)schemaName.isPresent());
        return Optional.of(this.doCreateSchemaDataChangedEvent(event, (String)databaseName.get(), (String)schemaName.get()));
    }

    private GovernanceEvent doCreateSchemaDataChangedEvent(DataChangedEvent event, String databaseName, String schemaName) {
        Optional tableName = ShardingSphereDataNode.getTableName((String)event.getKey());
        Preconditions.checkState((boolean)tableName.isPresent());
        return DataChangedEvent.Type.DELETED == event.getType() ? new TableDataChangedEvent(databaseName, schemaName, null, (String)tableName.get()) : new TableDataChangedEvent(databaseName, schemaName, new YamlShardingSphereTableDataSwapper().swapToObject((YamlShardingSphereTableData)YamlEngine.unmarshal((String)event.getValue(), YamlShardingSphereTableData.class)), null);
    }
}

