/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.subscriber;

import com.google.common.eventbus.Subscribe;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereTable;
import org.apache.shardingsphere.infra.metadata.database.schema.decorator.model.ShardingSphereView;
import org.apache.shardingsphere.infra.metadata.database.schema.event.AddSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.AlterSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.DropIndexEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.DropSchemaEvent;
import org.apache.shardingsphere.infra.metadata.database.schema.event.SchemaAlteredEvent;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.metadata.persist.service.DatabaseMetaDataPersistService;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class SchemaMetaDataRegistrySubscriber {
    private final DatabaseMetaDataPersistService persistService;

    public SchemaMetaDataRegistrySubscriber(ClusterPersistRepository repository, EventBusContext eventBusContext) {
        this.persistService = new DatabaseMetaDataPersistService((PersistRepository)repository);
        eventBusContext.register((Object)this);
    }

    @Subscribe
    public void update(SchemaAlteredEvent event) {
        String databaseName = event.getDatabaseName();
        String schemaName = event.getSchemaName();
        Map<String, ShardingSphereTable> tables = event.getAlteredTables().stream().collect(Collectors.toMap(ShardingSphereTable::getName, table -> table));
        Map<String, ShardingSphereView> views = event.getAlteredViews().stream().collect(Collectors.toMap(ShardingSphereView::getName, view -> view));
        this.persistService.getTableMetaDataPersistService().persist(databaseName, schemaName, tables);
        this.persistService.getViewMetaDataPersistService().persist(databaseName, schemaName, views);
        event.getDroppedTables().forEach(each -> this.persistService.getTableMetaDataPersistService().delete(databaseName, schemaName, each));
        event.getDroppedViews().forEach(each -> this.persistService.getViewMetaDataPersistService().delete(databaseName, schemaName, each));
    }

    @Subscribe
    public void addSchema(AddSchemaEvent event) {
        this.persistService.addSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public void alterSchema(AlterSchemaEvent event) {
        this.persistService.persist(event.getDatabaseName(), event.getRenameSchemaName(), event.getSchema());
        this.persistService.getViewMetaDataPersistService().persist(event.getDatabaseName(), event.getRenameSchemaName(), event.getSchema().getViews());
        this.persistService.dropSchema(event.getDatabaseName(), event.getSchemaName());
    }

    @Subscribe
    public void dropSchema(DropSchemaEvent event) {
        event.getSchemaNames().forEach(each -> this.persistService.dropSchema(event.getDatabaseName(), each));
    }

    @Subscribe
    public void dropIndex(DropIndexEvent event) {
        event.getSchemaAlteredEvents().forEach(this::update);
    }
}

