/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.watcher;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.apache.shardingsphere.infra.config.rule.RuleConfiguration;
import org.apache.shardingsphere.infra.datasource.props.DataSourceProperties;
import org.apache.shardingsphere.infra.metadata.database.schema.builder.SystemSchemaBuilderRule;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.infra.yaml.config.swapper.resource.YamlDataSourceConfigurationSwapper;
import org.apache.shardingsphere.infra.yaml.config.swapper.rule.YamlRuleConfigurationSwapperEngine;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereTable;
import org.apache.shardingsphere.infra.yaml.schema.pojo.YamlShardingSphereView;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlTableSwapper;
import org.apache.shardingsphere.infra.yaml.schema.swapper.YamlViewSwapper;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.datasource.DataSourceChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.RuleConfigurationsChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.TableMetaDataChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.schema.ViewMetaDataChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.version.DatabaseVersionChangedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.DatabaseDeletedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaAddedEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.metadata.event.SchemaDeletedEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.DatabaseMetaDataNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class MetaDataChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys(String databaseName) {
        return null == databaseName ? Collections.singleton(DatabaseMetaDataNode.getMetaDataNodePath()) : Collections.singleton(DatabaseMetaDataNode.getDatabaseNamePath((String)databaseName));
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        if (this.databaseChanged(event)) {
            return this.createDatabaseChangedEvent(event);
        }
        if (this.schemaChanged(event)) {
            return this.createSchemaChangedEvent(event);
        }
        if (this.schemaMetaDataChanged(event)) {
            return this.createSchemaMetaDataChangedEvent(event);
        }
        return this.createRuleAndDataSourceChangedEvent(event);
    }

    private boolean databaseChanged(DataChangedEvent event) {
        return DatabaseMetaDataNode.getDatabaseName((String)event.getKey()).isPresent();
    }

    private boolean schemaChanged(DataChangedEvent event) {
        return DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey()).isPresent() && DatabaseMetaDataNode.getSchemaName((String)event.getKey()).isPresent();
    }

    private boolean schemaMetaDataChanged(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Optional schemaName = DatabaseMetaDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        Optional tableName = DatabaseMetaDataNode.getTableName((String)event.getKey());
        Optional viewName = DatabaseMetaDataNode.getViewName((String)event.getKey());
        return databaseName.isPresent() && schemaName.isPresent() && !Strings.isNullOrEmpty((String)event.getValue()) && (tableName.isPresent() && !SystemSchemaBuilderRule.isSystemTable((String)((String)databaseName.get()), (String)((String)tableName.get())) || viewName.isPresent());
    }

    private Optional<GovernanceEvent> createDatabaseChangedEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseName((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new DatabaseAddedEvent((String)databaseName.get()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new DatabaseDeletedEvent((String)databaseName.get()));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createSchemaChangedEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        Optional schemaName = DatabaseMetaDataNode.getSchemaName((String)event.getKey());
        Preconditions.checkState((boolean)schemaName.isPresent());
        if (DataChangedEvent.Type.ADDED == event.getType() || DataChangedEvent.Type.UPDATED == event.getType()) {
            return Optional.of(new SchemaAddedEvent((String)databaseName.get(), (String)schemaName.get()));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new SchemaDeletedEvent((String)databaseName.get(), (String)schemaName.get()));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createRuleAndDataSourceChangedEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        if (!databaseName.isPresent() || Strings.isNullOrEmpty((String)event.getValue())) {
            return Optional.empty();
        }
        if (event.getType() == DataChangedEvent.Type.UPDATED && event.getKey().equals(DatabaseMetaDataNode.getActiveVersionPath((String)((String)databaseName.get())))) {
            return Optional.of(new DatabaseVersionChangedEvent((String)databaseName.get(), event.getValue()));
        }
        Optional databaseVersion = DatabaseMetaDataNode.getVersionByDataSourcesPath((String)event.getKey());
        if (databaseVersion.isPresent() && event.getType() != DataChangedEvent.Type.DELETED) {
            return Optional.of(this.createDataSourceChangedEvent((String)databaseName.get(), (String)databaseVersion.get(), event));
        }
        databaseVersion = DatabaseMetaDataNode.getVersionByRulesPath((String)event.getKey());
        if (databaseVersion.isPresent() && event.getType() != DataChangedEvent.Type.DELETED) {
            return Optional.of(new RuleConfigurationsChangedEvent((String)databaseName.get(), (String)databaseVersion.get(), this.getRuleConfigurations(event.getValue())));
        }
        return Optional.empty();
    }

    private DataSourceChangedEvent createDataSourceChangedEvent(String databaseName, String databaseVersion, DataChangedEvent event) {
        Map yamlDataSources = (Map)YamlEngine.unmarshal((String)event.getValue(), Map.class);
        HashMap<String, DataSourceProperties> dataSourcePropertiesMap = yamlDataSources.isEmpty() ? new HashMap<String, DataSourceProperties>() : (Map)yamlDataSources.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, entry -> new YamlDataSourceConfigurationSwapper().swapToDataSourceProperties((Map)entry.getValue()), (oldValue, currentValue) -> oldValue, LinkedHashMap::new));
        return new DataSourceChangedEvent(databaseName, databaseVersion, dataSourcePropertiesMap);
    }

    private Collection<RuleConfiguration> getRuleConfigurations(String yamlContent) {
        LinkedList rules = Strings.isNullOrEmpty((String)yamlContent) ? new LinkedList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class, (boolean)true);
        return new YamlRuleConfigurationSwapperEngine().swapToRuleConfigurations(rules);
    }

    private Optional<GovernanceEvent> createSchemaMetaDataChangedEvent(DataChangedEvent event) {
        Optional databaseName = DatabaseMetaDataNode.getDatabaseNameByDatabasePath((String)event.getKey());
        Preconditions.checkState((boolean)databaseName.isPresent());
        Optional schemaName = DatabaseMetaDataNode.getSchemaNameBySchemaPath((String)event.getKey());
        Preconditions.checkState((boolean)schemaName.isPresent());
        return Optional.of(this.createSchemaMetaDataChangedEvent(event, (String)databaseName.get(), (String)schemaName.get()));
    }

    private GovernanceEvent createSchemaMetaDataChangedEvent(DataChangedEvent event, String databaseName, String schemaName) {
        Optional tableName = DatabaseMetaDataNode.getTableName((String)event.getKey());
        Optional viewName = DatabaseMetaDataNode.getViewName((String)event.getKey());
        Preconditions.checkState((tableName.isPresent() || viewName.isPresent() ? 1 : 0) != 0);
        if (tableName.isPresent()) {
            return DataChangedEvent.Type.DELETED == event.getType() ? new TableMetaDataChangedEvent(databaseName, schemaName, null, (String)tableName.get()) : new TableMetaDataChangedEvent(databaseName, schemaName, new YamlTableSwapper().swapToObject((YamlShardingSphereTable)YamlEngine.unmarshal((String)event.getValue(), YamlShardingSphereTable.class)), null);
        }
        return DataChangedEvent.Type.DELETED == event.getType() ? new ViewMetaDataChangedEvent(databaseName, schemaName, null, (String)viewName.get()) : new ViewMetaDataChangedEvent(databaseName, schemaName, new YamlViewSwapper().swapToObject((YamlShardingSphereView)YamlEngine.unmarshal((String)event.getValue(), YamlShardingSphereView.class)), null);
    }
}

