/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.service;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.ComputeNodeInstance;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataBuilderFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ComputeNodeStatusService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ComputeNodeStatusService.class);
    private final ClusterPersistRepository repository;

    public void registerOnline(InstanceMetaData instanceMetaData) {
        this.repository.persistEphemeral(ComputeNode.getOnlineInstanceNodePath((String)instanceMetaData.getId(), (InstanceType)instanceMetaData.getType()), instanceMetaData.getAttributes());
    }

    public void persistInstanceLabels(String instanceId, Collection<String> labels) {
        if (null != labels) {
            this.repository.persistEphemeral(ComputeNode.getInstanceLabelsNodePath((String)instanceId), YamlEngine.marshal(labels));
        }
    }

    public void persistInstanceWorkerId(String instanceId, Long workerId) {
        this.repository.persistEphemeral(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId), String.valueOf(workerId));
    }

    public Collection<String> loadInstanceLabels(String instanceId) {
        String yamlContent = this.repository.getDirectly(ComputeNode.getInstanceLabelsNodePath((String)instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public Collection<String> loadInstanceStatus(String instanceId) {
        String yamlContent = this.repository.getDirectly(ComputeNode.getInstanceStatusNodePath((String)instanceId));
        return Strings.isNullOrEmpty((String)yamlContent) ? new ArrayList() : (Collection)YamlEngine.unmarshal((String)yamlContent, Collection.class);
    }

    public Optional<Long> loadInstanceWorkerId(String instanceId) {
        try {
            String workerId = this.repository.getDirectly(ComputeNode.getInstanceWorkerIdNodePath((String)instanceId));
            return Strings.isNullOrEmpty((String)workerId) ? Optional.empty() : Optional.of(Long.valueOf(workerId));
        }
        catch (NumberFormatException ex) {
            log.error("Invalid worker id for instance: {}", (Object)instanceId);
            return Optional.empty();
        }
    }

    public Collection<ComputeNodeInstance> loadAllComputeNodeInstances() {
        LinkedList<ComputeNodeInstance> result = new LinkedList<ComputeNodeInstance>();
        for (InstanceType each : InstanceType.values()) {
            result.addAll(this.loadComputeNodeInstances(each));
        }
        return result;
    }

    private Collection<ComputeNodeInstance> loadComputeNodeInstances(InstanceType instanceType) {
        List onlineComputeNodes = this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)instanceType));
        return onlineComputeNodes.stream().map(each -> this.loadComputeNodeInstance(InstanceMetaDataBuilderFactory.create((String)each, (InstanceType)instanceType, (String)this.repository.getDirectly(ComputeNode.getOnlineInstanceNodePath((String)each, (InstanceType)instanceType))))).collect(Collectors.toList());
    }

    public ComputeNodeInstance loadComputeNodeInstance(InstanceMetaData instanceMetaData) {
        ComputeNodeInstance result = new ComputeNodeInstance(instanceMetaData);
        result.setLabels(this.loadInstanceLabels(instanceMetaData.getId()));
        result.switchState(this.loadInstanceStatus(instanceMetaData.getId()));
        return result;
    }

    public Set<Long> getAssignedWorkerIds() {
        LinkedHashSet<Long> result = new LinkedHashSet<Long>();
        List childrenKeys = this.repository.getChildrenKeys(ComputeNode.getInstanceWorkerIdRootNodePath());
        for (String each : childrenKeys) {
            String workerId = this.repository.getDirectly(ComputeNode.getInstanceWorkerIdNodePath((String)each));
            if (null == workerId) continue;
            result.add(Long.parseLong(workerId));
        }
        return result;
    }

    @Generated
    public ComputeNodeStatusService(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

