/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.watcher;

import com.google.common.base.Strings;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaDataBuilderFactory;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.GovernanceWatcher;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOfflineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.InstanceOnlineEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.KillProcessListIdEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.KillProcessListIdUnitCompleteEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.LabelsEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListTriggerEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.ShowProcessListUnitCompleteEvent;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.compute.event.StateEvent;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;

public final class ComputeNodeStateChangedWatcher
implements GovernanceWatcher<GovernanceEvent> {
    @Override
    public Collection<String> getWatchingKeys(String databaseName) {
        return Collections.singleton(ComputeNode.getComputeNodePath());
    }

    @Override
    public Collection<DataChangedEvent.Type> getWatchingTypes() {
        return Arrays.asList(DataChangedEvent.Type.ADDED, DataChangedEvent.Type.UPDATED, DataChangedEvent.Type.DELETED);
    }

    @Override
    public Optional<GovernanceEvent> createGovernanceEvent(DataChangedEvent event) {
        String instanceId = ComputeNode.getInstanceIdByComputeNode((String)event.getKey());
        if (!Strings.isNullOrEmpty((String)instanceId)) {
            if (event.getKey().equals(ComputeNode.getInstanceStatusNodePath((String)instanceId))) {
                ArrayList<String> status = Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList<String>() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class);
                return Optional.of(new StateEvent(instanceId, status));
            }
            if (event.getKey().equals(ComputeNode.getInstanceLabelsNodePath((String)instanceId))) {
                return Optional.of(new LabelsEvent(instanceId, Strings.isNullOrEmpty((String)event.getValue()) ? new ArrayList<String>() : (Collection)YamlEngine.unmarshal((String)event.getValue(), Collection.class)));
            }
        }
        if (event.getKey().startsWith(ComputeNode.getOnlineInstanceNodePath())) {
            return this.createInstanceEvent(event);
        }
        if (event.getKey().startsWith(ComputeNode.getProcessTriggerNodePatch())) {
            return this.createShowProcessListTriggerEvent(event);
        }
        if (event.getKey().startsWith(ComputeNode.getProcessKillNodePatch())) {
            return this.createKillProcessListIdEvent(event);
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createKillProcessListIdEvent(DataChangedEvent event) {
        Matcher matcher = ComputeNodeStateChangedWatcher.getKillProcessListIdMatcher(event);
        if (!matcher.find()) {
            return Optional.empty();
        }
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            return Optional.of(new KillProcessListIdEvent(matcher.group(1), matcher.group(2)));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new KillProcessListIdUnitCompleteEvent(matcher.group(2)));
        }
        return Optional.empty();
    }

    private Optional<GovernanceEvent> createShowProcessListTriggerEvent(DataChangedEvent event) {
        Matcher matcher = ComputeNodeStateChangedWatcher.getShowProcessTriggerMatcher(event);
        if (!matcher.find()) {
            return Optional.empty();
        }
        if (DataChangedEvent.Type.ADDED == event.getType()) {
            return Optional.of(new ShowProcessListTriggerEvent(matcher.group(1), matcher.group(2)));
        }
        if (DataChangedEvent.Type.DELETED == event.getType()) {
            return Optional.of(new ShowProcessListUnitCompleteEvent(matcher.group(2)));
        }
        return Optional.empty();
    }

    private static Matcher getShowProcessTriggerMatcher(DataChangedEvent event) {
        return Pattern.compile(ComputeNode.getProcessTriggerNodePatch() + "/([\\S]+):([\\S]+)$", 2).matcher(event.getKey());
    }

    private static Matcher getKillProcessListIdMatcher(DataChangedEvent event) {
        Pattern pattern = Pattern.compile(ComputeNode.getProcessKillNodePatch() + "/([\\S]+):([\\S]+)$", 2);
        return pattern.matcher(event.getKey());
    }

    private Optional<GovernanceEvent> createInstanceEvent(DataChangedEvent event) {
        Matcher matcher = this.matchInstanceOnlinePath(event.getKey());
        if (matcher.find()) {
            InstanceMetaData instanceMetaData = InstanceMetaDataBuilderFactory.create((String)matcher.group(2), (InstanceType)InstanceType.valueOf((String)matcher.group(1).toUpperCase()), (String)event.getValue());
            if (DataChangedEvent.Type.ADDED == event.getType()) {
                return Optional.of(new InstanceOnlineEvent(instanceMetaData));
            }
            if (DataChangedEvent.Type.DELETED == event.getType()) {
                return Optional.of(new InstanceOfflineEvent(instanceMetaData));
            }
        }
        return Optional.empty();
    }

    private Matcher matchInstanceOnlinePath(String onlineInstancePath) {
        return Pattern.compile(ComputeNode.getOnlineInstanceNodePath() + "/([\\S]+)/([\\S]+)$", 2).matcher(onlineInstancePath);
    }
}

