/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node;

import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;

public final class StorageNode {
    public static final String ROOT_NODE = "nodes";
    private static final String STORAGE_NODES = "storage_nodes";

    public static String getRootPath() {
        return String.join((CharSequence)"/", "", ROOT_NODE, STORAGE_NODES);
    }

    public static String getStorageNodesDataSourcePath(String dataSourcePath) {
        return String.join((CharSequence)"/", StorageNode.getRootPath(), dataSourcePath);
    }

    public static String getStatusPath(QualifiedDatabase database) {
        return String.join((CharSequence)"/", StorageNode.getRootPath(), database.toString());
    }

    public static Optional<QualifiedDatabase> extractQualifiedDatabase(String storageNodePath) {
        Pattern pattern = Pattern.compile(StorageNode.getRootPath() + "/(\\S+)$", 2);
        Matcher matcher = pattern.matcher(storageNodePath);
        return matcher.find() ? Optional.of(new QualifiedDatabase(matcher.group(1))) : Optional.empty();
    }

    @Generated
    private StorageNode() {
    }
}

