/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.service;

import com.google.common.base.Strings;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node.StorageNode;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class StorageNodeStatusService {
    private final ClusterPersistRepository repository;

    public Map<String, StorageNodeDataSource> loadStorageNodes() {
        List storageNodes = this.repository.getChildrenKeys(StorageNode.getRootPath());
        HashMap<String, StorageNodeDataSource> result = new HashMap<String, StorageNodeDataSource>(storageNodes.size(), 1.0f);
        storageNodes.forEach(each -> {
            String yamlContext = this.repository.getDirectly(StorageNode.getStorageNodesDataSourcePath(each));
            if (!Strings.isNullOrEmpty((String)yamlContext)) {
                result.put((String)each, (StorageNodeDataSource)YamlEngine.unmarshal((String)yamlContext, StorageNodeDataSource.class));
            }
        });
        return result;
    }

    @Generated
    public StorageNodeStatusService(ClusterPersistRepository repository) {
        this.repository = repository;
    }
}

