/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.subscriber;

import com.google.common.eventbus.Subscribe;
import org.apache.shardingsphere.infra.metadata.database.schema.QualifiedDatabase;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.infra.util.yaml.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.status.storage.node.StorageNode;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeDataSource;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeRole;
import org.apache.shardingsphere.mode.metadata.storage.StorageNodeStatus;
import org.apache.shardingsphere.mode.metadata.storage.event.DataSourceDisabledEvent;
import org.apache.shardingsphere.mode.metadata.storage.event.PrimaryDataSourceChangedEvent;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class StorageNodeStatusSubscriber {
    private final ClusterPersistRepository repository;

    public StorageNodeStatusSubscriber(ClusterPersistRepository repository, EventBusContext eventBusContext) {
        this.repository = repository;
        eventBusContext.register((Object)this);
    }

    @Subscribe
    public void update(DataSourceDisabledEvent event) {
        this.repository.persist(StorageNode.getStatusPath(new QualifiedDatabase(event.getDatabaseName(), event.getGroupName(), event.getDataSourceName())), YamlEngine.marshal((Object)event.getStorageNodeDataSource()));
    }

    @Subscribe
    public void update(PrimaryDataSourceChangedEvent event) {
        this.repository.persist(StorageNode.getStatusPath(event.getQualifiedDatabase()), YamlEngine.marshal((Object)new StorageNodeDataSource(StorageNodeRole.PRIMARY, StorageNodeStatus.ENABLED)));
    }
}

