/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.generator;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Optional;
import java.util.PriorityQueue;
import java.util.Properties;
import java.util.Set;
import lombok.Generated;
import org.apache.shardingsphere.infra.instance.metadata.InstanceMetaData;
import org.apache.shardingsphere.infra.instance.workerid.WorkerIdGenerator;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.RegistryCenter;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.exception.WorkIdAssignedException;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.workerid.node.WorkerIdNode;
import org.apache.shardingsphere.mode.repository.cluster.exception.ClusterPersistRepositoryException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class ClusterWorkerIdGenerator
implements WorkerIdGenerator {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ClusterWorkerIdGenerator.class);
    private final RegistryCenter registryCenter;
    private final InstanceMetaData instanceMetaData;
    private volatile boolean isWarned;

    public long generate(Properties props) {
        long result = this.registryCenter.getComputeNodeStatusService().loadInstanceWorkerId(this.instanceMetaData.getId()).orElseGet(this::reGenerate);
        this.checkIneffectiveConfiguration(result, props);
        return result;
    }

    private Long reGenerate() {
        Optional<Long> result;
        while (!(result = this.generateAvailableWorkerId()).isPresent()) {
        }
        Long generatedWorkId = result.get();
        this.registryCenter.getComputeNodeStatusService().persistInstanceWorkerId(this.instanceMetaData.getId(), generatedWorkId);
        return generatedWorkId;
    }

    private Optional<Long> generateAvailableWorkerId() {
        Set<Long> assignedWorkerIds = this.registryCenter.getComputeNodeStatusService().getAssignedWorkerIds();
        if (assignedWorkerIds.size() > 1024) {
            throw new WorkIdAssignedException();
        }
        ArrayList<Long> maxAvailableIds = new ArrayList<Long>(1024);
        for (int i = 0; i < 1024; ++i) {
            maxAvailableIds.add(Long.valueOf(i));
        }
        PriorityQueue priorityQueue = new PriorityQueue(maxAvailableIds);
        for (Long each : assignedWorkerIds) {
            priorityQueue.remove(each);
        }
        Long preselectedWorkerId = (Long)priorityQueue.poll();
        Preconditions.checkState((null != preselectedWorkerId ? 1 : 0) != 0, (Object)"Preselected worker-id can not be null.");
        try {
            this.registryCenter.getRepository().persistExclusiveEphemeral(WorkerIdNode.getWorkerIdGeneratorPath(preselectedWorkerId.toString()), this.instanceMetaData.getId());
            return Optional.of(preselectedWorkerId);
        }
        catch (ClusterPersistRepositoryException ignore) {
            return Optional.empty();
        }
    }

    private void checkIneffectiveConfiguration(long generatedWorkerId, Properties props) {
        if (!this.isWarned && null != props && props.containsKey("worker-id")) {
            this.isWarned = true;
            log.warn("No need to configured {} in cluster mode, system assigned {} was {}", new Object[]{"worker-id", "worker-id", generatedWorkerId});
        }
    }

    @Generated
    public ClusterWorkerIdGenerator(RegistryCenter registryCenter, InstanceMetaData instanceMetaData) {
        this.registryCenter = registryCenter;
        this.instanceMetaData = instanceMetaData;
    }
}

