/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.manager.cluster.process.subscriber;

import com.google.common.eventbus.Subscribe;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.infra.util.eventbus.EventBusContext;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.persist.PersistRepository;
import org.apache.shardingsphere.mode.process.ShowProcessListManager;
import org.apache.shardingsphere.mode.process.event.KillProcessListIdRequestEvent;
import org.apache.shardingsphere.mode.process.event.ShowProcessListRequestEvent;
import org.apache.shardingsphere.mode.process.event.ShowProcessListResponseEvent;
import org.apache.shardingsphere.mode.process.lock.ShowProcessListSimpleLock;
import org.apache.shardingsphere.mode.process.node.ProcessNode;

public final class ProcessRegistrySubscriber {
    private final PersistRepository repository;
    private final EventBusContext eventBusContext;

    public ProcessRegistrySubscriber(PersistRepository repository, EventBusContext eventBusContext) {
        this.repository = repository;
        this.eventBusContext = eventBusContext;
        eventBusContext.register((Object)this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void loadShowProcessListData(ShowProcessListRequestEvent event) {
        String processListId = new UUID(ThreadLocalRandom.current().nextLong(), ThreadLocalRandom.current().nextLong()).toString().replace("-", "");
        boolean triggerIsComplete = false;
        Collection<String> triggerPaths = this.getTriggerPaths(processListId);
        try {
            triggerPaths.forEach(each -> this.repository.persist(each, ""));
            triggerIsComplete = this.waitAllNodeDataReady(processListId, triggerPaths);
            this.sendShowProcessList(processListId);
        }
        finally {
            this.repository.delete(ProcessNode.getProcessListIdPath((String)processListId));
            if (!triggerIsComplete) {
                triggerPaths.forEach(arg_0 -> ((PersistRepository)this.repository).delete(arg_0));
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Subscribe
    public void killProcessListId(KillProcessListIdRequestEvent event) {
        String processListId = event.getProcessListId();
        boolean killProcessListIdIsComplete = false;
        Collection<String> processKillPaths = this.getProcessKillPaths(processListId);
        try {
            processKillPaths.forEach(each -> this.repository.persist(each, ""));
            killProcessListIdIsComplete = this.waitAllNodeDataReady(processListId, processKillPaths);
        }
        finally {
            if (!killProcessListIdIsComplete) {
                processKillPaths.forEach(arg_0 -> ((PersistRepository)this.repository).delete(arg_0));
            }
        }
    }

    private Collection<String> getProcessKillPaths(String processListId) {
        return Stream.of(InstanceType.values()).flatMap(each -> this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)each)).stream().map(onlinePath -> ComputeNode.getProcessKillInstanceIdNodePath((String)onlinePath, (String)processListId))).collect(Collectors.toList());
    }

    private Collection<String> getTriggerPaths(String processListId) {
        return Stream.of(InstanceType.values()).flatMap(each -> this.repository.getChildrenKeys(ComputeNode.getOnlineNodePath((InstanceType)each)).stream().map(onlinePath -> ComputeNode.getProcessTriggerInstanceIdNodePath((String)onlinePath, (String)processListId))).collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean waitAllNodeDataReady(String processListId, Collection<String> paths) {
        ShowProcessListSimpleLock simpleLock = new ShowProcessListSimpleLock();
        ShowProcessListManager.getInstance().getLocks().put(processListId, simpleLock);
        simpleLock.lock();
        try {
            while (!this.isReady(paths)) {
                if (simpleLock.awaitDefaultTime()) continue;
                boolean bl = false;
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            simpleLock.unlock();
            ShowProcessListManager.getInstance().getLocks().remove(processListId);
        }
    }

    private boolean isReady(Collection<String> paths) {
        return paths.stream().noneMatch(each -> null != this.repository.getDirectly(each));
    }

    private void sendShowProcessList(String processListId) {
        List childrenKeys = this.repository.getChildrenKeys(ProcessNode.getProcessListIdPath((String)processListId));
        LinkedList<String> batchProcessContexts = new LinkedList<String>();
        for (String each : childrenKeys) {
            batchProcessContexts.add(this.repository.getDirectly(ProcessNode.getProcessListInstancePath((String)processListId, (String)each)));
        }
        this.eventBusContext.post((Object)new ShowProcessListResponseEvent(batchProcessContexts));
    }
}

