/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper;

import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import java.io.Closeable;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import org.apache.curator.RetryPolicy;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.CuratorFrameworkFactory;
import org.apache.curator.framework.api.ACLBackgroundPathAndBytesable;
import org.apache.curator.framework.api.ACLProvider;
import org.apache.curator.framework.api.transaction.CuratorOp;
import org.apache.curator.framework.api.transaction.TransactionOp;
import org.apache.curator.framework.recipes.cache.CuratorCache;
import org.apache.curator.framework.recipes.cache.CuratorCacheListener;
import org.apache.curator.framework.recipes.cache.TreeCacheEvent;
import org.apache.curator.retry.ExponentialBackoffRetry;
import org.apache.curator.utils.CloseableUtils;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.InstanceContextAware;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.LeaderExecutionCallback;
import org.apache.shardingsphere.mode.repository.cluster.exception.ClusterPersistRepositoryException;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEventListener;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.handler.CuratorZookeeperExceptionHandler;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.listener.SessionConnectionListener;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.lock.ZookeeperInternalLockProvider;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperProperties;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.props.ZookeeperPropertyKey;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.data.ACL;
import org.apache.zookeeper.data.Stat;

public final class CuratorZookeeperRepository
implements ClusterPersistRepository,
InstanceContextAware {
    private final Map<String, CuratorCache> caches = new ConcurrentHashMap<String, CuratorCache>();
    private final CuratorFrameworkFactory.Builder builder = CuratorFrameworkFactory.builder();
    private CuratorFramework client;
    private ZookeeperInternalLockProvider internalLockProvider;

    public void init(ClusterPersistRepositoryConfiguration config) {
        ZookeeperProperties zookeeperProps = new ZookeeperProperties(config.getProps());
        this.client = this.buildCuratorClient(config, zookeeperProps);
        this.internalLockProvider = new ZookeeperInternalLockProvider(this.client);
        this.initCuratorClient(zookeeperProps);
    }

    private CuratorFramework buildCuratorClient(ClusterPersistRepositoryConfiguration config, ZookeeperProperties zookeeperProps) {
        String digest;
        int retryIntervalMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
        int maxRetries = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.MAX_RETRIES);
        int timeToLiveSeconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.TIME_TO_LIVE_SECONDS);
        int operationTimeoutMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.OPERATION_TIMEOUT_MILLISECONDS);
        this.builder.connectString(config.getServerLists()).retryPolicy((RetryPolicy)new ExponentialBackoffRetry(retryIntervalMilliseconds, maxRetries, retryIntervalMilliseconds * maxRetries)).namespace(config.getNamespace());
        if (0 != timeToLiveSeconds) {
            this.builder.sessionTimeoutMs(timeToLiveSeconds * 1000);
        }
        if (0 != operationTimeoutMilliseconds) {
            this.builder.connectionTimeoutMs(operationTimeoutMilliseconds);
        }
        if (!Strings.isNullOrEmpty((String)(digest = (String)zookeeperProps.getValue(ZookeeperPropertyKey.DIGEST)))) {
            this.builder.authorization(ZookeeperPropertyKey.DIGEST.getKey(), digest.getBytes(StandardCharsets.UTF_8)).aclProvider(new ACLProvider(){

                public List<ACL> getDefaultAcl() {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }

                public List<ACL> getAclForPath(String path) {
                    return ZooDefs.Ids.CREATOR_ALL_ACL;
                }
            });
        }
        return this.builder.build();
    }

    private void initCuratorClient(ZookeeperProperties zookeeperProps) {
        this.client.start();
        try {
            int retryIntervalMilliseconds = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.RETRY_INTERVAL_MILLISECONDS);
            int maxRetries = (Integer)zookeeperProps.getValue(ZookeeperPropertyKey.MAX_RETRIES);
            if (!this.client.blockUntilConnected(retryIntervalMilliseconds * maxRetries, TimeUnit.MILLISECONDS)) {
                this.client.close();
                throw new KeeperException.OperationTimeoutException();
            }
        }
        catch (InterruptedException | KeeperException.OperationTimeoutException ex) {
            CuratorZookeeperExceptionHandler.handleException((Exception)ex);
        }
    }

    public int getNumChildren(String key) {
        try {
            Stat stat = (Stat)this.client.checkExists().forPath(key);
            if (null != stat) {
                return stat.getNumChildren();
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
        return 0;
    }

    public void addCacheData(String cachePath) {
        CuratorCache cache = CuratorCache.build((CuratorFramework)this.client, (String)cachePath, (CuratorCache.Options[])new CuratorCache.Options[0]);
        try {
            cache.start();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
        this.caches.put(cachePath + "/", cache);
    }

    public void evictCacheData(String cachePath) {
        CuratorCache cache = this.caches.remove(cachePath + "/");
        if (null != cache) {
            cache.close();
        }
    }

    public Object getRawCache(String cachePath) {
        return this.caches.get(cachePath + "/");
    }

    public void executeInLeader(String key, LeaderExecutionCallback callback) {
    }

    public void updateInTransaction(String key, String value) {
        try {
            TransactionOp transactionOp = this.client.transactionOp();
            this.client.transaction().forOperations(new CuratorOp[]{(CuratorOp)transactionOp.check().forPath(key), (CuratorOp)transactionOp.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8))});
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public String get(String key) {
        CuratorCache cache = this.findCuratorCache(key);
        if (null == cache) {
            return this.getDirectly(key);
        }
        Optional resultInCache = cache.get(key);
        return resultInCache.map(v -> null == v.getData() ? null : new String(v.getData(), StandardCharsets.UTF_8)).orElseGet(() -> this.getDirectly(key));
    }

    private CuratorCache findCuratorCache(String key) {
        for (Map.Entry<String, CuratorCache> entry : this.caches.entrySet()) {
            if (!key.startsWith(entry.getKey())) continue;
            return entry.getValue();
        }
        return null;
    }

    public List<String> getChildrenKeys(String key) {
        try {
            List result = (List)this.client.getChildren().forPath(key);
            result.sort(Comparator.reverseOrder());
            return result;
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return Collections.emptyList();
        }
    }

    public void persist(String key, String value) {
        try {
            if (!this.isExisted(key)) {
                ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.PERSISTENT)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
            } else {
                this.update(key, value);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void update(String key, String value) {
        try {
            this.client.setData().forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public String getDirectly(String key) {
        try {
            return new String((byte[])this.client.getData().forPath(key), StandardCharsets.UTF_8);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return null;
        }
    }

    public boolean isExisted(String key) {
        try {
            return null != this.client.checkExists().forPath(key);
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return false;
        }
    }

    public void persistEphemeral(String key, String value) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void persistExclusiveEphemeral(String key, String value) {
        try {
            ((ACLBackgroundPathAndBytesable)this.client.create().creatingParentsIfNeeded().withMode(CreateMode.EPHEMERAL)).forPath(key, value.getBytes(StandardCharsets.UTF_8));
        }
        catch (Exception ex) {
            if (ex instanceof KeeperException.NodeExistsException) {
                throw new ClusterPersistRepositoryException(ex);
            }
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public void delete(String key) {
        try {
            if (this.isExisted(key)) {
                this.client.delete().deletingChildrenIfNeeded().forPath(key);
            }
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    public long getRegistryCenterTime(String key) {
        long result = 0L;
        try {
            this.persist(key, "");
            result = ((Stat)this.client.checkExists().forPath(key)).getMtime();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
        Preconditions.checkState((0L != result ? 1 : 0) != 0, (Object)"Cannot get registry center time.");
        return result;
    }

    public Object getRawClient() {
        return this.client;
    }

    public void watch(String key, DataChangedEventListener listener, Executor executor) {
        CuratorCache cache = this.caches.get(key);
        if (null == cache) {
            cache = CuratorCache.build((CuratorFramework)this.client, (String)key, (CuratorCache.Options[])new CuratorCache.Options[0]);
            this.caches.put(key, cache);
        }
        CuratorCacheListener curatorCacheListener = CuratorCacheListener.builder().forTreeCache(this.client, (framework, treeCacheListener) -> {
            DataChangedEvent.Type changedType = this.getChangedType(treeCacheListener.getType());
            if (DataChangedEvent.Type.IGNORED != changedType) {
                listener.onChange(new DataChangedEvent(treeCacheListener.getData().getPath(), new String(treeCacheListener.getData().getData(), StandardCharsets.UTF_8), changedType));
            }
        }).build();
        if (null != executor) {
            cache.listenable().addListener((Object)curatorCacheListener, executor);
        } else {
            cache.listenable().addListener((Object)curatorCacheListener);
        }
        this.start(cache);
    }

    private void start(CuratorCache cache) {
        try {
            cache.start();
        }
        catch (Exception ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
        }
    }

    private DataChangedEvent.Type getChangedType(TreeCacheEvent.Type type) {
        switch (type) {
            case NODE_ADDED: {
                return DataChangedEvent.Type.ADDED;
            }
            case NODE_UPDATED: {
                return DataChangedEvent.Type.UPDATED;
            }
            case NODE_REMOVED: {
                return DataChangedEvent.Type.DELETED;
            }
        }
        return DataChangedEvent.Type.IGNORED;
    }

    public boolean tryLock(String lockKey, long timeoutMillis) {
        return this.internalLockProvider.getInternalLock(lockKey).tryLock(timeoutMillis);
    }

    public void unlock(String lockKey) {
        this.internalLockProvider.getInternalLock(lockKey).unlock();
    }

    public void close() {
        this.caches.values().forEach(CuratorCache::close);
        this.waitForCacheClose();
        CloseableUtils.closeQuietly((Closeable)this.client);
    }

    private void waitForCacheClose() {
        try {
            Thread.sleep(500L);
        }
        catch (InterruptedException ex) {
            Thread.currentThread().interrupt();
        }
    }

    public void setInstanceContext(InstanceContext instanceContext) {
        this.client.getConnectionStateListenable().addListener((Object)new SessionConnectionListener(instanceContext, this));
    }

    public String getType() {
        return "ZooKeeper";
    }
}

