/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.mode.repository.cluster.zookeeper.listener;

import java.util.Properties;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.curator.framework.CuratorFramework;
import org.apache.curator.framework.state.ConnectionState;
import org.apache.curator.framework.state.ConnectionStateListener;
import org.apache.shardingsphere.infra.instance.InstanceContext;
import org.apache.shardingsphere.infra.instance.metadata.InstanceType;
import org.apache.shardingsphere.mode.metadata.persist.node.ComputeNode;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.zookeeper.handler.CuratorZookeeperExceptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class SessionConnectionListener
implements ConnectionStateListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SessionConnectionListener.class);
    private static final int RECONNECT_INTERVAL_SECONDS = 5;
    private final InstanceContext instanceContext;
    private final ClusterPersistRepository repository;

    public void stateChanged(CuratorFramework client, ConnectionState connectionState) {
        if (ConnectionState.LOST == connectionState) {
            boolean reRegistered;
            while (!(reRegistered = this.reRegister(client))) {
            }
            log.debug("instance re-register success instance id: {}", (Object)this.instanceContext.getInstance().getCurrentInstanceId());
        }
    }

    private boolean reRegister(CuratorFramework client) {
        try {
            if (client.getZookeeperClient().blockUntilConnectedOrTimedOut()) {
                if (this.isNeedGenerateWorkerId()) {
                    this.instanceContext.generateWorkerId(new Properties());
                }
                this.repository.persistEphemeral(ComputeNode.getOnlineInstanceNodePath((String)this.instanceContext.getInstance().getCurrentInstanceId(), (InstanceType)this.instanceContext.getInstance().getMetaData().getType()), this.instanceContext.getInstance().getMetaData().getAttributes());
                return true;
            }
            this.sleepInterval();
            return false;
        }
        catch (InterruptedException ex) {
            CuratorZookeeperExceptionHandler.handleException(ex);
            return true;
        }
    }

    private boolean isNeedGenerateWorkerId() {
        return -1L != this.instanceContext.getInstance().getWorkerId();
    }

    private void sleepInterval() {
        TimeUnit.SECONDS.sleep(5L);
    }

    @Generated
    public SessionConnectionListener(InstanceContext instanceContext, ClusterPersistRepository repository) {
        this.instanceContext = instanceContext;
        this.repository = repository;
    }
}

