/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.api.config;

import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.TableNameSchemaNameMapping;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.PipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.metadata.IdentifierName;
import org.apache.shardingsphere.data.pipeline.api.metadata.LogicTableName;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.apache.shardingsphere.infra.database.type.DatabaseTypeFactory;

public final class ImporterConfiguration {
    private final PipelineDataSourceConfiguration dataSourceConfig;
    private final Map<LogicTableName, Set<String>> shardingColumnsMap;
    private final TableNameSchemaNameMapping tableNameSchemaNameMapping;
    private final int batchSize;
    private final JobRateLimitAlgorithm rateLimitAlgorithm;
    private final int retryTimes;
    private final int concurrency;

    public Collection<String> getLogicTableNames() {
        return Collections.unmodifiableList(this.shardingColumnsMap.keySet().stream().map(IdentifierName::getLowercase).collect(Collectors.toList()));
    }

    public Set<String> getShardingColumns(String logicTableName) {
        return this.shardingColumnsMap.getOrDefault(new LogicTableName(logicTableName), Collections.emptySet());
    }

    public String getSchemaName(LogicTableName logicTableName) {
        return DatabaseTypeFactory.getInstance((String)this.dataSourceConfig.getDatabaseType().getType()).isSchemaAvailable() ? this.tableNameSchemaNameMapping.getSchemaName(logicTableName) : null;
    }

    @Generated
    public ImporterConfiguration(PipelineDataSourceConfiguration dataSourceConfig, Map<LogicTableName, Set<String>> shardingColumnsMap, TableNameSchemaNameMapping tableNameSchemaNameMapping, int batchSize, JobRateLimitAlgorithm rateLimitAlgorithm, int retryTimes, int concurrency) {
        this.dataSourceConfig = dataSourceConfig;
        this.shardingColumnsMap = shardingColumnsMap;
        this.tableNameSchemaNameMapping = tableNameSchemaNameMapping;
        this.batchSize = batchSize;
        this.rateLimitAlgorithm = rateLimitAlgorithm;
        this.retryTimes = retryTimes;
        this.concurrency = concurrency;
    }

    @Generated
    public PipelineDataSourceConfiguration getDataSourceConfig() {
        return this.dataSourceConfig;
    }

    @Generated
    public Map<LogicTableName, Set<String>> getShardingColumnsMap() {
        return this.shardingColumnsMap;
    }

    @Generated
    public TableNameSchemaNameMapping getTableNameSchemaNameMapping() {
        return this.tableNameSchemaNameMapping;
    }

    @Generated
    public int getBatchSize() {
        return this.batchSize;
    }

    @Generated
    public JobRateLimitAlgorithm getRateLimitAlgorithm() {
        return this.rateLimitAlgorithm;
    }

    @Generated
    public int getRetryTimes() {
        return this.retryTimes;
    }

    @Generated
    public int getConcurrency() {
        return this.concurrency;
    }

    @Generated
    public String toString() {
        return "ImporterConfiguration(shardingColumnsMap=" + this.getShardingColumnsMap() + ", tableNameSchemaNameMapping=" + this.getTableNameSchemaNameMapping() + ", batchSize=" + this.getBatchSize() + ", rateLimitAlgorithm=" + this.getRateLimitAlgorithm() + ", retryTimes=" + this.getRetryTimes() + ", concurrency=" + this.getConcurrency() + ")";
    }
}

