/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api;

import java.util.Properties;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.core.api.GovernanceRepositoryAPI;
import org.apache.shardingsphere.data.pipeline.core.api.impl.GovernanceRepositoryAPIImpl;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.data.pipeline.core.registry.CoordinatorRegistryCenterInitializer;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobAPIFactory;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobConfigurationAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobOperateAPI;
import org.apache.shardingsphere.elasticjob.lite.lifecycle.api.JobStatisticsAPI;
import org.apache.shardingsphere.elasticjob.reg.base.CoordinatorRegistryCenter;
import org.apache.shardingsphere.infra.config.mode.ModeConfiguration;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepositoryConfiguration;
import org.apache.shardingsphere.spi.ShardingSphereServiceLoader;
import org.apache.shardingsphere.spi.typed.TypedSPIRegistry;

public final class PipelineAPIFactory {
    public static GovernanceRepositoryAPI getGovernanceRepositoryAPI() {
        return GovernanceRepositoryAPIHolder.getInstance();
    }

    public static JobStatisticsAPI getJobStatisticsAPI() {
        return ElasticJobAPIHolder.getInstance().getJobStatisticsAPI();
    }

    public static JobConfigurationAPI getJobConfigurationAPI() {
        return ElasticJobAPIHolder.getInstance().getJobConfigurationAPI();
    }

    public static JobOperateAPI getJobOperateAPI() {
        return ElasticJobAPIHolder.getInstance().getJobOperateAPI();
    }

    public static CoordinatorRegistryCenter getRegistryCenter() {
        return RegistryCenterHolder.getInstance();
    }

    @Generated
    private PipelineAPIFactory() {
    }

    private static final class RegistryCenterHolder {
        private static volatile CoordinatorRegistryCenter instance;

        private RegistryCenterHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static CoordinatorRegistryCenter getInstance() {
            if (null != instance) return instance;
            Class<PipelineAPIFactory> clazz = PipelineAPIFactory.class;
            synchronized (PipelineAPIFactory.class) {
                if (null != instance) return instance;
                instance = RegistryCenterHolder.createRegistryCenter();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private static CoordinatorRegistryCenter createRegistryCenter() {
            CoordinatorRegistryCenterInitializer registryCenterInitializer = new CoordinatorRegistryCenterInitializer();
            ModeConfiguration modeConfig = PipelineContext.getModeConfig();
            return registryCenterInitializer.createRegistryCenter(modeConfig, "/scaling");
        }
    }

    private static final class ElasticJobAPIHolder {
        private static volatile ElasticJobAPIHolder instance;
        private final JobStatisticsAPI jobStatisticsAPI;
        private final JobConfigurationAPI jobConfigurationAPI;
        private final JobOperateAPI jobOperateAPI;

        private ElasticJobAPIHolder() {
            ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)PipelineContext.getModeConfig().getRepository();
            String namespace = repositoryConfig.getNamespace() + "/scaling";
            this.jobStatisticsAPI = JobAPIFactory.createJobStatisticsAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
            this.jobConfigurationAPI = JobAPIFactory.createJobConfigurationAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
            this.jobOperateAPI = JobAPIFactory.createJobOperateAPI((String)repositoryConfig.getServerLists(), (String)namespace, null);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static ElasticJobAPIHolder getInstance() {
            if (null != instance) return instance;
            Class<PipelineAPIFactory> clazz = PipelineAPIFactory.class;
            synchronized (PipelineAPIFactory.class) {
                if (null != instance) return instance;
                instance = new ElasticJobAPIHolder();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        @Generated
        public JobStatisticsAPI getJobStatisticsAPI() {
            return this.jobStatisticsAPI;
        }

        @Generated
        public JobConfigurationAPI getJobConfigurationAPI() {
            return this.jobConfigurationAPI;
        }

        @Generated
        public JobOperateAPI getJobOperateAPI() {
            return this.jobOperateAPI;
        }
    }

    private static final class GovernanceRepositoryAPIHolder {
        private static volatile GovernanceRepositoryAPI instance;

        private GovernanceRepositoryAPIHolder() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public static GovernanceRepositoryAPI getInstance() {
            if (null != instance) return instance;
            Class<PipelineAPIFactory> clazz = PipelineAPIFactory.class;
            synchronized (PipelineAPIFactory.class) {
                if (null != instance) return instance;
                instance = GovernanceRepositoryAPIHolder.createGovernanceRepositoryAPI();
                // ** MonitorExit[var0] (shouldn't be in output)
                return instance;
            }
        }

        private static GovernanceRepositoryAPI createGovernanceRepositoryAPI() {
            ClusterPersistRepositoryConfiguration repositoryConfig = (ClusterPersistRepositoryConfiguration)PipelineContext.getModeConfig().getRepository();
            ClusterPersistRepository repository = (ClusterPersistRepository)TypedSPIRegistry.getRegisteredService(ClusterPersistRepository.class, (String)repositoryConfig.getType(), (Properties)repositoryConfig.getProps());
            repository.init(repositoryConfig);
            return new GovernanceRepositoryAPIImpl(repository);
        }

        static {
            ShardingSphereServiceLoader.register(ClusterPersistRepository.class);
        }
    }
}

