/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.api.impl;

import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineJobAPI;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.exception.PipelineJobNotFoundException;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractPipelineJobAPIImpl
implements PipelineJobAPI {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractPipelineJobAPIImpl.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");

    public void startDisabledJob(String jobId) {
        log.info("Start disabled pipeline job {}", (Object)jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        jobConfigPOJO.setDisabled(false);
        jobConfigPOJO.getProps().remove("stop_time");
        PipelineAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
    }

    public void stop(String jobId) {
        log.info("Stop pipeline job {}", (Object)jobId);
        JobConfigurationPOJO jobConfigPOJO = this.getElasticJobConfigPOJO(jobId);
        jobConfigPOJO.setDisabled(true);
        jobConfigPOJO.getProps().setProperty("stop_time", LocalDateTime.now().format(DATE_TIME_FORMATTER));
        PipelineAPIFactory.getJobConfigurationAPI().updateJobConfiguration(jobConfigPOJO);
    }

    public void remove(String jobId) {
        log.info("Remove pipeline job {}", (Object)jobId);
        PipelineAPIFactory.getJobOperateAPI().remove(String.valueOf(jobId), null);
        PipelineAPIFactory.getGovernanceRepositoryAPI().deleteJob(jobId);
    }

    private JobConfigurationPOJO getElasticJobConfigPOJO(String jobId) {
        try {
            return PipelineAPIFactory.getJobConfigurationAPI().getJobConfiguration(jobId);
        }
        catch (NullPointerException ex) {
            throw new PipelineJobNotFoundException(String.format("Can not find pipeline job %s", jobId), jobId);
        }
    }
}

