/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.execute;

import com.google.common.collect.Sets;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.executor.AbstractLifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.core.api.PipelineAPIFactory;
import org.apache.shardingsphere.data.pipeline.core.lock.ScalingSchemaNameDistributeLock;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJob;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobSchedulerCenter;
import org.apache.shardingsphere.elasticjob.api.ElasticJob;
import org.apache.shardingsphere.elasticjob.infra.pojo.JobConfigurationPOJO;
import org.apache.shardingsphere.elasticjob.lite.api.bootstrap.impl.OneOffJobBootstrap;
import org.apache.shardingsphere.infra.eventbus.ShardingSphereEventBus;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.registry.config.event.rule.ScalingReleaseSchemaNameLockEvent;
import org.apache.shardingsphere.mode.repository.cluster.listener.DataChangedEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PipelineJobExecutor
extends AbstractLifecycleExecutor {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PipelineJobExecutor.class);
    private static final Pattern CONFIG_PATTERN = Pattern.compile("/scaling/(\\d+)/config");
    private static final Set<String> EXECUTING_JOBS = Sets.newConcurrentHashSet();

    protected void doStart() {
        this.watchGovernanceRepositoryConfiguration();
    }

    private void watchGovernanceRepositoryConfiguration() {
        PipelineAPIFactory.getGovernanceRepositoryAPI().watch("/scaling", event -> {
            Optional<JobConfigurationPOJO> jobConfigPOJOOptional = this.getJobConfigPOJO(event);
            if (!jobConfigPOJOOptional.isPresent()) {
                return;
            }
            JobConfigurationPOJO jobConfigPOJO = jobConfigPOJOOptional.get();
            if (DataChangedEvent.Type.DELETED == event.getType() || jobConfigPOJO.isDisabled()) {
                log.info("remove and stop {}", (Object)jobConfigPOJO.getJobName());
                EXECUTING_JOBS.remove(jobConfigPOJO.getJobName());
                RuleAlteredJobSchedulerCenter.stop(jobConfigPOJO.getJobName());
                JobConfiguration jobConfig = (JobConfiguration)YamlEngine.unmarshal((String)jobConfigPOJO.getJobParameter(), JobConfiguration.class, (boolean)true);
                ScalingReleaseSchemaNameLockEvent releaseLockEvent = new ScalingReleaseSchemaNameLockEvent(jobConfig.getWorkflowConfig().getSchemaName());
                ShardingSphereEventBus.getInstance().post((Object)releaseLockEvent);
                return;
            }
            switch (event.getType()) {
                case ADDED: 
                case UPDATED: {
                    JobConfiguration jobConfig = (JobConfiguration)YamlEngine.unmarshal((String)jobConfigPOJO.getJobParameter(), JobConfiguration.class, (boolean)true);
                    if (!ScalingSchemaNameDistributeLock.getInstance().tryLock(jobConfig.getWorkflowConfig().getSchemaName(), 1000L)) break;
                    this.execute(jobConfigPOJO);
                    break;
                }
            }
        });
    }

    private Optional<JobConfigurationPOJO> getJobConfigPOJO(DataChangedEvent event) {
        try {
            if (CONFIG_PATTERN.matcher(event.getKey()).matches()) {
                log.info("{} job config: {}", (Object)event.getType(), (Object)event.getKey());
                return Optional.of(YamlEngine.unmarshal((String)event.getValue(), JobConfigurationPOJO.class, (boolean)true));
            }
        }
        catch (Exception ex) {
            log.error("analyze job config pojo failed.", (Throwable)ex);
        }
        return Optional.empty();
    }

    private void execute(JobConfigurationPOJO jobConfigPOJO) {
        if (EXECUTING_JOBS.add(jobConfigPOJO.getJobName())) {
            log.info("{} added to executing jobs success", (Object)jobConfigPOJO.getJobName());
            new OneOffJobBootstrap(PipelineAPIFactory.getRegistryCenter(), (ElasticJob)new RuleAlteredJob(), jobConfigPOJO.toJobConfiguration()).execute();
        } else {
            log.info("{} added to executing jobs failed since it already exists", (Object)jobConfigPOJO.getJobName());
        }
    }

    protected void doStop() {
    }
}

