/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.channel.memory;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.AckCallback;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.ingest.channel.EmptyAckCallback;
import org.apache.shardingsphere.data.pipeline.core.util.ThreadUtil;

public final class SimpleMemoryPipelineChannel
implements PipelineChannel {
    private static final EmptyAckCallback EMPTY_ACK_CALLBACK = new EmptyAckCallback();
    private final BlockingQueue<Record> queue;
    private final AckCallback ackCallback;

    public SimpleMemoryPipelineChannel(int blockQueueSize) {
        this(blockQueueSize, EMPTY_ACK_CALLBACK);
    }

    public SimpleMemoryPipelineChannel(int blockQueueSize, AckCallback ackCallback) {
        this.queue = new ArrayBlockingQueue<Record>(blockQueueSize);
        this.ackCallback = ackCallback;
    }

    public void pushRecord(Record dataRecord) {
        try {
            this.queue.put(dataRecord);
        }
        catch (InterruptedException ex) {
            throw new RuntimeException("put " + dataRecord + " into queue failed", ex);
        }
    }

    public List<Record> fetchRecords(int batchSize, int timeoutSeconds) {
        ArrayList<Record> result = new ArrayList<Record>(batchSize);
        long start = System.currentTimeMillis();
        while (batchSize > this.queue.size() && (long)timeoutSeconds * 1000L > System.currentTimeMillis() - start) {
            ThreadUtil.sleep(100L);
        }
        this.queue.drainTo(result, batchSize);
        return result;
    }

    public void ack(List<Record> records) {
        this.ackCallback.onAck(records);
    }

    public void close() {
        this.queue.clear();
    }
}

