/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.ingest.dumper;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Optional;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.commons.lang3.concurrent.LazyInitializer;
import org.apache.shardingsphere.data.pipeline.api.config.ingest.InventoryDumperConfiguration;
import org.apache.shardingsphere.data.pipeline.api.datasource.config.impl.StandardPipelineDataSourceConfiguration;
import org.apache.shardingsphere.data.pipeline.api.executor.AbstractLifecycleExecutor;
import org.apache.shardingsphere.data.pipeline.api.ingest.channel.PipelineChannel;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.FinishedPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.IngestPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PlaceholderPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.position.PrimaryKeyPosition;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.FinishedRecord;
import org.apache.shardingsphere.data.pipeline.api.ingest.record.Record;
import org.apache.shardingsphere.data.pipeline.core.ingest.exception.IngestException;
import org.apache.shardingsphere.data.pipeline.core.metadata.loader.PipelineTableMetaDataLoader;
import org.apache.shardingsphere.data.pipeline.core.metadata.model.PipelineTableMetaData;
import org.apache.shardingsphere.data.pipeline.spi.ingest.dumper.InventoryDumper;
import org.apache.shardingsphere.data.pipeline.spi.ratelimit.JobRateLimitAlgorithm;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractInventoryDumper
extends AbstractLifecycleExecutor
implements InventoryDumper {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractInventoryDumper.class);
    private final InventoryDumperConfiguration inventoryDumperConfig;
    private final int batchSize;
    private final JobRateLimitAlgorithm rateLimitAlgorithm;
    private final LazyInitializer<PipelineTableMetaData> tableMetaDataLazyInitializer;
    private final PipelineChannel channel;
    private final DataSource dataSource;

    protected AbstractInventoryDumper(final InventoryDumperConfiguration inventoryDumperConfig, PipelineChannel channel, DataSource dataSource, final PipelineTableMetaDataLoader metaDataLoader) {
        if (!StandardPipelineDataSourceConfiguration.class.equals(inventoryDumperConfig.getDataSourceConfig().getClass())) {
            throw new UnsupportedOperationException("AbstractInventoryDumper only support StandardPipelineDataSourceConfiguration");
        }
        this.inventoryDumperConfig = inventoryDumperConfig;
        this.batchSize = inventoryDumperConfig.getBatchSize();
        this.rateLimitAlgorithm = inventoryDumperConfig.getRateLimitAlgorithm();
        this.tableMetaDataLazyInitializer = new LazyInitializer<PipelineTableMetaData>(){

            protected PipelineTableMetaData initialize() {
                return metaDataLoader.getTableMetaData(inventoryDumperConfig.getTableName());
            }
        };
        this.channel = channel;
        this.dataSource = dataSource;
    }

    protected void doStart() {
        this.dump();
    }

    private void dump() {
        String sql = this.getDumpSQL();
        IngestPosition position = this.inventoryDumperConfig.getPosition();
        log.info("inventory dump, sql={}, position={}", (Object)sql, (Object)position);
        try (Connection conn = this.dataSource.getConnection();){
            Optional<Number> maxUniqueKeyValue;
            int round = 1;
            Number startUniqueKeyValue = this.getPositionBeginValue(position) - 1L;
            while ((maxUniqueKeyValue = this.dump0(conn, sql, startUniqueKeyValue, round++)).isPresent()) {
                startUniqueKeyValue = maxUniqueKeyValue.get();
                if (this.isRunning()) continue;
                log.info("inventory dump, running is false, break");
                break;
            }
            log.info("inventory dump done, round={}, maxUniqueKeyValue={}", (Object)round, maxUniqueKeyValue);
        }
        catch (SQLException ex) {
            log.error("inventory dump, ex caught, msg={}", (Object)ex.getMessage());
            throw new IngestException(ex);
        }
        finally {
            log.info("inventory dump, before put FinishedRecord");
            this.pushRecord((Record)new FinishedRecord((IngestPosition)new FinishedPosition()));
        }
    }

    private String getDumpSQL() {
        String tableName = this.inventoryDumperConfig.getTableName();
        String primaryKey = this.inventoryDumperConfig.getPrimaryKey();
        return "SELECT * FROM " + tableName + " WHERE " + primaryKey + " > ? AND " + primaryKey + " <= ? ORDER BY " + primaryKey + " ASC LIMIT ?";
    }

    private PipelineTableMetaData getTableMetaData() {
        return (PipelineTableMetaData)this.tableMetaDataLazyInitializer.get();
    }

    /*
     * Exception decompiling
     */
    private Optional<Number> dump0(Connection conn, String sql, Number startUniqueKeyValue, int round) throws SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private long getPositionBeginValue(IngestPosition<?> position) {
        if (null == position) {
            return 0L;
        }
        if (!(position instanceof PrimaryKeyPosition)) {
            return 0L;
        }
        return ((PrimaryKeyPosition)position).getBeginValue();
    }

    private long getPositionEndValue(IngestPosition<?> position) {
        if (null == position) {
            return Integer.MAX_VALUE;
        }
        if (!(position instanceof PrimaryKeyPosition)) {
            return Integer.MAX_VALUE;
        }
        return ((PrimaryKeyPosition)position).getEndValue();
    }

    private IngestPosition<?> newPosition(ResultSet rs) throws SQLException {
        if (null == this.inventoryDumperConfig.getPrimaryKey()) {
            return new PlaceholderPosition();
        }
        return new PrimaryKeyPosition(rs.getLong(this.inventoryDumperConfig.getPrimaryKey()), ((PrimaryKeyPosition)this.inventoryDumperConfig.getPosition()).getEndValue());
    }

    protected abstract PreparedStatement createPreparedStatement(Connection var1, String var2) throws SQLException;

    protected Object readValue(ResultSet resultSet, int index) throws SQLException {
        return resultSet.getObject(index);
    }

    private void pushRecord(Record record) {
        this.channel.pushRecord(record);
    }

    protected void doStop() {
    }

    @Generated
    protected InventoryDumperConfiguration getInventoryDumperConfig() {
        return this.inventoryDumperConfig;
    }
}

