/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.job;

import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.shardingsphere.data.pipeline.api.PipelineJobAPIFactory;
import org.apache.shardingsphere.data.pipeline.api.RuleAlteredJobAPI;
import org.apache.shardingsphere.data.pipeline.api.config.rulealtered.JobConfiguration;
import org.apache.shardingsphere.data.pipeline.api.detect.RuleAlteredJobAlmostCompletedParameter;
import org.apache.shardingsphere.data.pipeline.api.pojo.JobInfo;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredContext;
import org.apache.shardingsphere.data.pipeline.scenario.rulealtered.RuleAlteredJobWorker;
import org.apache.shardingsphere.data.pipeline.spi.lock.RowBasedJobLockAlgorithm;
import org.apache.shardingsphere.data.pipeline.spi.lock.RuleBasedJobLockAlgorithm;
import org.apache.shardingsphere.elasticjob.api.ShardingContext;
import org.apache.shardingsphere.elasticjob.simple.job.SimpleJob;
import org.apache.shardingsphere.infra.yaml.engine.YamlEngine;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class FinishedCheckJob
implements SimpleJob {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FinishedCheckJob.class);
    private final RuleAlteredJobAPI ruleAlteredJobAPI = PipelineJobAPIFactory.getRuleAlteredJobAPI();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void execute(ShardingContext shardingContext) {
        List jobInfos = this.ruleAlteredJobAPI.list();
        for (JobInfo jobInfo : jobInfos) {
            if (!jobInfo.isActive()) continue;
            String jobId = jobInfo.getJobId();
            try {
                JobConfiguration jobConfig = (JobConfiguration)YamlEngine.unmarshal((String)jobInfo.getJobParameter(), JobConfiguration.class, (boolean)true);
                RuleAlteredContext ruleAlteredContext = RuleAlteredJobWorker.createRuleAlteredContext(jobConfig);
                if (null == ruleAlteredContext.getCompletionDetectAlgorithm()) {
                    log.info("completionDetector not configured, auto switch will not be enabled. You could query job progress and switch config manually with DistSQL.");
                    continue;
                }
                RuleAlteredJobAlmostCompletedParameter parameter = new RuleAlteredJobAlmostCompletedParameter(jobInfo.getShardingTotalCount(), this.ruleAlteredJobAPI.getProgress(jobConfig).values());
                if (!ruleAlteredContext.getCompletionDetectAlgorithm().isAlmostCompleted((Object)parameter)) continue;
                log.info("scaling job {} almost finished.", (Object)jobId);
                RowBasedJobLockAlgorithm sourceWritingStopAlgorithm = ruleAlteredContext.getSourceWritingStopAlgorithm();
                String schemaName = jobConfig.getWorkflowConfig().getSchemaName();
                try {
                    if (null != sourceWritingStopAlgorithm) {
                        sourceWritingStopAlgorithm.lock(schemaName, jobId + "");
                    }
                    if (!this.ruleAlteredJobAPI.isDataConsistencyCheckNeeded(jobConfig)) {
                        log.info("dataConsistencyCheckAlgorithm is not configured, data consistency check is ignored.");
                        this.ruleAlteredJobAPI.switchClusterConfiguration(jobConfig);
                        continue;
                    }
                    if (!this.dataConsistencyCheck(jobConfig)) {
                        log.error("data consistency check failed, job {}", (Object)jobId);
                        continue;
                    }
                    RuleBasedJobLockAlgorithm checkoutLockAlgorithm = ruleAlteredContext.getCheckoutLockAlgorithm();
                    this.switchClusterConfiguration(schemaName, jobConfig, checkoutLockAlgorithm);
                }
                finally {
                    if (null == sourceWritingStopAlgorithm) continue;
                    sourceWritingStopAlgorithm.releaseLock(schemaName, jobId + "");
                    continue;
                }
                log.info("job {} finished", (Object)jobId);
            }
            catch (Exception ex) {
                log.error("scaling job {} finish check failed!", (Object)jobId, (Object)ex);
            }
        }
    }

    private boolean dataConsistencyCheck(JobConfiguration jobConfig) {
        String jobId = jobConfig.getHandleConfig().getJobId();
        log.info("dataConsistencyCheck for job {}", (Object)jobId);
        Map checkResultMap = this.ruleAlteredJobAPI.dataConsistencyCheck(jobConfig);
        return this.ruleAlteredJobAPI.aggregateDataConsistencyCheckResults(jobId, checkResultMap);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void switchClusterConfiguration(String schemaName, JobConfiguration jobConfig, RuleBasedJobLockAlgorithm checkoutLockAlgorithm) {
        String jobId = jobConfig.getHandleConfig().getJobId();
        try {
            if (null != checkoutLockAlgorithm) {
                checkoutLockAlgorithm.lock(schemaName, jobId + "");
            }
            this.ruleAlteredJobAPI.switchClusterConfiguration(jobConfig);
        }
        finally {
            if (null != checkoutLockAlgorithm) {
                checkoutLockAlgorithm.releaseLock(schemaName, jobId + "");
            }
        }
    }
}

