/*
 * Decompiled with CFR 0.152.
 */
package org.apache.shardingsphere.data.pipeline.core.lock;

import com.google.common.collect.Maps;
import java.util.Map;
import org.apache.shardingsphere.data.pipeline.core.context.PipelineContext;
import org.apache.shardingsphere.mode.manager.cluster.coordinator.lock.service.LockRegistryService;
import org.apache.shardingsphere.mode.metadata.persist.MetaDataPersistService;
import org.apache.shardingsphere.mode.repository.cluster.ClusterPersistRepository;

public final class ScalingSchemaNameDistributeLock {
    private static volatile ScalingSchemaNameDistributeLock instance;
    private final LockRegistryService lockRegistryService;
    private final Map<String, Boolean> lockNameLockedMap;

    private ScalingSchemaNameDistributeLock() {
        ClusterPersistRepository repository = (ClusterPersistRepository)((MetaDataPersistService)PipelineContext.getContextManager().getMetaDataContexts().getMetaDataPersistService().get()).getRepository();
        this.lockRegistryService = new LockRegistryService(repository);
        this.lockNameLockedMap = Maps.newConcurrentMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static ScalingSchemaNameDistributeLock getInstance() {
        if (null != instance) return instance;
        Class<ScalingSchemaNameDistributeLock> clazz = ScalingSchemaNameDistributeLock.class;
        synchronized (ScalingSchemaNameDistributeLock.class) {
            if (null != instance) return instance;
            instance = new ScalingSchemaNameDistributeLock();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public boolean tryLock(String lockName, long timeoutMilliseconds) {
        boolean locked = this.lockRegistryService.tryLock(this.decorateLockName(lockName), timeoutMilliseconds);
        if (locked) {
            this.lockNameLockedMap.put(lockName, true);
        }
        return locked;
    }

    public void releaseLock(String lockName) {
        if (this.lockNameLockedMap.getOrDefault(lockName, false).booleanValue()) {
            this.lockNameLockedMap.remove(lockName);
            this.lockRegistryService.releaseLock(this.decorateLockName(lockName));
        }
    }

    private String decorateLockName(String schemaName) {
        return "Scaling-" + schemaName;
    }
}

